package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkTradeDiscountBillGetResponse;

/**
 * TOP API: alibaba.wdk.trade.discount.bill.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.01.10
 */
public class AlibabaWdkTradeDiscountBillGetRequest extends BaseTaobaoRequest<AlibabaWdkTradeDiscountBillGetResponse> {
	
	

	/** 
	* 请求参数
	 */
	private String param0;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(OrderDiscountBillQueryRequest param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.trade.discount.bill.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkTradeDiscountBillGetResponse> getResponseClass() {
		return AlibabaWdkTradeDiscountBillGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 请求参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OrderDiscountBillQueryRequest extends TaobaoObject {

	private static final long serialVersionUID = 3826867537364226356L;

	/**
		 * 查询结束时间
		 */
		@ApiField("end_time")
		private Date endTime;
		/**
		 * 传入上一次查询结果的next_id，第一次查询时传0
		 */
		@ApiField("next_id")
		private Long nextId;
		/**
		 * 订单渠道 1代表"轻POS",2代表"淘鲜达",默认为 1
		 */
		@ApiField("order_channel")
		private Long orderChannel;
		/**
		 * 外部门店编码
		 */
		@ApiField("out_shop_code")
		private String outShopCode;
		/**
		 * 每页数量
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 查询开始时间
		 */
		@ApiField("start_time")
		private Date startTime;
		/**
		 * 经营店id，store_id和out_shop_code不能同时为空
		 */
		@ApiField("store_id")
		private String storeId;
	

	public Date getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Date endTime) {
			this.endTime = endTime;
		}
		public Long getNextId() {
			return this.nextId;
		}
		public void setNextId(Long nextId) {
			this.nextId = nextId;
		}
		public Long getOrderChannel() {
			return this.orderChannel;
		}
		public void setOrderChannel(Long orderChannel) {
			this.orderChannel = orderChannel;
		}
		public String getOutShopCode() {
			return this.outShopCode;
		}
		public void setOutShopCode(String outShopCode) {
			this.outShopCode = outShopCode;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Date getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Date startTime) {
			this.startTime = startTime;
		}
		public String getStoreId() {
			return this.storeId;
		}
		public void setStoreId(String storeId) {
			this.storeId = storeId;
		}

}


}