package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.CainiaoEndpointLockerTopOrderTrackingNewResponse;

/**
 * TOP API: cainiao.endpoint.locker.top.order.tracking.new request
 * 
 * @author top auto create
 * @since 1.0, 2024.11.08
 */
public class CainiaoEndpointLockerTopOrderTrackingNewRequest extends BaseTaobaoRequest<CainiaoEndpointLockerTopOrderTrackingNewResponse> {
	
	

	/** 
	* 回传信息
	 */
	private String trackInfo;

	public void setTrackInfo(String trackInfo) {
		this.trackInfo = trackInfo;
	}

	public void setTrackInfo(CollectTrackingInfo trackInfo) {
		this.trackInfo = new JSONWriter(false,true).write(trackInfo);
	}

	public String getTrackInfo() {
		return this.trackInfo;
	}

	public String getApiMethodName() {
		return "cainiao.endpoint.locker.top.order.tracking.new";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("track_info", this.trackInfo);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoEndpointLockerTopOrderTrackingNewResponse> getResponseClass() {
		return CainiaoEndpointLockerTopOrderTrackingNewResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 回传信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CollectTrackingInfo extends TaobaoObject {

	private static final long serialVersionUID = 3873959643137749632L;

	/**
		 * 动作编码
		 */
		@ApiField("action_code")
		private String actionCode;
		/**
		 * 动作发生时间戳，单位：毫秒
		 */
		@ApiField("action_time")
		private Long actionTime;
		/**
		 * 快递公司编号
		 */
		@ApiField("cp_code")
		private String cpCode;
		/**
		 * 扩展数据（JSON格式的键值对），如果是取件码取件，请返回取件使用的取件码
		 */
		@ApiField("extra")
		private String extra;
		/**
		 * 订单对应的取件人电话
		 */
		@ApiField("getter_phone")
		private String getterPhone;
		/**
		 * 运单号
		 */
		@ApiField("mail_no")
		private String mailNo;
		/**
		 * 站点订单编码
		 */
		@ApiField("order_code")
		private String orderCode;
		/**
		 * 订单类型(0-代收业务)
		 */
		@ApiField("order_type")
		private Long orderType;
		/**
		 * 订单对应的投件人电话
		 */
		@ApiField("post_phone")
		private String postPhone;
		/**
		 * 站点id
		 */
		@ApiField("station_id")
		private String stationId;
		/**
		 * 站点编码
		 */
		@ApiField("station_no")
		private String stationNo;
	

	public String getActionCode() {
			return this.actionCode;
		}
		public void setActionCode(String actionCode) {
			this.actionCode = actionCode;
		}
		public Long getActionTime() {
			return this.actionTime;
		}
		public void setActionTime(Long actionTime) {
			this.actionTime = actionTime;
		}
		public String getCpCode() {
			return this.cpCode;
		}
		public void setCpCode(String cpCode) {
			this.cpCode = cpCode;
		}
		public String getExtra() {
			return this.extra;
		}
		public void setExtra(String extra) {
			this.extra = extra;
		}
		public String getGetterPhone() {
			return this.getterPhone;
		}
		public void setGetterPhone(String getterPhone) {
			this.getterPhone = getterPhone;
		}
		public String getMailNo() {
			return this.mailNo;
		}
		public void setMailNo(String mailNo) {
			this.mailNo = mailNo;
		}
		public String getOrderCode() {
			return this.orderCode;
		}
		public void setOrderCode(String orderCode) {
			this.orderCode = orderCode;
		}
		public Long getOrderType() {
			return this.orderType;
		}
		public void setOrderType(Long orderType) {
			this.orderType = orderType;
		}
		public String getPostPhone() {
			return this.postPhone;
		}
		public void setPostPhone(String postPhone) {
			this.postPhone = postPhone;
		}
		public String getStationId() {
			return this.stationId;
		}
		public void setStationId(String stationId) {
			this.stationId = stationId;
		}
		public String getStationNo() {
			return this.stationNo;
		}
		public void setStationNo(String stationNo) {
			this.stationNo = stationNo;
		}

}


}