package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.LogisticsFulfilorderSearchResponse;

/**
 * TOP API: taobao.logistics.fulfilorder.search request
 * 
 * @author top auto create
 * @since 1.0, 2024.10.12
 */
public class LogisticsFulfilorderSearchRequest extends BaseTaobaoRequest<LogisticsFulfilorderSearchResponse> {
	
	

	/** 
	* 搜索入参
	 */
	private String searchRequest;

	public void setSearchRequest(String searchRequest) {
		this.searchRequest = searchRequest;
	}

	public void setSearchRequest(ErpSearchFulfilOrdersRequest searchRequest) {
		this.searchRequest = new JSONWriter(false,true).write(searchRequest);
	}

	public String getSearchRequest() {
		return this.searchRequest;
	}

	public String getApiMethodName() {
		return "taobao.logistics.fulfilorder.search";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("search_request", this.searchRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<LogisticsFulfilorderSearchResponse> getResponseClass() {
		return LogisticsFulfilorderSearchResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 搜索入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ErpSearchFulfilOrdersRequest extends TaobaoObject {

	private static final long serialVersionUID = 3651214727712755265L;

	/**
		 * 单据修改的结束时间。开始和结束时间必须成对出现；开始时间 到 结束时间 不能超过 30 分钟。时间范围查询和交易单号查询只能选择一个，不能同时传入。在传入的时间范围内，最多支持翻页到5000条数据，超过则需要自己缩减时间范围
		 */
		@ApiField("end_modify_time")
		private Date endModifyTime;
		/**
		 * 页码。必须为正数
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 分页大小。范围 1-100
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 单据修改的开始时间。开始和结束时间必须成对出现；开始时间 到 结束时间 不能超过 30 分钟。时间范围查询和交易单号查询只能选择一个，不能同时传入。在传入的时间范围内，最多支持翻页到5000条数据，超过则需要自己缩减时间范围
		 */
		@ApiField("start_modify_time")
		private Date startModifyTime;
		/**
		 * 交易单号列表
		 */
		@ApiListField("trade_id_list")
		@ApiField("string")
		private List<String> tradeIdList;
	

	public Date getEndModifyTime() {
			return this.endModifyTime;
		}
		public void setEndModifyTime(Date endModifyTime) {
			this.endModifyTime = endModifyTime;
		}
		public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Date getStartModifyTime() {
			return this.startModifyTime;
		}
		public void setStartModifyTime(Date startModifyTime) {
			this.startModifyTime = startModifyTime;
		}
		public List<String> getTradeIdList() {
			return this.tradeIdList;
		}
		public void setTradeIdList(List<String> tradeIdList) {
			this.tradeIdList = tradeIdList;
		}

}


}