package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.LogisticsReturnorderSvcSearchResponse;

/**
 * TOP API: taobao.logistics.returnorder.svc.search request
 * 
 * @author top auto create
 * @since 1.0, 2024.05.27
 */
public class LogisticsReturnorderSvcSearchRequest extends BaseTaobaoRequest<LogisticsReturnorderSvcSearchResponse> {
	
	

	/** 
	* 查询请求
	 */
	private String returnOrderQueryReq;

	public void setReturnOrderQueryReq(String returnOrderQueryReq) {
		this.returnOrderQueryReq = returnOrderQueryReq;
	}

	public void setReturnOrderQueryReq(ReturnLogisticsInfoQueryReq returnOrderQueryReq) {
		this.returnOrderQueryReq = new JSONWriter(false,true).write(returnOrderQueryReq);
	}

	public String getReturnOrderQueryReq() {
		return this.returnOrderQueryReq;
	}

	public String getApiMethodName() {
		return "taobao.logistics.returnorder.svc.search";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("return_order_query_req", this.returnOrderQueryReq);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<LogisticsReturnorderSvcSearchResponse> getResponseClass() {
		return LogisticsReturnorderSvcSearchResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 查询请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ReturnLogisticsInfoQueryReq extends TaobaoObject {

	private static final long serialVersionUID = 6143571363211968817L;

	/**
		 * 发货运单号
		 */
		@ApiField("consign_mail_no")
		private String consignMailNo;
		/**
		 * 773284273544336
		 */
		@ApiField("return_mail_no")
		private String returnMailNo;
		/**
		 * 淘宝交易单号
		 */
		@ApiField("trade_id")
		private String tradeId;
	

	public String getConsignMailNo() {
			return this.consignMailNo;
		}
		public void setConsignMailNo(String consignMailNo) {
			this.consignMailNo = consignMailNo;
		}
		public String getReturnMailNo() {
			return this.returnMailNo;
		}
		public void setReturnMailNo(String returnMailNo) {
			this.returnMailNo = returnMailNo;
		}
		public String getTradeId() {
			return this.tradeId;
		}
		public void setTradeId(String tradeId) {
			this.tradeId = tradeId;
		}

}


}