package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.LogisticsReverseorderErpSearchResponse;

/**
 * TOP API: taobao.logistics.reverseorder.erp.search request
 * 
 * @author top auto create
 * @since 1.0, 2024.06.25
 */
public class LogisticsReverseorderErpSearchRequest extends BaseTaobaoRequest<LogisticsReverseorderErpSearchResponse> {
	
	

	/** 
	* 搜索查询选项
	 */
	private String paramErpSearchReverseOrdersOption;

	/** 
	* 搜索请求
	 */
	private String paramErpSearchReverseOrdersRequest;

	public void setParamErpSearchReverseOrdersOption(String paramErpSearchReverseOrdersOption) {
		this.paramErpSearchReverseOrdersOption = paramErpSearchReverseOrdersOption;
	}

	public void setParamErpSearchReverseOrdersOption(ErpSearchReverseOrdersOption paramErpSearchReverseOrdersOption) {
		this.paramErpSearchReverseOrdersOption = new JSONWriter(false,true).write(paramErpSearchReverseOrdersOption);
	}

	public String getParamErpSearchReverseOrdersOption() {
		return this.paramErpSearchReverseOrdersOption;
	}

	public void setParamErpSearchReverseOrdersRequest(String paramErpSearchReverseOrdersRequest) {
		this.paramErpSearchReverseOrdersRequest = paramErpSearchReverseOrdersRequest;
	}

	public void setParamErpSearchReverseOrdersRequest(ErpSearchReverseOrdersRequest paramErpSearchReverseOrdersRequest) {
		this.paramErpSearchReverseOrdersRequest = new JSONWriter(false,true).write(paramErpSearchReverseOrdersRequest);
	}

	public String getParamErpSearchReverseOrdersRequest() {
		return this.paramErpSearchReverseOrdersRequest;
	}

	public String getApiMethodName() {
		return "taobao.logistics.reverseorder.erp.search";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_erp_search_reverse_orders_option", this.paramErpSearchReverseOrdersOption);
		txtParams.put("param_erp_search_reverse_orders_request", this.paramErpSearchReverseOrdersRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<LogisticsReverseorderErpSearchResponse> getResponseClass() {
		return LogisticsReverseorderErpSearchResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 搜索请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ErpSearchReverseOrdersRequest extends TaobaoObject {

	private static final long serialVersionUID = 5692775873638621264L;

	/**
		 * 销退单最后修改时间查询条件的结束时间
		 */
		@ApiField("end_modified_time")
		private Date endModifiedTime;
		/**
		 * 扩展字段
		 */
		@ApiField("extend_fields")
		private String extendFields;
		/**
		 * 逆向物流单号
		 */
		@ApiListField("lg_order_code_list")
		@ApiField("string")
		private List<String> lgOrderCodeList;
		/**
		 * 分页信息
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 销退单最后修改时间查询条件的开始时间
		 */
		@ApiField("start_modified_time")
		private Date startModifiedTime;
		/**
		 * 交易订单ID
		 */
		@ApiListField("trade_ids")
		@ApiField("string")
		private List<String> tradeIds;
		/**
		 * 逆向仓储单号
		 */
		@ApiListField("wlb_order_code_list")
		@ApiField("string")
		private List<String> wlbOrderCodeList;
	

	public Date getEndModifiedTime() {
			return this.endModifiedTime;
		}
		public void setEndModifiedTime(Date endModifiedTime) {
			this.endModifiedTime = endModifiedTime;
		}
		public String getExtendFields() {
			return this.extendFields;
		}
		public void setExtendFields(String extendFields) {
			this.extendFields = extendFields;
		}
		public void setExtendFieldsString(String extendFields) {
			this.extendFields = extendFields;
		}
		
		public List<String> getLgOrderCodeList() {
			return this.lgOrderCodeList;
		}
		public void setLgOrderCodeList(List<String> lgOrderCodeList) {
			this.lgOrderCodeList = lgOrderCodeList;
		}
		public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Date getStartModifiedTime() {
			return this.startModifiedTime;
		}
		public void setStartModifiedTime(Date startModifiedTime) {
			this.startModifiedTime = startModifiedTime;
		}
		public List<String> getTradeIds() {
			return this.tradeIds;
		}
		public void setTradeIds(List<String> tradeIds) {
			this.tradeIds = tradeIds;
		}
		public List<String> getWlbOrderCodeList() {
			return this.wlbOrderCodeList;
		}
		public void setWlbOrderCodeList(List<String> wlbOrderCodeList) {
			this.wlbOrderCodeList = wlbOrderCodeList;
		}

}

	/**
 * 搜索查询选项
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ErpSearchReverseOrdersOption extends TaobaoObject {

	private static final long serialVersionUID = 3557789652543616191L;

	/**
		 * 是否过滤废弃单据
		 */
		@ApiField("filter_discard_status")
		private Boolean filterDiscardStatus;
		/**
		 * 是否查询对应的明细
		 */
		@ApiField("query_order_item")
		private Boolean queryOrderItem;
		/**
		 * 是否查询对应的二级明细
		 */
		@ApiField("query_order_return_item")
		private Boolean queryOrderReturnItem;
	

	public Boolean getFilterDiscardStatus() {
			return this.filterDiscardStatus;
		}
		public void setFilterDiscardStatus(Boolean filterDiscardStatus) {
			this.filterDiscardStatus = filterDiscardStatus;
		}
		public Boolean getQueryOrderItem() {
			return this.queryOrderItem;
		}
		public void setQueryOrderItem(Boolean queryOrderItem) {
			this.queryOrderItem = queryOrderItem;
		}
		public Boolean getQueryOrderReturnItem() {
			return this.queryOrderReturnItem;
		}
		public void setQueryOrderReturnItem(Boolean queryOrderReturnItem) {
			this.queryOrderReturnItem = queryOrderReturnItem;
		}

}


}