package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.WlbOrderJzConsignResponse;

/**
 * TOP API: taobao.wlb.order.jz.consign request
 * 
 * @author top auto create
 * @since 1.0, 2024.11.08
 */
public class WlbOrderJzConsignRequest extends BaseTaobaoRequest<WlbOrderJzConsignResponse> {
	
	

	/** 
	* 安装收货人信息,如果为空,则取默认收货人信息
	 */
	private String insReceiverTo;

	/** 
	* 安装公司信息,需要安装时,才填写
	 */
	private String insTpDto;

	/** 
	* 家装收货人信息,如果为空,则取默认收货信息
	 */
	private String jzReceiverTo;

	/** 
	* 发货参数
	 */
	private String jzTopArgs;

	/** 
	* 物流公司信息
	 */
	private String lgTpDto;

	/** 
	* 卖家联系人地址库ID，可以通过taobao.logistics.address.search接口查询到地址库ID。如果为空，取的卖家的默认取货地址
	 */
	private Long senderId;

	/** 
	* 交易号
	 */
	private Long tid;

	public void setInsReceiverTo(String insReceiverTo) {
		this.insReceiverTo = insReceiverTo;
	}

	public void setInsReceiverTo(JzReceiverTO insReceiverTo) {
		this.insReceiverTo = new JSONWriter(false,true).write(insReceiverTo);
	}

	public String getInsReceiverTo() {
		return this.insReceiverTo;
	}

	public void setInsTpDto(String insTpDto) {
		this.insTpDto = insTpDto;
	}

	public void setInsTpDto(TPDTO insTpDto) {
		this.insTpDto = new JSONWriter(false,true).write(insTpDto);
	}

	public String getInsTpDto() {
		return this.insTpDto;
	}

	public void setJzReceiverTo(String jzReceiverTo) {
		this.jzReceiverTo = jzReceiverTo;
	}

	public void setJzReceiverTo(JzReceiverTO jzReceiverTo) {
		this.jzReceiverTo = new JSONWriter(false,true).write(jzReceiverTo);
	}

	public String getJzReceiverTo() {
		return this.jzReceiverTo;
	}

	public void setJzTopArgs(String jzTopArgs) {
		this.jzTopArgs = jzTopArgs;
	}

	public void setJzTopArgs(JzTopArgs jzTopArgs) {
		this.jzTopArgs = new JSONWriter(false,true).write(jzTopArgs);
	}

	public String getJzTopArgs() {
		return this.jzTopArgs;
	}

	public void setLgTpDto(String lgTpDto) {
		this.lgTpDto = lgTpDto;
	}

	public void setLgTpDto(TPDTO lgTpDto) {
		this.lgTpDto = new JSONWriter(false,true).write(lgTpDto);
	}

	public String getLgTpDto() {
		return this.lgTpDto;
	}

	public void setSenderId(Long senderId) {
		this.senderId = senderId;
	}

	public Long getSenderId() {
		return this.senderId;
	}

	public void setTid(Long tid) {
		this.tid = tid;
	}

	public Long getTid() {
		return this.tid;
	}

	public String getApiMethodName() {
		return "taobao.wlb.order.jz.consign";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("ins_receiver_to", this.insReceiverTo);
		txtParams.put("ins_tp_dto", this.insTpDto);
		txtParams.put("jz_receiver_to", this.jzReceiverTo);
		txtParams.put("jz_top_args", this.jzTopArgs);
		txtParams.put("lg_tp_dto", this.lgTpDto);
		txtParams.put("sender_id", this.senderId);
		txtParams.put("tid", this.tid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<WlbOrderJzConsignResponse> getResponseClass() {
		return WlbOrderJzConsignResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(tid, "tid");
	}
	
	/**
 * 物流公司信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TPDTO extends TaobaoObject {

	private static final long serialVersionUID = 1228899658861137595L;

	/**
		 * 公司编码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 公司名称
		 */
		@ApiField("name")
		private String name;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}

}

	/**
 * 家装收货人信息,如果为空,则取默认收货信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class JzReceiverTO extends TaobaoObject {

	private static final long serialVersionUID = 5855789861263954292L;

	/**
		 * 详细地址
		 */
		@ApiField("address")
		private String address;
		/**
		 * 市
		 */
		@ApiField("city")
		private String city;
		/**
		 * 收货人名称
		 */
		@ApiField("contact_name")
		private String contactName;
		/**
		 * 国家
		 */
		@ApiField("country")
		private String country;
		/**
		 * 区
		 */
		@ApiField("district")
		private String district;
		/**
		 * 手机号
		 */
		@ApiField("mobile_phone")
		private String mobilePhone;
		/**
		 * 省
		 */
		@ApiField("province")
		private String province;
		/**
		 * 街道
		 */
		@ApiField("street")
		private String street;
		/**
		 * 座机号
		 */
		@ApiField("tele_phone")
		private String telePhone;
		/**
		 * 邮编
		 */
		@ApiField("zip_code")
		private String zipCode;
	

	public String getAddress() {
			return this.address;
		}
		public void setAddress(String address) {
			this.address = address;
		}
		public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getContactName() {
			return this.contactName;
		}
		public void setContactName(String contactName) {
			this.contactName = contactName;
		}
		public String getCountry() {
			return this.country;
		}
		public void setCountry(String country) {
			this.country = country;
		}
		public String getDistrict() {
			return this.district;
		}
		public void setDistrict(String district) {
			this.district = district;
		}
		public String getMobilePhone() {
			return this.mobilePhone;
		}
		public void setMobilePhone(String mobilePhone) {
			this.mobilePhone = mobilePhone;
		}
		public String getProvince() {
			return this.province;
		}
		public void setProvince(String province) {
			this.province = province;
		}
		public String getStreet() {
			return this.street;
		}
		public void setStreet(String street) {
			this.street = street;
		}
		public String getTelePhone() {
			return this.telePhone;
		}
		public void setTelePhone(String telePhone) {
			this.telePhone = telePhone;
		}
		public String getZipCode() {
			return this.zipCode;
		}
		public void setZipCode(String zipCode) {
			this.zipCode = zipCode;
		}

}

	/**
 * 发货参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class JzTopArgs extends TaobaoObject {

	private static final long serialVersionUID = 2346954222166535285L;

	/**
		 * 运单号,用快递或商家自有发货时,必填
		 */
		@ApiField("mail_no")
		private String mailNo;
		/**
		 * 包裹数量
		 */
		@ApiField("package_number")
		private String packageNumber;
		/**
		 * 包裹备注
		 */
		@ApiField("package_remark")
		private String packageRemark;
		/**
		 * 包裹体积
		 */
		@ApiField("package_volume")
		private String packageVolume;
		/**
		 * 包裹重量
		 */
		@ApiField("package_weight")
		private String packageWeight;
		/**
		 * 自有物流公司名称
		 */
		@ApiField("zy_company")
		private String zyCompany;
		/**
		 * 自有物流发货时间,时间不能早于当前时间
		 */
		@ApiField("zy_consign_time")
		private String zyConsignTime;
		/**
		 * 自有物流公司电话
		 */
		@ApiField("zy_phone_number")
		private String zyPhoneNumber;
	

	public String getMailNo() {
			return this.mailNo;
		}
		public void setMailNo(String mailNo) {
			this.mailNo = mailNo;
		}
		public String getPackageNumber() {
			return this.packageNumber;
		}
		public void setPackageNumber(String packageNumber) {
			this.packageNumber = packageNumber;
		}
		public String getPackageRemark() {
			return this.packageRemark;
		}
		public void setPackageRemark(String packageRemark) {
			this.packageRemark = packageRemark;
		}
		public String getPackageVolume() {
			return this.packageVolume;
		}
		public void setPackageVolume(String packageVolume) {
			this.packageVolume = packageVolume;
		}
		public String getPackageWeight() {
			return this.packageWeight;
		}
		public void setPackageWeight(String packageWeight) {
			this.packageWeight = packageWeight;
		}
		public String getZyCompany() {
			return this.zyCompany;
		}
		public void setZyCompany(String zyCompany) {
			this.zyCompany = zyCompany;
		}
		public String getZyConsignTime() {
			return this.zyConsignTime;
		}
		public void setZyConsignTime(String zyConsignTime) {
			this.zyConsignTime = zyConsignTime;
		}
		public String getZyPhoneNumber() {
			return this.zyPhoneNumber;
		}
		public void setZyPhoneNumber(String zyPhoneNumber) {
			this.zyPhoneNumber = zyPhoneNumber;
		}

}


}