package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.WlbOrderJzQueryResponse;

/**
 * TOP API: taobao.wlb.order.jz.query request
 * 
 * @author top auto create
 * @since 1.0, 2024.11.08
 */
public class WlbOrderJzQueryRequest extends BaseTaobaoRequest<WlbOrderJzQueryResponse> {
	
	

	/** 
	* 家装安装服务收货人信息
	 */
	private String insJzReceiverTO;

	/** 
	* 家装收货人信息
	 */
	private String jzReceiverTo;

	/** 
	* 卖家联系人地址库ID，可以通过taobao.logistics.address.search接口查询到地址库ID。如果为空，取的卖家的默认取货地址
	 */
	private Long senderId;

	/** 
	* 交易id
	 */
	private Long tid;

	public void setInsJzReceiverTO(String insJzReceiverTO) {
		this.insJzReceiverTO = insJzReceiverTO;
	}

	public void setInsJzReceiverTO(JzReceiverTO insJzReceiverTO) {
		this.insJzReceiverTO = new JSONWriter(false,true).write(insJzReceiverTO);
	}

	public String getInsJzReceiverTO() {
		return this.insJzReceiverTO;
	}

	public void setJzReceiverTo(String jzReceiverTo) {
		this.jzReceiverTo = jzReceiverTo;
	}

	public void setJzReceiverTo(JzReceiverTO jzReceiverTo) {
		this.jzReceiverTo = new JSONWriter(false,true).write(jzReceiverTo);
	}

	public String getJzReceiverTo() {
		return this.jzReceiverTo;
	}

	public void setSenderId(Long senderId) {
		this.senderId = senderId;
	}

	public Long getSenderId() {
		return this.senderId;
	}

	public void setTid(Long tid) {
		this.tid = tid;
	}

	public Long getTid() {
		return this.tid;
	}

	public String getApiMethodName() {
		return "taobao.wlb.order.jz.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("ins_jz_receiver_t_o", this.insJzReceiverTO);
		txtParams.put("jz_receiver_to", this.jzReceiverTo);
		txtParams.put("sender_id", this.senderId);
		txtParams.put("tid", this.tid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<WlbOrderJzQueryResponse> getResponseClass() {
		return WlbOrderJzQueryResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 家装收货人信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class JzReceiverTO extends TaobaoObject {

	private static final long serialVersionUID = 2241475314168425445L;

	/**
		 * 详细地址
		 */
		@ApiField("address")
		private String address;
		/**
		 * 市
		 */
		@ApiField("city")
		private String city;
		/**
		 * 收货人名称
		 */
		@ApiField("contact_name")
		private String contactName;
		/**
		 * 国家
		 */
		@ApiField("country")
		private String country;
		/**
		 * 区
		 */
		@ApiField("district")
		private String district;
		/**
		 * 手机号
		 */
		@ApiField("mobile_phone")
		private String mobilePhone;
		/**
		 * 省
		 */
		@ApiField("province")
		private String province;
		/**
		 * 街道
		 */
		@ApiField("street")
		private String street;
		/**
		 * 座机号
		 */
		@ApiField("tele_phone")
		private String telePhone;
		/**
		 * 邮编
		 */
		@ApiField("zip_code")
		private String zipCode;
	

	public String getAddress() {
			return this.address;
		}
		public void setAddress(String address) {
			this.address = address;
		}
		public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getContactName() {
			return this.contactName;
		}
		public void setContactName(String contactName) {
			this.contactName = contactName;
		}
		public String getCountry() {
			return this.country;
		}
		public void setCountry(String country) {
			this.country = country;
		}
		public String getDistrict() {
			return this.district;
		}
		public void setDistrict(String district) {
			this.district = district;
		}
		public String getMobilePhone() {
			return this.mobilePhone;
		}
		public void setMobilePhone(String mobilePhone) {
			this.mobilePhone = mobilePhone;
		}
		public String getProvince() {
			return this.province;
		}
		public void setProvince(String province) {
			this.province = province;
		}
		public String getStreet() {
			return this.street;
		}
		public void setStreet(String street) {
			this.street = street;
		}
		public String getTelePhone() {
			return this.telePhone;
		}
		public void setTelePhone(String telePhone) {
			this.telePhone = telePhone;
		}
		public String getZipCode() {
			return this.zipCode;
		}
		public void setZipCode(String zipCode) {
			this.zipCode = zipCode;
		}

}


}