package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.ascp.logistics.identcode.query response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaAscpLogisticsIdentcodeQueryResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5625613496516122321L;

	/** 
	 * 请求结果
	 */
	@ApiField("result")
	private ResultDTO result;


	public void setResult(ResultDTO result) {
		this.result = result;
	}
	public ResultDTO getResult( ) {
		return this.result;
	}
	
	/**
 * 识别码列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopIdentCodeDTO extends TaobaoObject {

	private static final long serialVersionUID = 3867617148828786198L;

	/**
		 * 是否可用
		 */
		@ApiField("available")
		private Boolean available;
		/**
		 * 品牌ID
		 */
		@ApiField("brand_id")
		private String brandId;
		/**
		 * 识别码
		 */
		@ApiField("ident_code")
		private String identCode;
		/**
		 * 识别码类型，SNIMEI
		 */
		@ApiField("ident_type")
		private String identType;
		/**
		 * 根类目ID
		 */
		@ApiField("root_cat_id")
		private String rootCatId;
		/**
		 * 不可用原因
		 */
		@ApiField("un_available_reason")
		private String unAvailableReason;
	

	public Boolean getAvailable() {
			return this.available;
		}
		public void setAvailable(Boolean available) {
			this.available = available;
		}
		public String getBrandId() {
			return this.brandId;
		}
		public void setBrandId(String brandId) {
			this.brandId = brandId;
		}
		public String getIdentCode() {
			return this.identCode;
		}
		public void setIdentCode(String identCode) {
			this.identCode = identCode;
		}
		public String getIdentType() {
			return this.identType;
		}
		public void setIdentType(String identType) {
			this.identType = identType;
		}
		public String getRootCatId() {
			return this.rootCatId;
		}
		public void setRootCatId(String rootCatId) {
			this.rootCatId = rootCatId;
		}
		public String getUnAvailableReason() {
			return this.unAvailableReason;
		}
		public void setUnAvailableReason(String unAvailableReason) {
			this.unAvailableReason = unAvailableReason;
		}

}

	/**
 * 请求结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ResultDTO extends TaobaoObject {

	private static final long serialVersionUID = 7376251468152599249L;

	/**
		 * 识别码列表
		 */
		@ApiListField("ident_code_list")
		@ApiField("top_ident_code_d_t_o")
		private List<TopIdentCodeDTO> identCodeList;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public List<TopIdentCodeDTO> getIdentCodeList() {
			return this.identCodeList;
		}
		public void setIdentCodeList(List<TopIdentCodeDTO> identCodeList) {
			this.identCodeList = identCodeList;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
