package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.hm.marketing.coupon.queryitems response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaHmMarketingCouponQueryitemsResponse extends TaobaoResponse {

	private static final long serialVersionUID = 8356149428553376922L;

	/** 
	 * 查询返回结果
	 */
	@ApiField("result")
	private MarketPageResult result;


	public void setResult(MarketPageResult result) {
		this.result = result;
	}
	public MarketPageResult getResult( ) {
		return this.result;
	}
	
	/**
 * 返回的数据
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemCouponSku extends TaobaoObject {

	private static final long serialVersionUID = 6182837676732395258L;

	/**
		 * 淘宝item和shop的对应关系， k-itemId, v-shopId
		 */
		@ApiField("item_shop_relation")
		private String itemShopRelation;
		/**
		 * 商品的skuCode
		 */
		@ApiField("sku_code")
		private String skuCode;
		/**
		 * 商品名称
		 */
		@ApiField("sku_name")
		private String skuName;
	

	public String getItemShopRelation() {
			return this.itemShopRelation;
		}
		public void setItemShopRelation(String itemShopRelation) {
			this.itemShopRelation = itemShopRelation;
		}
		public void setItemShopRelationString(String itemShopRelation) {
			this.itemShopRelation = itemShopRelation;
		}
		
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}
		public String getSkuName() {
			return this.skuName;
		}
		public void setSkuName(String skuName) {
			this.skuName = skuName;
		}

}

	/**
 * 查询返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MarketPageResult extends TaobaoObject {

	private static final long serialVersionUID = 3498184923827494163L;

	/**
		 * 当前分页
		 */
		@ApiField("current")
		private Long current;
		/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 返回的数据
		 */
		@ApiListField("item_coupon_sku_list")
		@ApiField("item_coupon_sku")
		private List<ItemCouponSku> itemCouponSkuList;
		/**
		 * 错误信息
		 */
		@ApiField("message")
		private String message;
		/**
		 * 页面大小
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 查询商品是否成功
		 */
		@ApiField("success")
		private Boolean success;
		/**
		 * 参加当前活动的商品总数
		 */
		@ApiField("total")
		private Long total;
		/**
		 * 总页数
		 */
		@ApiField("total_page")
		private Long totalPage;
	

	public Long getCurrent() {
			return this.current;
		}
		public void setCurrent(Long current) {
			this.current = current;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public List<ItemCouponSku> getItemCouponSkuList() {
			return this.itemCouponSkuList;
		}
		public void setItemCouponSkuList(List<ItemCouponSku> itemCouponSkuList) {
			this.itemCouponSkuList = itemCouponSkuList;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}
		public Long getTotal() {
			return this.total;
		}
		public void setTotal(Long total) {
			this.total = total;
		}
		public Long getTotalPage() {
			return this.totalPage;
		}
		public void setTotalPage(Long totalPage) {
			this.totalPage = totalPage;
		}

}



}
