package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.hm.marketing.discount.item.add.async response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaHmMarketingDiscountItemAddAsyncResponse extends TaobaoResponse {

	private static final long serialVersionUID = 3872987639385455458L;

	/** 
	 * 结果信息
	 */
	@ApiField("result")
	private MarketResult result;


	public void setResult(MarketResult result) {
		this.result = result;
	}
	public MarketResult getResult( ) {
		return this.result;
	}
	
	/**
 * 结果数据
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemDiscountSku extends TaobaoObject {

	private static final long serialVersionUID = 7533627149799514428L;

	/**
		 * sku编码
		 */
		@ApiField("sku_code")
		private String skuCode;
		/**
		 * <优惠明细,分为单位>优惠类型为[减价],则代表直降金额[如700,表示商品直降7元];优惠券类型为[一口价],则代表一口价[如700,表示商品一口价为7元];优惠券类型为[打折],则代表折扣[如700,表示打7折]
		 */
		@ApiField("value")
		private Long value;
	

	public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}
		public Long getValue() {
			return this.value;
		}
		public void setValue(Long value) {
			this.value = value;
		}

}

	/**
 * 结果信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MarketResult extends TaobaoObject {

	private static final long serialVersionUID = 7751358341363635957L;

	/**
		 * 结果数据
		 */
		@ApiListField("datas")
		@ApiField("item_discount_sku")
		private List<ItemDiscountSku> datas;
		/**
		 * 错误编码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 处理结果
		 */
		@ApiField("message")
		private String message;
		/**
		 * success
		 */
		@ApiField("success")
		private Boolean success;
	

	public List<ItemDiscountSku> getDatas() {
			return this.datas;
		}
		public void setDatas(List<ItemDiscountSku> datas) {
			this.datas = datas;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
