package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.hm.marketing.expire.promotion.query response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaHmMarketingExpirePromotionQueryResponse extends TaobaoResponse {

	private static final long serialVersionUID = 4332525936364385956L;

	/** 
	 * result
	 */
	@ApiField("result")
	private MarketResult result;


	public void setResult(MarketResult result) {
		this.result = result;
	}
	public MarketResult getResult( ) {
		return this.result;
	}
	
	/**
 * 优惠详情
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ExpirePeriodInfo extends TaobaoObject {

	private static final long serialVersionUID = 3557838655927699241L;

	/**
		 * 优惠结束时间（距离过期时间）
		 */
		@ApiField("end_hour")
		private Long endHour;
		/**
		 * 外部优惠id
		 */
		@ApiField("out_id")
		private Long outId;
		/**
		 * 优惠值
		 */
		@ApiField("promotion_value")
		private Long promotionValue;
		/**
		 * 优惠开始时间（距离过期时间）
		 */
		@ApiField("start_hour")
		private Long startHour;
	

	public Long getEndHour() {
			return this.endHour;
		}
		public void setEndHour(Long endHour) {
			this.endHour = endHour;
		}
		public Long getOutId() {
			return this.outId;
		}
		public void setOutId(Long outId) {
			this.outId = outId;
		}
		public Long getPromotionValue() {
			return this.promotionValue;
		}
		public void setPromotionValue(Long promotionValue) {
			this.promotionValue = promotionValue;
		}
		public Long getStartHour() {
			return this.startHour;
		}
		public void setStartHour(Long startHour) {
			this.startHour = startHour;
		}

}

	/**
 * data
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ExpirePromotionBo extends TaobaoObject {

	private static final long serialVersionUID = 7656948827793294664L;

	/**
		 * 商家code
		 */
		@ApiField("merchant_code")
		private String merchantCode;
		/**
		 * 优惠详情
		 */
		@ApiListField("period_infos")
		@ApiField("expire_period_info")
		private List<ExpirePeriodInfo> periodInfos;
		/**
		 * 门店
		 */
		@ApiListField("shop_ids")
		@ApiField("string")
		private List<String> shopIds;
		/**
		 * 商品
		 */
		@ApiField("sku_code")
		private String skuCode;
	

	public String getMerchantCode() {
			return this.merchantCode;
		}
		public void setMerchantCode(String merchantCode) {
			this.merchantCode = merchantCode;
		}
		public List<ExpirePeriodInfo> getPeriodInfos() {
			return this.periodInfos;
		}
		public void setPeriodInfos(List<ExpirePeriodInfo> periodInfos) {
			this.periodInfos = periodInfos;
		}
		public List<String> getShopIds() {
			return this.shopIds;
		}
		public void setShopIds(List<String> shopIds) {
			this.shopIds = shopIds;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}

}

	/**
 * result
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MarketResult extends TaobaoObject {

	private static final long serialVersionUID = 7171957581455495253L;

	/**
		 * data
		 */
		@ApiField("data")
		private ExpirePromotionBo data;
		/**
		 * errorCode
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * success
		 */
		@ApiField("is_success")
		private Boolean isSuccess;
		/**
		 * message
		 */
		@ApiField("message")
		private String message;
	

	public ExpirePromotionBo getData() {
			return this.data;
		}
		public void setData(ExpirePromotionBo data) {
			this.data = data;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public Boolean getIsSuccess() {
			return this.isSuccess;
		}
		public void setIsSuccess(Boolean isSuccess) {
			this.isSuccess = isSuccess;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}

}



}
