package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.hm.marketing.fullrange.queryactivity response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaHmMarketingFullrangeQueryactivityResponse extends TaobaoResponse {

	private static final long serialVersionUID = 2187892486127482265L;

	/** 
	 * 查询返回结果
	 */
	@ApiField("result")
	private MarketResult result;


	public void setResult(MarketResult result) {
		this.result = result;
	}
	public MarketResult getResult( ) {
		return this.result;
	}
	
	/**
 * 通用限购信息，-1为不限制，默认为不限制
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LimitInfo extends TaobaoObject {

	private static final long serialVersionUID = 1216316633154971549L;

	/**
		 * 活动每日总限购
		 */
		@ApiField("daily_limit_cnt")
		private Long dailyLimitCnt;
		/**
		 * 每人每日限购
		 */
		@ApiField("user_daily_limit_cnt")
		private Long userDailyLimitCnt;
		/**
		 * 每人活动期间总限购
		 */
		@ApiField("user_limit_cnt")
		private Long userLimitCnt;
	

	public Long getDailyLimitCnt() {
			return this.dailyLimitCnt;
		}
		public void setDailyLimitCnt(Long dailyLimitCnt) {
			this.dailyLimitCnt = dailyLimitCnt;
		}
		public Long getUserDailyLimitCnt() {
			return this.userDailyLimitCnt;
		}
		public void setUserDailyLimitCnt(Long userDailyLimitCnt) {
			this.userDailyLimitCnt = userDailyLimitCnt;
		}
		public Long getUserLimitCnt() {
			return this.userLimitCnt;
		}
		public void setUserLimitCnt(Long userLimitCnt) {
			this.userLimitCnt = userLimitCnt;
		}

}

	/**
 * 活动的梯度列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Rulestairs extends TaobaoObject {

	private static final long serialVersionUID = 4311942476372129577L;

	/**
		 * 满多少元[单位为分，传入700，代表满7元]，amountAt为true时，必须设置
		 */
		@ApiField("amount")
		private Long amount;
		/**
		 * 是否使用满元条件，不能与满件、N件Y折同时使用。此选项为true时，countAt和countBegin必须为false
		 */
		@ApiField("amount_at")
		private Boolean amountAt;
		/**
		 * 如果为换购活动，则代表此阶梯可换购的商品数量
		 */
		@ApiField("can_extra_item_num")
		private Long canExtraItemNum;
	

	public Long getAmount() {
			return this.amount;
		}
		public void setAmount(Long amount) {
			this.amount = amount;
		}
		public Boolean getAmountAt() {
			return this.amountAt;
		}
		public void setAmountAt(Boolean amountAt) {
			this.amountAt = amountAt;
		}
		public Long getCanExtraItemNum() {
			return this.canExtraItemNum;
		}
		public void setCanExtraItemNum(Long canExtraItemNum) {
			this.canExtraItemNum = canExtraItemNum;
		}

}

	/**
 * 返回活动信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemPoolActivity extends TaobaoObject {

	private static final long serialVersionUID = 3575378387192214767L;

	/**
		 * 报名活动Id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 活动名称
		 */
		@ApiField("activity_name")
		private String activityName;
		/**
		 * 活动描述
		 */
		@ApiField("description")
		private String description;
		/**
		 * endTime
		 */
		@ApiField("end_time")
		private Long endTime;
		/**
		 * 通用限购信息，-1为不限制，默认为不限制
		 */
		@ApiField("limit_info")
		private LimitInfo limitInfo;
		/**
		 * 会员维度活动参与人群限制：-1:不限制 1:会员专享 2:非会员专享
		 */
		@ApiField("member_limit")
		private Long memberLimit;
		/**
		 * merchantCrowdCode
		 */
		@ApiField("merchant_crowd_code")
		private String merchantCrowdCode;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
		/**
		 * 活动的梯度列表
		 */
		@ApiListField("rule_stairs")
		@ApiField("rulestairs")
		private List<Rulestairs> ruleStairs;
		/**
		 * shopIds
		 */
		@ApiListField("shop_ids")
		@ApiField("string")
		private List<String> shopIds;
		/**
		 * startTime
		 */
		@ApiField("start_time")
		private Long startTime;
		/**
		 * 优惠适用场景:APP|POS|POS+APP 分别对应的值为1|2|1,2
		 */
		@ApiListField("terminals")
		@ApiField("number")
		private List<Long> terminals;
		/**
		 * txdCrowdCode
		 */
		@ApiField("txd_crowd_code")
		private String txdCrowdCode;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getActivityName() {
			return this.activityName;
		}
		public void setActivityName(String activityName) {
			this.activityName = activityName;
		}
		public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public Long getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Long endTime) {
			this.endTime = endTime;
		}
		public LimitInfo getLimitInfo() {
			return this.limitInfo;
		}
		public void setLimitInfo(LimitInfo limitInfo) {
			this.limitInfo = limitInfo;
		}
		public Long getMemberLimit() {
			return this.memberLimit;
		}
		public void setMemberLimit(Long memberLimit) {
			this.memberLimit = memberLimit;
		}
		public String getMerchantCrowdCode() {
			return this.merchantCrowdCode;
		}
		public void setMerchantCrowdCode(String merchantCrowdCode) {
			this.merchantCrowdCode = merchantCrowdCode;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}
		public List<Rulestairs> getRuleStairs() {
			return this.ruleStairs;
		}
		public void setRuleStairs(List<Rulestairs> ruleStairs) {
			this.ruleStairs = ruleStairs;
		}
		public List<String> getShopIds() {
			return this.shopIds;
		}
		public void setShopIds(List<String> shopIds) {
			this.shopIds = shopIds;
		}
		public Long getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Long startTime) {
			this.startTime = startTime;
		}
		public List<Long> getTerminals() {
			return this.terminals;
		}
		public void setTerminals(List<Long> terminals) {
			this.terminals = terminals;
		}
		public String getTxdCrowdCode() {
			return this.txdCrowdCode;
		}
		public void setTxdCrowdCode(String txdCrowdCode) {
			this.txdCrowdCode = txdCrowdCode;
		}

}

	/**
 * 查询返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MarketResult extends TaobaoObject {

	private static final long serialVersionUID = 3424863896782525852L;

	/**
		 * 返回活动信息
		 */
		@ApiField("data")
		private ItemPoolActivity data;
		/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误信息
		 */
		@ApiField("message")
		private String message;
		/**
		 * 查询商品是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public ItemPoolActivity getData() {
			return this.data;
		}
		public void setData(ItemPoolActivity data) {
			this.data = data;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
