package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.hm.marketing.itembuygift.queryactivity response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaHmMarketingItembuygiftQueryactivityResponse extends TaobaoResponse {

	private static final long serialVersionUID = 8754429484134846954L;

	/** 
	 * 查询返回结果
	 */
	@ApiField("result")
	private MarketResult result;


	public void setResult(MarketResult result) {
		this.result = result;
	}
	public MarketResult getResult( ) {
		return this.result;
	}
	
	/**
 * 查询返回的活动信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemBuyGiftActivity extends TaobaoObject {

	private static final long serialVersionUID = 6615444315871912631L;

	/**
		 * 五道口活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 买赠活动名称，不超过10个英文字符
		 */
		@ApiField("activity_name")
		private String activityName;
		/**
		 * 买赠活动详情描述,不超过30个英文字符
		 */
		@ApiField("description")
		private String description;
		/**
		 * 结束时间，时间戳
		 */
		@ApiField("end_time")
		private Long endTime;
		/**
		 * 会员维度活动参与人群限制：-1:不限制 1:会员专享 2:非会员专享
		 */
		@ApiField("member_limit")
		private Long memberLimit;
		/**
		 * 商家人群编码
		 */
		@ApiField("merchant_crowd_code")
		private String merchantCrowdCode;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
		/**
		 * 参加活动的渠道店ids
		 */
		@ApiField("shop_ids")
		private String shopIds;
		/**
		 * 开始时间，时间戳
		 */
		@ApiField("start_time")
		private Long startTime;
		/**
		 * 优惠适用场景:APP|POS|POS+APP 分别对应的值为1|2|1,2
		 */
		@ApiListField("terminals")
		@ApiField("number")
		private List<Long> terminals;
		/**
		 * 淘鲜达人群编码
		 */
		@ApiField("txd_crowd_code")
		private String txdCrowdCode;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getActivityName() {
			return this.activityName;
		}
		public void setActivityName(String activityName) {
			this.activityName = activityName;
		}
		public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public Long getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Long endTime) {
			this.endTime = endTime;
		}
		public Long getMemberLimit() {
			return this.memberLimit;
		}
		public void setMemberLimit(Long memberLimit) {
			this.memberLimit = memberLimit;
		}
		public String getMerchantCrowdCode() {
			return this.merchantCrowdCode;
		}
		public void setMerchantCrowdCode(String merchantCrowdCode) {
			this.merchantCrowdCode = merchantCrowdCode;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}
		public String getShopIds() {
			return this.shopIds;
		}
		public void setShopIds(String shopIds) {
			this.shopIds = shopIds;
		}
		public Long getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Long startTime) {
			this.startTime = startTime;
		}
		public List<Long> getTerminals() {
			return this.terminals;
		}
		public void setTerminals(List<Long> terminals) {
			this.terminals = terminals;
		}
		public String getTxdCrowdCode() {
			return this.txdCrowdCode;
		}
		public void setTxdCrowdCode(String txdCrowdCode) {
			this.txdCrowdCode = txdCrowdCode;
		}

}

	/**
 * 查询返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MarketResult extends TaobaoObject {

	private static final long serialVersionUID = 2269992425442114144L;

	/**
		 * 查询返回的活动信息
		 */
		@ApiField("data")
		private ItemBuyGiftActivity data;
		/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误信息
		 */
		@ApiField("message")
		private String message;
		/**
		 * 查询活动是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public ItemBuyGiftActivity getData() {
			return this.data;
		}
		public void setData(ItemBuyGiftActivity data) {
			this.data = data;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
