package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.wdk.coupon.sku.query response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaWdkCouponSkuQueryResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5844272991157414975L;

	/** 
	 * 结果
	 */
	@ApiField("result")
	private ApiResult result;


	public void setResult(ApiResult result) {
		this.result = result;
	}
	public ApiResult getResult( ) {
		return this.result;
	}
	
	/**
 * 分页信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PageInfo extends TaobaoObject {

	private static final long serialVersionUID = 5312918216464514879L;

	/**
		 * 第几页
		 */
		@ApiField("page_num")
		private Long pageNum;
		/**
		 * 每页条数
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 总共多少页
		 */
		@ApiField("pages")
		private Long pages;
		/**
		 * 总共多少条
		 */
		@ApiField("total")
		private Long total;
	

	public Long getPageNum() {
			return this.pageNum;
		}
		public void setPageNum(Long pageNum) {
			this.pageNum = pageNum;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Long getPages() {
			return this.pages;
		}
		public void setPages(Long pages) {
			this.pages = pages;
		}
		public Long getTotal() {
			return this.total;
		}
		public void setTotal(Long total) {
			this.total = total;
		}

}

	/**
 * 券圈品设置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PromActSku extends TaobaoObject {

	private static final long serialVersionUID = 3386761936529661682L;

	/**
		 * 商家逻辑分组序号
		 */
		@ApiField("logic_group_number")
		private Long logicGroupNumber;
		/**
		 * 参与者id
		 */
		@ApiField("participate_id")
		private String participateId;
		/**
		 * 参与者名称
		 */
		@ApiField("participate_name")
		private String participateName;
		/**
		 * 参与者类型
		 */
		@ApiField("participate_type")
		private Long participateType;
	

	public Long getLogicGroupNumber() {
			return this.logicGroupNumber;
		}
		public void setLogicGroupNumber(Long logicGroupNumber) {
			this.logicGroupNumber = logicGroupNumber;
		}
		public String getParticipateId() {
			return this.participateId;
		}
		public void setParticipateId(String participateId) {
			this.participateId = participateId;
		}
		public String getParticipateName() {
			return this.participateName;
		}
		public void setParticipateName(String participateName) {
			this.participateName = participateName;
		}
		public Long getParticipateType() {
			return this.participateType;
		}
		public void setParticipateType(Long participateType) {
			this.participateType = participateType;
		}

}

	/**
 * 返回
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateOperateResponse extends TaobaoObject {

	private static final long serialVersionUID = 8158987397788293161L;

	/**
		 * 模板表主键
		 */
		@ApiField("id")
		private Long id;
		/**
		 * 分页信息
		 */
		@ApiField("page_info")
		private PageInfo pageInfo;
		/**
		 * 券圈品设置
		 */
		@ApiListField("prom_act_sku_list")
		@ApiField("prom_act_sku")
		private List<PromActSku> promActSkuList;
		/**
		 * ump模板ID
		 */
		@ApiField("source_id")
		private Long sourceId;
	

	public Long getId() {
			return this.id;
		}
		public void setId(Long id) {
			this.id = id;
		}
		public PageInfo getPageInfo() {
			return this.pageInfo;
		}
		public void setPageInfo(PageInfo pageInfo) {
			this.pageInfo = pageInfo;
		}
		public List<PromActSku> getPromActSkuList() {
			return this.promActSkuList;
		}
		public void setPromActSkuList(List<PromActSku> promActSkuList) {
			this.promActSkuList = promActSkuList;
		}
		public Long getSourceId() {
			return this.sourceId;
		}
		public void setSourceId(Long sourceId) {
			this.sourceId = sourceId;
		}

}

	/**
 * 结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ApiResult extends TaobaoObject {

	private static final long serialVersionUID = 4533669373245473736L;

	/**
		 * 错误码
		 */
		@ApiField("err_code")
		private String errCode;
		/**
		 * 错误信息
		 */
		@ApiField("err_msg")
		private String errMsg;
		/**
		 * 返回
		 */
		@ApiField("model")
		private CouponTemplateOperateResponse model;
		/**
		 * 成功标志
		 */
		@ApiField("success")
		private Boolean success;
	

	public String getErrCode() {
			return this.errCode;
		}
		public void setErrCode(String errCode) {
			this.errCode = errCode;
		}
		public String getErrMsg() {
			return this.errMsg;
		}
		public void setErrMsg(String errMsg) {
			this.errMsg = errMsg;
		}
		public CouponTemplateOperateResponse getModel() {
			return this.model;
		}
		public void setModel(CouponTemplateOperateResponse model) {
			this.model = model;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
