package com.taobao.api.response;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.wdk.marketing.coupon.additem response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaWdkMarketingCouponAdditemResponse extends TaobaoResponse {

	private static final long serialVersionUID = 4112751529589563342L;

	/** 
	 * 商品报名活动的返回结果
	 */
	@ApiField("result")
	private MarketResult result;


	public void setResult(MarketResult result) {
		this.result = result;
	}
	public MarketResult getResult( ) {
		return this.result;
	}
	
	/**
 * 报名活动成功的商品详情
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemCouponSku extends TaobaoObject {

	private static final long serialVersionUID = 7566699624745772967L;

	/**
		 * 淘宝item和shop的对应关系， k-itemId, v-shopId
		 */
		@ApiField("item_shop_relation")
		private String itemShopRelation;
		/**
		 * 商品的skuCode
		 */
		@ApiField("sku_code")
		private String skuCode;
		/**
		 * 商品名称
		 */
		@ApiField("sku_name")
		private String skuName;
	

	public String getItemShopRelation() {
			return this.itemShopRelation;
		}
		public void setItemShopRelation(String itemShopRelation) {
			this.itemShopRelation = itemShopRelation;
		}
		public void setItemShopRelationString(String itemShopRelation) {
			this.itemShopRelation = itemShopRelation;
		}
		
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}
		public String getSkuName() {
			return this.skuName;
		}
		public void setSkuName(String skuName) {
			this.skuName = skuName;
		}

}

	/**
 * 商品报名活动的返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MarketResult extends TaobaoObject {

	private static final long serialVersionUID = 2467821829927847275L;

	/**
		 * 报名活动成功的商品详情
		 */
		@ApiField("data")
		private ItemCouponSku data;
		/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误信息
		 */
		@ApiField("message")
		private String message;
		/**
		 * 是否报名成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public ItemCouponSku getData() {
			return this.data;
		}
		public void setData(ItemCouponSku data) {
			this.data = data;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
