package com.taobao.api.response;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.wdk.marketing.itembuygift.additem response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaWdkMarketingItembuygiftAdditemResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5637719725624813855L;

	/** 
	 * 商品报名活动的返回结果
	 */
	@ApiField("result")
	private MarketResult result;


	public void setResult(MarketResult result) {
		this.result = result;
	}
	public MarketResult getResult( ) {
		return this.result;
	}
	
	/**
 * 通用限购信息，-1为不限制，默认为不限制
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LimitInfo extends TaobaoObject {

	private static final long serialVersionUID = 3619458214763716977L;

	/**
		 * 活动期间总限购
		 */
		@ApiField("total_limit_cnt")
		private Long totalLimitCnt;
		/**
		 * 每人每日限购
		 */
		@ApiField("user_daily_limit_cnt")
		private Long userDailyLimitCnt;
		/**
		 * 每人活动期间总限购
		 */
		@ApiField("user_limit_cnt")
		private Long userLimitCnt;
	

	public Long getTotalLimitCnt() {
			return this.totalLimitCnt;
		}
		public void setTotalLimitCnt(Long totalLimitCnt) {
			this.totalLimitCnt = totalLimitCnt;
		}
		public Long getUserDailyLimitCnt() {
			return this.userDailyLimitCnt;
		}
		public void setUserDailyLimitCnt(Long userDailyLimitCnt) {
			this.userDailyLimitCnt = userDailyLimitCnt;
		}
		public Long getUserLimitCnt() {
			return this.userLimitCnt;
		}
		public void setUserLimitCnt(Long userLimitCnt) {
			this.userLimitCnt = userLimitCnt;
		}

}

	/**
 * 报名活动成功的商品详情
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemBuyGiftSku extends TaobaoObject {

	private static final long serialVersionUID = 8834968833273565116L;

	/**
		 * 买N赠1的N
		 */
		@ApiField("buy_num")
		private Long buyNum;
		/**
		 * 赠品的skuCode
		 */
		@ApiField("gift_sku_code")
		private String giftSkuCode;
		/**
		 * 赠品名称
		 */
		@ApiField("gift_sku_name")
		private String giftSkuName;
		/**
		 * 淘宝item和shop的对应关系， k-itemId, v-shopId
		 */
		@ApiField("item_shop_relation")
		private String itemShopRelation;
		/**
		 * 通用限购信息，-1为不限制，默认为不限制
		 */
		@ApiField("limit_info")
		private LimitInfo limitInfo;
		/**
		 * 主商品的skuCode
		 */
		@ApiField("sku_code")
		private String skuCode;
		/**
		 * 主商品名称
		 */
		@ApiField("sku_name")
		private String skuName;
	

	public Long getBuyNum() {
			return this.buyNum;
		}
		public void setBuyNum(Long buyNum) {
			this.buyNum = buyNum;
		}
		public String getGiftSkuCode() {
			return this.giftSkuCode;
		}
		public void setGiftSkuCode(String giftSkuCode) {
			this.giftSkuCode = giftSkuCode;
		}
		public String getGiftSkuName() {
			return this.giftSkuName;
		}
		public void setGiftSkuName(String giftSkuName) {
			this.giftSkuName = giftSkuName;
		}
		public String getItemShopRelation() {
			return this.itemShopRelation;
		}
		public void setItemShopRelation(String itemShopRelation) {
			this.itemShopRelation = itemShopRelation;
		}
		public void setItemShopRelationString(String itemShopRelation) {
			this.itemShopRelation = itemShopRelation;
		}
		
		public LimitInfo getLimitInfo() {
			return this.limitInfo;
		}
		public void setLimitInfo(LimitInfo limitInfo) {
			this.limitInfo = limitInfo;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}
		public String getSkuName() {
			return this.skuName;
		}
		public void setSkuName(String skuName) {
			this.skuName = skuName;
		}

}

	/**
 * 商品报名活动的返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MarketResult extends TaobaoObject {

	private static final long serialVersionUID = 8373716458745364824L;

	/**
		 * 报名活动成功的商品详情
		 */
		@ApiField("data")
		private ItemBuyGiftSku data;
		/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误信息
		 */
		@ApiField("message")
		private String message;
		/**
		 * 是否报名成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public ItemBuyGiftSku getData() {
			return this.data;
		}
		public void setData(ItemBuyGiftSku data) {
			this.data = data;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
