package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.wdk.marketing.itembuygift.queryitems response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaWdkMarketingItembuygiftQueryitemsResponse extends TaobaoResponse {

	private static final long serialVersionUID = 3278828888591145889L;

	/** 
	 * 查询返回结果
	 */
	@ApiField("result")
	private MarketPageResult result;


	public void setResult(MarketPageResult result) {
		this.result = result;
	}
	public MarketPageResult getResult( ) {
		return this.result;
	}
	
	/**
 * 通用限购信息，-1为不限制，默认为不限制
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LimitInfo extends TaobaoObject {

	private static final long serialVersionUID = 5889447433791461468L;

	/**
		 * 活动期间总限购
		 */
		@ApiField("total_limit_cnt")
		private Long totalLimitCnt;
		/**
		 * 每人每日限购
		 */
		@ApiField("user_daily_limit_cnt")
		private Long userDailyLimitCnt;
		/**
		 * 每人活动期间总限购
		 */
		@ApiField("user_limit_cnt")
		private Long userLimitCnt;
	

	public Long getTotalLimitCnt() {
			return this.totalLimitCnt;
		}
		public void setTotalLimitCnt(Long totalLimitCnt) {
			this.totalLimitCnt = totalLimitCnt;
		}
		public Long getUserDailyLimitCnt() {
			return this.userDailyLimitCnt;
		}
		public void setUserDailyLimitCnt(Long userDailyLimitCnt) {
			this.userDailyLimitCnt = userDailyLimitCnt;
		}
		public Long getUserLimitCnt() {
			return this.userLimitCnt;
		}
		public void setUserLimitCnt(Long userLimitCnt) {
			this.userLimitCnt = userLimitCnt;
		}

}

	/**
 * 参加活动的买赠商品详情列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Data extends TaobaoObject {

	private static final long serialVersionUID = 4724773373217836615L;

	/**
		 * 买N赠1的N
		 */
		@ApiField("buy_num")
		private Long buyNum;
		/**
		 * 赠品的skuCode，如果和主商品的skuCode相同，则为买A赠A；如果不同，则为买A赠B
		 */
		@ApiField("gift_sku_code")
		private String giftSkuCode;
		/**
		 * 赠品的名称
		 */
		@ApiField("gift_sku_name")
		private String giftSkuName;
		/**
		 * 淘宝item和shop的对应关系， k-itemId, v-shopId
		 */
		@ApiField("item_shop_relation")
		private String itemShopRelation;
		/**
		 * 通用限购信息，-1为不限制，默认为不限制
		 */
		@ApiField("limit_info")
		private LimitInfo limitInfo;
		/**
		 * 主商品的skuCode
		 */
		@ApiField("sku_code")
		private String skuCode;
		/**
		 * 主商品名称
		 */
		@ApiField("sku_name")
		private String skuName;
	

	public Long getBuyNum() {
			return this.buyNum;
		}
		public void setBuyNum(Long buyNum) {
			this.buyNum = buyNum;
		}
		public String getGiftSkuCode() {
			return this.giftSkuCode;
		}
		public void setGiftSkuCode(String giftSkuCode) {
			this.giftSkuCode = giftSkuCode;
		}
		public String getGiftSkuName() {
			return this.giftSkuName;
		}
		public void setGiftSkuName(String giftSkuName) {
			this.giftSkuName = giftSkuName;
		}
		public String getItemShopRelation() {
			return this.itemShopRelation;
		}
		public void setItemShopRelation(String itemShopRelation) {
			this.itemShopRelation = itemShopRelation;
		}
		public void setItemShopRelationString(String itemShopRelation) {
			this.itemShopRelation = itemShopRelation;
		}
		
		public LimitInfo getLimitInfo() {
			return this.limitInfo;
		}
		public void setLimitInfo(LimitInfo limitInfo) {
			this.limitInfo = limitInfo;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}
		public String getSkuName() {
			return this.skuName;
		}
		public void setSkuName(String skuName) {
			this.skuName = skuName;
		}

}

	/**
 * 查询返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MarketPageResult extends TaobaoObject {

	private static final long serialVersionUID = 7581411288584358292L;

	/**
		 * 当前分页
		 */
		@ApiField("current")
		private Long current;
		/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误信息
		 */
		@ApiField("message")
		private String message;
		/**
		 * 页面大小
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 参加活动的买赠商品详情列表
		 */
		@ApiListField("sku_list")
		@ApiField("data")
		private List<Data> skuList;
		/**
		 * 调用api是否成功
		 */
		@ApiField("success")
		private Boolean success;
		/**
		 * 参加当前活动的商品总数
		 */
		@ApiField("total")
		private Long total;
		/**
		 * 总页数
		 */
		@ApiField("total_page")
		private Long totalPage;
	

	public Long getCurrent() {
			return this.current;
		}
		public void setCurrent(Long current) {
			this.current = current;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public List<Data> getSkuList() {
			return this.skuList;
		}
		public void setSkuList(List<Data> skuList) {
			this.skuList = skuList;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}
		public Long getTotal() {
			return this.total;
		}
		public void setTotal(Long total) {
			this.total = total;
		}
		public Long getTotalPage() {
			return this.totalPage;
		}
		public void setTotalPage(Long totalPage) {
			this.totalPage = totalPage;
		}

}



}
