package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.wdk.marketing.itemdiscount.queryactivity response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaWdkMarketingItemdiscountQueryactivityResponse extends TaobaoResponse {

	private static final long serialVersionUID = 8542599394956926261L;

	/** 
	 * 查询特价活动返回结果
	 */
	@ApiField("result")
	private MarketResult result;


	public void setResult(MarketResult result) {
		this.result = result;
	}
	public MarketResult getResult( ) {
		return this.result;
	}
	
	/**
 * 周期优惠信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PeriodConfig extends TaobaoObject {

	private static final long serialVersionUID = 5396563757593955532L;

	/**
		 * 每天的那些时间段生效
		 */
		@ApiListField("every_day_periods")
		@ApiField("string")
		private List<String> everyDayPeriods;
		/**
		 * 一周的哪几天生效
		 */
		@ApiListField("weekdays")
		@ApiField("number")
		private List<Long> weekdays;
	

	public List<String> getEveryDayPeriods() {
			return this.everyDayPeriods;
		}
		public void setEveryDayPeriods(List<String> everyDayPeriods) {
			this.everyDayPeriods = everyDayPeriods;
		}
		public List<Long> getWeekdays() {
			return this.weekdays;
		}
		public void setWeekdays(List<Long> weekdays) {
			this.weekdays = weekdays;
		}

}

	/**
 * 特价活动信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemDiscountActivity extends TaobaoObject {

	private static final long serialVersionUID = 1887441219174153695L;

	/**
		 * 渠道key
		 */
		@ApiField("activity_channel")
		private String activityChannel;
		/**
		 * 五道口活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 活动名称,不超过10个英文字符
		 */
		@ApiField("activity_name")
		private String activityName;
		/**
		 * coverBefore
		 */
		@ApiField("cover_before")
		private Boolean coverBefore;
		/**
		 * 活动详情描述,不超过30个英文字符
		 */
		@ApiField("description")
		private String description;
		/**
		 * 商品特价优惠方式[itemDecreaseMoney:商品特价减钱;itemFixPrice:商品特价一口价;itemDiscount:商品特价打折]
		 */
		@ApiField("discount_type")
		private String discountType;
		/**
		 * 活动结束时间,时间戳
		 */
		@ApiField("end_time")
		private Long endTime;
		/**
		 * 会员维度活动参与人群限制[-1:不限制;1:会员专享;2:非会员专享]
		 */
		@ApiField("member_limit")
		private Long memberLimit;
		/**
		 * 商家人群编码
		 */
		@ApiField("merchant_crowd_code")
		private String merchantCrowdCode;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
		/**
		 * 周期优惠信息
		 */
		@ApiField("period_config")
		private PeriodConfig periodConfig;
		/**
		 * 活动优先级，值越大表示优先级越高，必须大于0
		 */
		@ApiField("priority_value")
		private Long priorityValue;
		/**
		 * 参加活动的渠道店ids
		 */
		@ApiListField("shop_ids")
		@ApiField("string")
		private List<String> shopIds;
		/**
		 * 活动开始时间,时间戳
		 */
		@ApiField("start_time")
		private Long startTime;
		/**
		 * 优惠适用场景[APP|POS|POS+APP分别对应的值为1|2|1,2]
		 */
		@ApiListField("terminals")
		@ApiField("number")
		private List<Long> terminals;
		/**
		 * 淘鲜达人群编码
		 */
		@ApiField("txd_crowd_code")
		private String txdCrowdCode;
	

	public String getActivityChannel() {
			return this.activityChannel;
		}
		public void setActivityChannel(String activityChannel) {
			this.activityChannel = activityChannel;
		}
		public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getActivityName() {
			return this.activityName;
		}
		public void setActivityName(String activityName) {
			this.activityName = activityName;
		}
		public Boolean getCoverBefore() {
			return this.coverBefore;
		}
		public void setCoverBefore(Boolean coverBefore) {
			this.coverBefore = coverBefore;
		}
		public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public String getDiscountType() {
			return this.discountType;
		}
		public void setDiscountType(String discountType) {
			this.discountType = discountType;
		}
		public Long getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Long endTime) {
			this.endTime = endTime;
		}
		public Long getMemberLimit() {
			return this.memberLimit;
		}
		public void setMemberLimit(Long memberLimit) {
			this.memberLimit = memberLimit;
		}
		public String getMerchantCrowdCode() {
			return this.merchantCrowdCode;
		}
		public void setMerchantCrowdCode(String merchantCrowdCode) {
			this.merchantCrowdCode = merchantCrowdCode;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}
		public PeriodConfig getPeriodConfig() {
			return this.periodConfig;
		}
		public void setPeriodConfig(PeriodConfig periodConfig) {
			this.periodConfig = periodConfig;
		}
		public Long getPriorityValue() {
			return this.priorityValue;
		}
		public void setPriorityValue(Long priorityValue) {
			this.priorityValue = priorityValue;
		}
		public List<String> getShopIds() {
			return this.shopIds;
		}
		public void setShopIds(List<String> shopIds) {
			this.shopIds = shopIds;
		}
		public Long getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Long startTime) {
			this.startTime = startTime;
		}
		public List<Long> getTerminals() {
			return this.terminals;
		}
		public void setTerminals(List<Long> terminals) {
			this.terminals = terminals;
		}
		public String getTxdCrowdCode() {
			return this.txdCrowdCode;
		}
		public void setTxdCrowdCode(String txdCrowdCode) {
			this.txdCrowdCode = txdCrowdCode;
		}

}

	/**
 * 查询特价活动返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MarketResult extends TaobaoObject {

	private static final long serialVersionUID = 2727975412255542685L;

	/**
		 * 特价活动信息
		 */
		@ApiField("data")
		private ItemDiscountActivity data;
		/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误信息
		 */
		@ApiField("message")
		private String message;
		/**
		 * 是否参加后单压前单，默认不参加
		 */
		@ApiField("success")
		private Boolean success;
	

	public ItemDiscountActivity getData() {
			return this.data;
		}
		public void setData(ItemDiscountActivity data) {
			this.data = data;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
