package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.wdk.marketing.itemdiscount.queryitems response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaWdkMarketingItemdiscountQueryitemsResponse extends TaobaoResponse {

	private static final long serialVersionUID = 1662617646499138941L;

	/** 
	 * 查询返回结果
	 */
	@ApiField("result")
	private MarketPageResult result;


	public void setResult(MarketPageResult result) {
		this.result = result;
	}
	public MarketPageResult getResult( ) {
		return this.result;
	}
	
	/**
 * 通用限购信息，-1为不限制，默认为不限制
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LimitInfo extends TaobaoObject {

	private static final long serialVersionUID = 6355737658634555389L;

	/**
		 * 活动每日总限购
		 */
		@ApiField("daily_limit_cnt")
		private Long dailyLimitCnt;
		/**
		 * 活动每日总限购【小数位】
		 */
		@ApiField("daily_limit_cnt_double")
		private String dailyLimitCntDouble;
		/**
		 * 活动期间总限购
		 */
		@ApiField("total_limit_cnt")
		private Long totalLimitCnt;
		/**
		 * 活动期间总限购【小数位】
		 */
		@ApiField("total_limit_cnt_double")
		private String totalLimitCntDouble;
		/**
		 * 每人每日限购
		 */
		@ApiField("user_daily_limit_cnt")
		private Long userDailyLimitCnt;
		/**
		 * 每人每日限购【小数位】
		 */
		@ApiField("user_daily_limit_cnt_double")
		private String userDailyLimitCntDouble;
		/**
		 * 每人活动期间总限购
		 */
		@ApiField("user_limit_cnt")
		private Long userLimitCnt;
		/**
		 * 每人活动期间总限购【小数位】
		 */
		@ApiField("user_limit_cnt_double")
		private String userLimitCntDouble;
	

	public Long getDailyLimitCnt() {
			return this.dailyLimitCnt;
		}
		public void setDailyLimitCnt(Long dailyLimitCnt) {
			this.dailyLimitCnt = dailyLimitCnt;
		}
		public String getDailyLimitCntDouble() {
			return this.dailyLimitCntDouble;
		}
		public void setDailyLimitCntDouble(String dailyLimitCntDouble) {
			this.dailyLimitCntDouble = dailyLimitCntDouble;
		}
		public Long getTotalLimitCnt() {
			return this.totalLimitCnt;
		}
		public void setTotalLimitCnt(Long totalLimitCnt) {
			this.totalLimitCnt = totalLimitCnt;
		}
		public String getTotalLimitCntDouble() {
			return this.totalLimitCntDouble;
		}
		public void setTotalLimitCntDouble(String totalLimitCntDouble) {
			this.totalLimitCntDouble = totalLimitCntDouble;
		}
		public Long getUserDailyLimitCnt() {
			return this.userDailyLimitCnt;
		}
		public void setUserDailyLimitCnt(Long userDailyLimitCnt) {
			this.userDailyLimitCnt = userDailyLimitCnt;
		}
		public String getUserDailyLimitCntDouble() {
			return this.userDailyLimitCntDouble;
		}
		public void setUserDailyLimitCntDouble(String userDailyLimitCntDouble) {
			this.userDailyLimitCntDouble = userDailyLimitCntDouble;
		}
		public Long getUserLimitCnt() {
			return this.userLimitCnt;
		}
		public void setUserLimitCnt(Long userLimitCnt) {
			this.userLimitCnt = userLimitCnt;
		}
		public String getUserLimitCntDouble() {
			return this.userLimitCntDouble;
		}
		public void setUserLimitCntDouble(String userLimitCntDouble) {
			this.userLimitCntDouble = userLimitCntDouble;
		}

}

	/**
 * 参加活动的特价商品详情列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemDiscountSku extends TaobaoObject {

	private static final long serialVersionUID = 1585918139236417576L;

	/**
		 * 积分值
		 */
		@ApiField("condition_num")
		private Long conditionNum;
		/**
		 * 积分类型
		 */
		@ApiField("condition_type")
		private Long conditionType;
		/**
		 * 淘宝item和shop的对应关系， k-itemId, v-shopId
		 */
		@ApiField("item_shop_relation")
		private String itemShopRelation;
		/**
		 * 通用限购信息，-1为不限制，默认为不限制
		 */
		@ApiField("limit_info")
		private LimitInfo limitInfo;
		/**
		 * 商品的skuCode
		 */
		@ApiField("sku_code")
		private String skuCode;
		/**
		 * 商品名称
		 */
		@ApiField("sku_name")
		private String skuName;
		/**
		 * <优惠明细,分为单位>优惠类型为[减价],则代表直降金额[如700,表示商品直降7元];优惠券类型为[一口价],则代表一口价[如700,表示商品一口价为7元];优惠券类型为[打折],则代表折扣[如700,表示打7折]
		 */
		@ApiField("value")
		private Long value;
	

	public Long getConditionNum() {
			return this.conditionNum;
		}
		public void setConditionNum(Long conditionNum) {
			this.conditionNum = conditionNum;
		}
		public Long getConditionType() {
			return this.conditionType;
		}
		public void setConditionType(Long conditionType) {
			this.conditionType = conditionType;
		}
		public String getItemShopRelation() {
			return this.itemShopRelation;
		}
		public void setItemShopRelation(String itemShopRelation) {
			this.itemShopRelation = itemShopRelation;
		}
		public void setItemShopRelationString(String itemShopRelation) {
			this.itemShopRelation = itemShopRelation;
		}
		
		public LimitInfo getLimitInfo() {
			return this.limitInfo;
		}
		public void setLimitInfo(LimitInfo limitInfo) {
			this.limitInfo = limitInfo;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}
		public String getSkuName() {
			return this.skuName;
		}
		public void setSkuName(String skuName) {
			this.skuName = skuName;
		}
		public Long getValue() {
			return this.value;
		}
		public void setValue(Long value) {
			this.value = value;
		}

}

	/**
 * 查询返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MarketPageResult extends TaobaoObject {

	private static final long serialVersionUID = 5539977498573515379L;

	/**
		 * 当前分页
		 */
		@ApiField("current")
		private Long current;
		/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误信息
		 */
		@ApiField("message")
		private String message;
		/**
		 * 页面大小
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 参加活动的特价商品详情列表
		 */
		@ApiListField("sku_list")
		@ApiField("item_discount_sku")
		private List<ItemDiscountSku> skuList;
		/**
		 * 查询特价商品是否成功
		 */
		@ApiField("success")
		private Boolean success;
		/**
		 * 参加当前活动的商品总数
		 */
		@ApiField("total")
		private Long total;
		/**
		 * 总页数
		 */
		@ApiField("total_page")
		private Long totalPage;
	

	public Long getCurrent() {
			return this.current;
		}
		public void setCurrent(Long current) {
			this.current = current;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public List<ItemDiscountSku> getSkuList() {
			return this.skuList;
		}
		public void setSkuList(List<ItemDiscountSku> skuList) {
			this.skuList = skuList;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}
		public Long getTotal() {
			return this.total;
		}
		public void setTotal(Long total) {
			this.total = total;
		}
		public Long getTotalPage() {
			return this.totalPage;
		}
		public void setTotalPage(Long totalPage) {
			this.totalPage = totalPage;
		}

}



}
