package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.wdk.marketing.itempool.stair.queryitem response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaWdkMarketingItempoolStairQueryitemResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5353948685828711317L;

	/** 
	 * 查询结果
	 */
	@ApiField("result")
	private MarketPageResult result;


	public void setResult(MarketPageResult result) {
		this.result = result;
	}
	public MarketPageResult getResult( ) {
		return this.result;
	}
	
	/**
 * 查询结果数据
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemPoolSku extends TaobaoObject {

	private static final long serialVersionUID = 2315711917952345861L;

	/**
		 * 换购价格
		 */
		@ApiField("exchange_price")
		private Long exchangePrice;
		/**
		 * 换购限量
		 */
		@ApiField("exchange_total_limit")
		private Long exchangeTotalLimit;
		/**
		 * 商品skucode
		 */
		@ApiField("sku_code")
		private String skuCode;
		/**
		 * 商品名称
		 */
		@ApiField("sku_name")
		private String skuName;
	

	public Long getExchangePrice() {
			return this.exchangePrice;
		}
		public void setExchangePrice(Long exchangePrice) {
			this.exchangePrice = exchangePrice;
		}
		public Long getExchangeTotalLimit() {
			return this.exchangeTotalLimit;
		}
		public void setExchangeTotalLimit(Long exchangeTotalLimit) {
			this.exchangeTotalLimit = exchangeTotalLimit;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}
		public String getSkuName() {
			return this.skuName;
		}
		public void setSkuName(String skuName) {
			this.skuName = skuName;
		}

}

	/**
 * 查询结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MarketPageResult extends TaobaoObject {

	private static final long serialVersionUID = 6451456979998486974L;

	/**
		 * 当前页数
		 */
		@ApiField("current")
		private Long current;
		/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 查询结果信息
		 */
		@ApiField("message")
		private String message;
		/**
		 * 页数size
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 查询结果数据
		 */
		@ApiListField("sku_list")
		@ApiField("item_pool_sku")
		private List<ItemPoolSku> skuList;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
		/**
		 * 总数
		 */
		@ApiField("total")
		private Long total;
		/**
		 * 总页数
		 */
		@ApiField("total_page")
		private Long totalPage;
	

	public Long getCurrent() {
			return this.current;
		}
		public void setCurrent(Long current) {
			this.current = current;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public List<ItemPoolSku> getSkuList() {
			return this.skuList;
		}
		public void setSkuList(List<ItemPoolSku> skuList) {
			this.skuList = skuList;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}
		public Long getTotal() {
			return this.total;
		}
		public void setTotal(Long total) {
			this.total = total;
		}
		public Long getTotalPage() {
			return this.totalPage;
		}
		public void setTotalPage(Long totalPage) {
			this.totalPage = totalPage;
		}

}



}
