package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.wdk.marketing.price response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaWdkMarketingPriceResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5747993399169796419L;

	/** 
	 * 返回结果
	 */
	@ApiField("result")
	private PromotionPriceResult result;


	public void setResult(PromotionPriceResult result) {
		this.result = result;
	}
	public PromotionPriceResult getResult( ) {
		return this.result;
	}
	
	/**
 * 促销信息记录
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PromotionPriceDO extends TaobaoObject {

	private static final long serialVersionUID = 3747347698371928777L;

	/**
		 * 记录标识
		 */
		@ApiField("id")
		private Long id;
		/**
		 * 是否参加了促销
		 */
		@ApiField("if_promotion")
		private Long ifPromotion;
		/**
		 * 会员促销价结束时间
		 */
		@ApiField("member_promotion_end_time")
		private Date memberPromotionEndTime;
		/**
		 * 会员促销价
		 */
		@ApiField("member_promotion_price")
		private Long memberPromotionPrice;
		/**
		 * 会员促销价开始时间
		 */
		@ApiField("member_promotion_start_time")
		private Date memberPromotionStartTime;
		/**
		 * 会员促销活动类型
		 */
		@ApiField("member_promotion_type")
		private String memberPromotionType;
		/**
		 * 商家编码
		 */
		@ApiField("merchant_code")
		private String merchantCode;
		/**
		 * 促销结束时间
		 */
		@ApiField("promotion_end")
		private Date promotionEnd;
		/**
		 * 促销赠品信息
		 */
		@ApiField("promotion_gift_info")
		private String promotionGiftInfo;
		/**
		 * 促销价格
		 */
		@ApiField("promotion_price")
		private Long promotionPrice;
		/**
		 * 促销说明
		 */
		@ApiField("promotion_reason")
		private String promotionReason;
		/**
		 * 促销开始时间
		 */
		@ApiField("promotion_start")
		private Date promotionStart;
		/**
		 * 促销类型
		 */
		@ApiField("promotion_type")
		private String promotionType;
		/**
		 * 店铺编码
		 */
		@ApiField("shop_code")
		private String shopCode;
		/**
		 * 店铺标识
		 */
		@ApiField("shop_id")
		private Long shopId;
		/**
		 * 商品编码
		 */
		@ApiField("sku_code")
		private String skuCode;
	

	public Long getId() {
			return this.id;
		}
		public void setId(Long id) {
			this.id = id;
		}
		public Long getIfPromotion() {
			return this.ifPromotion;
		}
		public void setIfPromotion(Long ifPromotion) {
			this.ifPromotion = ifPromotion;
		}
		public Date getMemberPromotionEndTime() {
			return this.memberPromotionEndTime;
		}
		public void setMemberPromotionEndTime(Date memberPromotionEndTime) {
			this.memberPromotionEndTime = memberPromotionEndTime;
		}
		public Long getMemberPromotionPrice() {
			return this.memberPromotionPrice;
		}
		public void setMemberPromotionPrice(Long memberPromotionPrice) {
			this.memberPromotionPrice = memberPromotionPrice;
		}
		public Date getMemberPromotionStartTime() {
			return this.memberPromotionStartTime;
		}
		public void setMemberPromotionStartTime(Date memberPromotionStartTime) {
			this.memberPromotionStartTime = memberPromotionStartTime;
		}
		public String getMemberPromotionType() {
			return this.memberPromotionType;
		}
		public void setMemberPromotionType(String memberPromotionType) {
			this.memberPromotionType = memberPromotionType;
		}
		public String getMerchantCode() {
			return this.merchantCode;
		}
		public void setMerchantCode(String merchantCode) {
			this.merchantCode = merchantCode;
		}
		public Date getPromotionEnd() {
			return this.promotionEnd;
		}
		public void setPromotionEnd(Date promotionEnd) {
			this.promotionEnd = promotionEnd;
		}
		public String getPromotionGiftInfo() {
			return this.promotionGiftInfo;
		}
		public void setPromotionGiftInfo(String promotionGiftInfo) {
			this.promotionGiftInfo = promotionGiftInfo;
		}
		public Long getPromotionPrice() {
			return this.promotionPrice;
		}
		public void setPromotionPrice(Long promotionPrice) {
			this.promotionPrice = promotionPrice;
		}
		public String getPromotionReason() {
			return this.promotionReason;
		}
		public void setPromotionReason(String promotionReason) {
			this.promotionReason = promotionReason;
		}
		public Date getPromotionStart() {
			return this.promotionStart;
		}
		public void setPromotionStart(Date promotionStart) {
			this.promotionStart = promotionStart;
		}
		public String getPromotionType() {
			return this.promotionType;
		}
		public void setPromotionType(String promotionType) {
			this.promotionType = promotionType;
		}
		public String getShopCode() {
			return this.shopCode;
		}
		public void setShopCode(String shopCode) {
			this.shopCode = shopCode;
		}
		public Long getShopId() {
			return this.shopId;
		}
		public void setShopId(Long shopId) {
			this.shopId = shopId;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}

}

	/**
 * 返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PromotionPriceResult extends TaobaoObject {

	private static final long serialVersionUID = 1896873522968341174L;

	/**
		 * 错误编码
		 */
		@ApiField("err_code")
		private String errCode;
		/**
		 * 错误信息
		 */
		@ApiField("err_msg")
		private String errMsg;
		/**
		 * 促销信息记录
		 */
		@ApiListField("item_list")
		@ApiField("promotion_price_d_o")
		private List<PromotionPriceDO> itemList;
		/**
		 * 总页数
		 */
		@ApiField("page_count")
		private Long pageCount;
		/**
		 * 页码
		 */
		@ApiField("page_index")
		private Long pageIndex;
		/**
		 * 单页数据大小
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
		/**
		 * 总数量
		 */
		@ApiField("total")
		private Long total;
	

	public String getErrCode() {
			return this.errCode;
		}
		public void setErrCode(String errCode) {
			this.errCode = errCode;
		}
		public String getErrMsg() {
			return this.errMsg;
		}
		public void setErrMsg(String errMsg) {
			this.errMsg = errMsg;
		}
		public List<PromotionPriceDO> getItemList() {
			return this.itemList;
		}
		public void setItemList(List<PromotionPriceDO> itemList) {
			this.itemList = itemList;
		}
		public Long getPageCount() {
			return this.pageCount;
		}
		public void setPageCount(Long pageCount) {
			this.pageCount = pageCount;
		}
		public Long getPageIndex() {
			return this.pageIndex;
		}
		public void setPageIndex(Long pageIndex) {
			this.pageIndex = pageIndex;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}
		public Long getTotal() {
			return this.total;
		}
		public void setTotal(Long total) {
			this.total = total;
		}

}



}
