package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.wdk.trade.discount.bill.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaWdkTradeDiscountBillGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 4879512944326418945L;

	/** 
	 * 结果
	 */
	@ApiField("result")
	private OrderDiscountBillQueryResult result;


	public void setResult(OrderDiscountBillQueryResult result) {
		this.result = result;
	}
	public OrderDiscountBillQueryResult getResult( ) {
		return this.result;
	}
	
	/**
 * 账单列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OrderDiscountBillBo extends TaobaoObject {

	private static final long serialVersionUID = 2616519215116278949L;

	/**
		 * 活动ID
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 活动名称
		 */
		@ApiField("activity_name")
		private String activityName;
		/**
		 * 活动类型 1：活动 2：券
		 */
		@ApiField("activity_type")
		private Long activityType;
		/**
		 * 业务时间
		 */
		@ApiField("biz_time")
		private Date bizTime;
		/**
		 * 购买数量
		 */
		@ApiField("buy_quantity")
		private Long buyQuantity;
		/**
		 * 优惠金额
		 */
		@ApiField("discount_fee")
		private Long discountFee;
		/**
		 * 优惠件数
		 */
		@ApiField("discount_quantity")
		private Long discountQuantity;
		/**
		 * 补差类型
		 */
		@ApiField("discount_type")
		private Long discountType;
		/**
		 * 主键id
		 */
		@ApiField("id")
		private Long id;
		/**
		 * 出资方 1表示平台出资  0表示品牌商出资
		 */
		@ApiField("investor")
		private Long investor;
		/**
		 * 主订单号
		 */
		@ApiField("main_order_id")
		private String mainOrderId;
		/**
		 * 商家编码
		 */
		@ApiField("merchant_code")
		private String merchantCode;
		/**
		 * 商家优惠补差金额
		 */
		@ApiField("merchant_discount_fee")
		private Long merchantDiscountFee;
		/**
		 * 订单渠道
		 */
		@ApiField("order_channel")
		private Long orderChannel;
		/**
		 * 交易状态
		 */
		@ApiField("order_status")
		private Long orderStatus;
		/**
		 * 外部订单号
		 */
		@ApiField("out_order_id")
		private String outOrderId;
		/**
		 * 商品编码
		 */
		@ApiField("sku_code")
		private String skuCode;
		/**
		 * 商品名称
		 */
		@ApiField("sku_name")
		private String skuName;
		/**
		 * 经营店id
		 */
		@ApiField("store_id")
		private String storeId;
		/**
		 * 子单号
		 */
		@ApiField("sub_order_id")
		private String subOrderId;
		/**
		 * 淘鲜达优惠金额
		 */
		@ApiField("txd_discount_fee")
		private Long txdDiscountFee;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getActivityName() {
			return this.activityName;
		}
		public void setActivityName(String activityName) {
			this.activityName = activityName;
		}
		public Long getActivityType() {
			return this.activityType;
		}
		public void setActivityType(Long activityType) {
			this.activityType = activityType;
		}
		public Date getBizTime() {
			return this.bizTime;
		}
		public void setBizTime(Date bizTime) {
			this.bizTime = bizTime;
		}
		public Long getBuyQuantity() {
			return this.buyQuantity;
		}
		public void setBuyQuantity(Long buyQuantity) {
			this.buyQuantity = buyQuantity;
		}
		public Long getDiscountFee() {
			return this.discountFee;
		}
		public void setDiscountFee(Long discountFee) {
			this.discountFee = discountFee;
		}
		public Long getDiscountQuantity() {
			return this.discountQuantity;
		}
		public void setDiscountQuantity(Long discountQuantity) {
			this.discountQuantity = discountQuantity;
		}
		public Long getDiscountType() {
			return this.discountType;
		}
		public void setDiscountType(Long discountType) {
			this.discountType = discountType;
		}
		public Long getId() {
			return this.id;
		}
		public void setId(Long id) {
			this.id = id;
		}
		public Long getInvestor() {
			return this.investor;
		}
		public void setInvestor(Long investor) {
			this.investor = investor;
		}
		public String getMainOrderId() {
			return this.mainOrderId;
		}
		public void setMainOrderId(String mainOrderId) {
			this.mainOrderId = mainOrderId;
		}
		public String getMerchantCode() {
			return this.merchantCode;
		}
		public void setMerchantCode(String merchantCode) {
			this.merchantCode = merchantCode;
		}
		public Long getMerchantDiscountFee() {
			return this.merchantDiscountFee;
		}
		public void setMerchantDiscountFee(Long merchantDiscountFee) {
			this.merchantDiscountFee = merchantDiscountFee;
		}
		public Long getOrderChannel() {
			return this.orderChannel;
		}
		public void setOrderChannel(Long orderChannel) {
			this.orderChannel = orderChannel;
		}
		public Long getOrderStatus() {
			return this.orderStatus;
		}
		public void setOrderStatus(Long orderStatus) {
			this.orderStatus = orderStatus;
		}
		public String getOutOrderId() {
			return this.outOrderId;
		}
		public void setOutOrderId(String outOrderId) {
			this.outOrderId = outOrderId;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}
		public String getSkuName() {
			return this.skuName;
		}
		public void setSkuName(String skuName) {
			this.skuName = skuName;
		}
		public String getStoreId() {
			return this.storeId;
		}
		public void setStoreId(String storeId) {
			this.storeId = storeId;
		}
		public String getSubOrderId() {
			return this.subOrderId;
		}
		public void setSubOrderId(String subOrderId) {
			this.subOrderId = subOrderId;
		}
		public Long getTxdDiscountFee() {
			return this.txdDiscountFee;
		}
		public void setTxdDiscountFee(Long txdDiscountFee) {
			this.txdDiscountFee = txdDiscountFee;
		}

}

	/**
 * 结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OrderDiscountBillQueryResult extends TaobaoObject {

	private static final long serialVersionUID = 3594867815174481745L;

	/**
		 * 账单列表
		 */
		@ApiListField("discount_bills")
		@ApiField("order_discount_bill_bo")
		private List<OrderDiscountBillBo> discountBills;
		/**
		 * 下一页查询的入参，当为-1时表示没有更多数据
		 */
		@ApiField("next_id")
		private Long nextId;
		/**
		 * 结果码
		 */
		@ApiField("return_code")
		private String returnCode;
		/**
		 * 结果文案
		 */
		@ApiField("return_msg")
		private String returnMsg;
		/**
		 * 业务请求成功与否
		 */
		@ApiField("success")
		private Boolean success;
		/**
		 * 总数量，只在查询第一页时返回
		 */
		@ApiField("total_number")
		private Long totalNumber;
	

	public List<OrderDiscountBillBo> getDiscountBills() {
			return this.discountBills;
		}
		public void setDiscountBills(List<OrderDiscountBillBo> discountBills) {
			this.discountBills = discountBills;
		}
		public Long getNextId() {
			return this.nextId;
		}
		public void setNextId(Long nextId) {
			this.nextId = nextId;
		}
		public String getReturnCode() {
			return this.returnCode;
		}
		public void setReturnCode(String returnCode) {
			this.returnCode = returnCode;
		}
		public String getReturnMsg() {
			return this.returnMsg;
		}
		public void setReturnMsg(String returnMsg) {
			this.returnMsg = returnMsg;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}
		public Long getTotalNumber() {
			return this.totalNumber;
		}
		public void setTotalNumber(Long totalNumber) {
			this.totalNumber = totalNumber;
		}

}



}
