package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.logistics.fulfilorder.search response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class LogisticsFulfilorderSearchResponse extends TaobaoResponse {

	private static final long serialVersionUID = 4614579958376155119L;

	/** 
	 * 结果
	 */
	@ApiField("result")
	private PaginationResult result;


	public void setResult(PaginationResult result) {
		this.result = result;
	}
	public PaginationResult getResult( ) {
		return this.result;
	}
	
	/**
 * 物流履约单商品明细
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class FulfilOrderItemDTO extends TaobaoObject {

	private static final long serialVersionUID = 8583143577286272132L;

	/**
		 * 条码
		 */
		@ApiField("bar_code")
		private String barCode;
		/**
		 * 组合货品主品Id
		 */
		@ApiField("combine_item_id")
		private Long combineItemId;
		/**
		 * 组合货品主品名称
		 */
		@ApiField("combine_item_name")
		private String combineItemName;
		/**
		 * 组合货品交易下单数量
		 */
		@ApiField("combine_qty")
		private Long combineQty;
		/**
		 * 扩展信息，invQlty（临期品可售场景）=139 gift_type（赠品类型）：1（普通品）、5（交易赠品）、2（供应链赠品）；
		 */
		@ApiField("feature_map")
		private String featureMap;
		/**
		 * 分销场景下，分销toC交易子单
		 */
		@ApiField("fx_sub_trade_id")
		private String fxSubTradeId;
		/**
		 * 分销交易主单id
		 */
		@ApiField("fx_trade_id")
		private String fxTradeId;
		/**
		 * 预计发货数量
		 */
		@ApiField("goods_qty")
		private Long goodsQty;
		/**
		 * 前端商品Code
		 */
		@ApiField("item_code")
		private String itemCode;
		/**
		 * 前端商品Id
		 */
		@ApiField("item_id")
		private Long itemId;
		/**
		 * 前端商品名称
		 */
		@ApiField("item_name")
		private String itemName;
		/**
		 * 后端货品编码
		 */
		@ApiField("sc_item_code")
		private String scItemCode;
		/**
		 * 后端货品id
		 */
		@ApiField("sc_item_id")
		private Long scItemId;
		/**
		 * 后端货品名
		 */
		@ApiField("sc_item_name")
		private String scItemName;
		/**
		 * skuId
		 */
		@ApiField("sku_id")
		private Long skuId;
		/**
		 * 子交易单
		 */
		@ApiField("sub_trade_id")
		private String subTradeId;
		/**
		 * 交易主单id
		 */
		@ApiField("trade_id")
		private String tradeId;
	

	public String getBarCode() {
			return this.barCode;
		}
		public void setBarCode(String barCode) {
			this.barCode = barCode;
		}
		public Long getCombineItemId() {
			return this.combineItemId;
		}
		public void setCombineItemId(Long combineItemId) {
			this.combineItemId = combineItemId;
		}
		public String getCombineItemName() {
			return this.combineItemName;
		}
		public void setCombineItemName(String combineItemName) {
			this.combineItemName = combineItemName;
		}
		public Long getCombineQty() {
			return this.combineQty;
		}
		public void setCombineQty(Long combineQty) {
			this.combineQty = combineQty;
		}
		public String getFeatureMap() {
			return this.featureMap;
		}
		public void setFeatureMap(String featureMap) {
			this.featureMap = featureMap;
		}
		public void setFeatureMapString(String featureMap) {
			this.featureMap = featureMap;
		}
		
		public String getFxSubTradeId() {
			return this.fxSubTradeId;
		}
		public void setFxSubTradeId(String fxSubTradeId) {
			this.fxSubTradeId = fxSubTradeId;
		}
		public String getFxTradeId() {
			return this.fxTradeId;
		}
		public void setFxTradeId(String fxTradeId) {
			this.fxTradeId = fxTradeId;
		}
		public Long getGoodsQty() {
			return this.goodsQty;
		}
		public void setGoodsQty(Long goodsQty) {
			this.goodsQty = goodsQty;
		}
		public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public Long getItemId() {
			return this.itemId;
		}
		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}
		public String getItemName() {
			return this.itemName;
		}
		public void setItemName(String itemName) {
			this.itemName = itemName;
		}
		public String getScItemCode() {
			return this.scItemCode;
		}
		public void setScItemCode(String scItemCode) {
			this.scItemCode = scItemCode;
		}
		public Long getScItemId() {
			return this.scItemId;
		}
		public void setScItemId(Long scItemId) {
			this.scItemId = scItemId;
		}
		public String getScItemName() {
			return this.scItemName;
		}
		public void setScItemName(String scItemName) {
			this.scItemName = scItemName;
		}
		public Long getSkuId() {
			return this.skuId;
		}
		public void setSkuId(Long skuId) {
			this.skuId = skuId;
		}
		public String getSubTradeId() {
			return this.subTradeId;
		}
		public void setSubTradeId(String subTradeId) {
			this.subTradeId = subTradeId;
		}
		public String getTradeId() {
			return this.tradeId;
		}
		public void setTradeId(String tradeId) {
			this.tradeId = tradeId;
		}

}

	/**
 * 物流履约单信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class FulfilOrderDTO extends TaobaoObject {

	private static final long serialVersionUID = 7427356451427992967L;

	/**
		 * 业务状态，declareType（清关方式）：cbd（跨境）、pgd（邮关）； distributorId（分销商SellerId）； distributorNick（分销商SellerNick）； g_logistics（物流模式）：cainiao（菜鸟）、ecology（生态；  outbound_time（出库时间）；   split_flag（拆单标记）=1； merge_flag（合单标记）=1；  invQlty（临期品可售场景）=139 gift_type（赠品类型）：1（普通品）、5（交易赠品）、2（供应链赠品）；  新建=0； 下发履行处理中=50； 下发仓生产中=100； 仓库生产完毕=200； 配送中=300；  新建=100100； 待促销处理=100331； 待分仓占库存=100341； 缺货等待=100345； 待智能审单=100351； 待客服处理=100355； 待合单处理=100361； 合单等待=100365； 业务控单中=100369； 待发货=100371； 拆单废弃=200100； 取消=400300； 履行调度Hold单中=500200； 履行接单完成=500300； 已下发给仓库=600100； 仓库已接单=600200； 生产中=600300； 仓库已打印=600310； 仓库已拣选=600320； 已打包=600330； 部分出库中=600400； 仓库拒单=600800； 全部出库=700100； 全部揽收=800100； 配揽收=800110； 全部签收=800900； 部分签收=800910； 部分签收部分拒签=800920； 部分拒签=800940； 全部拒签=800950； 拦截成功=800960； 订单已出库=7070； 订单关闭=7120； 已签收=7130；拦截成功=7150；
		 */
		@ApiField("biz_order_status")
		private Long bizOrderStatus;
		/**
		 * 发货LP
		 */
		@ApiField("consign_lg_order_code")
		private String consignLgOrderCode;
		/**
		 * 错误编码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误描述
		 */
		@ApiField("error_message")
		private String errorMessage;
		/**
		 * 扩展信息，declareType（清关方式）：cbd（跨境）、pgd（邮关）； distributorId（分销商SellerId）； distributorNick（分销商SellerNick）； g_logistics（物流模式）：cainiao（菜鸟）、ecology（生态；
		 */
		@ApiField("feature_map")
		private String featureMap;
		/**
		 * 标记信息，split_flag（拆单标记）=1； merge_flag（合单标记）=1；
		 */
		@ApiField("flag_feature_map")
		private String flagFeatureMap;
		/**
		 * 时间节点，outbound_time（出库时间）；
		 */
		@ApiField("fulfil_time_map")
		private String fulfilTimeMap;
		/**
		 * 分销场景下，toC卖家
		 */
		@ApiField("fx_seller_id")
		private String fxSellerId;
		/**
		 * 分销场景下，分销toC交易单
		 */
		@ApiField("fx_trade_id")
		private String fxTradeId;
		/**
		 * 分销类型。0=toC单据，1=分销场景的B2B订单，2=分销场景的B2C订单。
		 */
		@ApiField("fx_trade_type")
		private Long fxTradeType;
		/**
		 * 修改时间
		 */
		@ApiField("gmt_modified")
		private Date gmtModified;
		/**
		 * 运单号（列表，逗号分隔）
		 */
		@ApiField("mail_nos")
		private String mailNos;
		/**
		 * 物流履约单号
		 */
		@ApiField("order_code")
		private String orderCode;
		/**
		 * 状态，新建=0； 下发履行处理中=50； 下发仓生产中=100； 仓库生产完毕=200； 配送中=300；
		 */
		@ApiField("order_status")
		private Long orderStatus;
		/**
		 * 货主
		 */
		@ApiField("owner_id")
		private Long ownerId;
		/**
		 * 单据来源
		 */
		@ApiField("platform_source")
		private Long platformSource;
		/**
		 * 卖家id
		 */
		@ApiField("seller_id")
		private Long sellerId;
		/**
		 * 交易LP
		 */
		@ApiField("source_lg_order_code")
		private String sourceLgOrderCode;
		/**
		 * 仓code
		 */
		@ApiField("store_code")
		private String storeCode;
		/**
		 * 仓储单号
		 */
		@ApiField("store_order_no")
		private String storeOrderNo;
		/**
		 * 配送资源code
		 */
		@ApiField("tms_code")
		private String tmsCode;
		/**
		 * 交易创建时间
		 */
		@ApiField("trade_create_time")
		private Date tradeCreateTime;
		/**
		 * 交易单号
		 */
		@ApiField("trade_id")
		private String tradeId;
		/**
		 * 交易付款时间
		 */
		@ApiField("trade_pay_time")
		private Date tradePayTime;
	

	public Long getBizOrderStatus() {
			return this.bizOrderStatus;
		}
		public void setBizOrderStatus(Long bizOrderStatus) {
			this.bizOrderStatus = bizOrderStatus;
		}
		public String getConsignLgOrderCode() {
			return this.consignLgOrderCode;
		}
		public void setConsignLgOrderCode(String consignLgOrderCode) {
			this.consignLgOrderCode = consignLgOrderCode;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getErrorMessage() {
			return this.errorMessage;
		}
		public void setErrorMessage(String errorMessage) {
			this.errorMessage = errorMessage;
		}
		public String getFeatureMap() {
			return this.featureMap;
		}
		public void setFeatureMap(String featureMap) {
			this.featureMap = featureMap;
		}
		public void setFeatureMapString(String featureMap) {
			this.featureMap = featureMap;
		}
		
		public String getFlagFeatureMap() {
			return this.flagFeatureMap;
		}
		public void setFlagFeatureMap(String flagFeatureMap) {
			this.flagFeatureMap = flagFeatureMap;
		}
		public void setFlagFeatureMapString(String flagFeatureMap) {
			this.flagFeatureMap = flagFeatureMap;
		}
		
		public String getFulfilTimeMap() {
			return this.fulfilTimeMap;
		}
		public void setFulfilTimeMap(String fulfilTimeMap) {
			this.fulfilTimeMap = fulfilTimeMap;
		}
		public void setFulfilTimeMapString(String fulfilTimeMap) {
			this.fulfilTimeMap = fulfilTimeMap;
		}
		
		public String getFxSellerId() {
			return this.fxSellerId;
		}
		public void setFxSellerId(String fxSellerId) {
			this.fxSellerId = fxSellerId;
		}
		public String getFxTradeId() {
			return this.fxTradeId;
		}
		public void setFxTradeId(String fxTradeId) {
			this.fxTradeId = fxTradeId;
		}
		public Long getFxTradeType() {
			return this.fxTradeType;
		}
		public void setFxTradeType(Long fxTradeType) {
			this.fxTradeType = fxTradeType;
		}
		public Date getGmtModified() {
			return this.gmtModified;
		}
		public void setGmtModified(Date gmtModified) {
			this.gmtModified = gmtModified;
		}
		public String getMailNos() {
			return this.mailNos;
		}
		public void setMailNos(String mailNos) {
			this.mailNos = mailNos;
		}
		public String getOrderCode() {
			return this.orderCode;
		}
		public void setOrderCode(String orderCode) {
			this.orderCode = orderCode;
		}
		public Long getOrderStatus() {
			return this.orderStatus;
		}
		public void setOrderStatus(Long orderStatus) {
			this.orderStatus = orderStatus;
		}
		public Long getOwnerId() {
			return this.ownerId;
		}
		public void setOwnerId(Long ownerId) {
			this.ownerId = ownerId;
		}
		public Long getPlatformSource() {
			return this.platformSource;
		}
		public void setPlatformSource(Long platformSource) {
			this.platformSource = platformSource;
		}
		public Long getSellerId() {
			return this.sellerId;
		}
		public void setSellerId(Long sellerId) {
			this.sellerId = sellerId;
		}
		public String getSourceLgOrderCode() {
			return this.sourceLgOrderCode;
		}
		public void setSourceLgOrderCode(String sourceLgOrderCode) {
			this.sourceLgOrderCode = sourceLgOrderCode;
		}
		public String getStoreCode() {
			return this.storeCode;
		}
		public void setStoreCode(String storeCode) {
			this.storeCode = storeCode;
		}
		public String getStoreOrderNo() {
			return this.storeOrderNo;
		}
		public void setStoreOrderNo(String storeOrderNo) {
			this.storeOrderNo = storeOrderNo;
		}
		public String getTmsCode() {
			return this.tmsCode;
		}
		public void setTmsCode(String tmsCode) {
			this.tmsCode = tmsCode;
		}
		public Date getTradeCreateTime() {
			return this.tradeCreateTime;
		}
		public void setTradeCreateTime(Date tradeCreateTime) {
			this.tradeCreateTime = tradeCreateTime;
		}
		public String getTradeId() {
			return this.tradeId;
		}
		public void setTradeId(String tradeId) {
			this.tradeId = tradeId;
		}
		public Date getTradePayTime() {
			return this.tradePayTime;
		}
		public void setTradePayTime(Date tradePayTime) {
			this.tradePayTime = tradePayTime;
		}

}

	/**
 * 数据列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class FullOrderViewDTO extends TaobaoObject {

	private static final long serialVersionUID = 2275797348118172316L;

	/**
		 * 物流履约单信息
		 */
		@ApiField("fulfilorder")
		private FulfilOrderDTO fulfilorder;
		/**
		 * 物流履约单商品明细
		 */
		@ApiListField("fulfilorder_item_list")
		@ApiField("fulfil_order_item_d_t_o")
		private List<FulfilOrderItemDTO> fulfilorderItemList;
	

	public FulfilOrderDTO getFulfilorder() {
			return this.fulfilorder;
		}
		public void setFulfilorder(FulfilOrderDTO fulfilorder) {
			this.fulfilorder = fulfilorder;
		}
		public List<FulfilOrderItemDTO> getFulfilorderItemList() {
			return this.fulfilorderItemList;
		}
		public void setFulfilorderItemList(List<FulfilOrderItemDTO> fulfilorderItemList) {
			this.fulfilorderItemList = fulfilorderItemList;
		}

}

	/**
 * 结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PaginationResult extends TaobaoObject {

	private static final long serialVersionUID = 6483283827585952338L;

	/**
		 * 数据列表
		 */
		@ApiListField("data_list")
		@ApiField("full_order_view_d_t_o")
		private List<FullOrderViewDTO> dataList;
		/**
		 * 错误码
		 */
		@ApiField("err_code")
		private String errCode;
		/**
		 * 错误描述
		 */
		@ApiField("err_desc")
		private String errDesc;
		/**
		 * 本次分页查询的数量限制
		 */
		@ApiField("limit")
		private Long limit;
		/**
		 * 调用是否成功
		 */
		@ApiField("request_success")
		private Boolean requestSuccess;
		/**
		 * 分页查询结果的开始下标
		 */
		@ApiField("start")
		private Long start;
		/**
		 * 总数
		 */
		@ApiField("total_count")
		private Long totalCount;
		/**
		 * 当前查询条件下的总页数。可以使用 查询页数 >= 总页数 作为当前查询入参（不包含页数）的结束条件
		 */
		@ApiField("total_page")
		private Long totalPage;
	

	public List<FullOrderViewDTO> getDataList() {
			return this.dataList;
		}
		public void setDataList(List<FullOrderViewDTO> dataList) {
			this.dataList = dataList;
		}
		public String getErrCode() {
			return this.errCode;
		}
		public void setErrCode(String errCode) {
			this.errCode = errCode;
		}
		public String getErrDesc() {
			return this.errDesc;
		}
		public void setErrDesc(String errDesc) {
			this.errDesc = errDesc;
		}
		public Long getLimit() {
			return this.limit;
		}
		public void setLimit(Long limit) {
			this.limit = limit;
		}
		public Boolean getRequestSuccess() {
			return this.requestSuccess;
		}
		public void setRequestSuccess(Boolean requestSuccess) {
			this.requestSuccess = requestSuccess;
		}
		public Long getStart() {
			return this.start;
		}
		public void setStart(Long start) {
			this.start = start;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}
		public Long getTotalPage() {
			return this.totalPage;
		}
		public void setTotalPage(Long totalPage) {
			this.totalPage = totalPage;
		}

}



}
