package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.logistics.returnorder.svc.search response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class LogisticsReturnorderSvcSearchResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6499841564116283931L;

	/** 
	 * 结果
	 */
	@ApiField("result")
	private SingleResultDTO result;


	public void setResult(SingleResultDTO result) {
		this.result = result;
	}
	public SingleResultDTO getResult( ) {
		return this.result;
	}
	
	/**
 * 数据
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ReturnLogisticsInfoDTO extends TaobaoObject {

	private static final long serialVersionUID = 7791423636364751961L;

	/**
		 * 发货运单号
		 */
		@ApiField("consign_mail_no")
		private String consignMailNo;
		/**
		 * 逆向退回物流单号
		 */
		@ApiField("return_mail_no")
		private String returnMailNo;
		/**
		 * 退回运单对应的物流编码
		 */
		@ApiField("return_tms_code")
		private String returnTmsCode;
		/**
		 * 商家店铺id
		 */
		@ApiField("seller_id")
		private Long sellerId;
		/**
		 * 淘宝交易单号
		 */
		@ApiField("trade_id")
		private String tradeId;
	

	public String getConsignMailNo() {
			return this.consignMailNo;
		}
		public void setConsignMailNo(String consignMailNo) {
			this.consignMailNo = consignMailNo;
		}
		public String getReturnMailNo() {
			return this.returnMailNo;
		}
		public void setReturnMailNo(String returnMailNo) {
			this.returnMailNo = returnMailNo;
		}
		public String getReturnTmsCode() {
			return this.returnTmsCode;
		}
		public void setReturnTmsCode(String returnTmsCode) {
			this.returnTmsCode = returnTmsCode;
		}
		public Long getSellerId() {
			return this.sellerId;
		}
		public void setSellerId(Long sellerId) {
			this.sellerId = sellerId;
		}
		public String getTradeId() {
			return this.tradeId;
		}
		public void setTradeId(String tradeId) {
			this.tradeId = tradeId;
		}

}

	/**
 * 结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SingleResultDTO extends TaobaoObject {

	private static final long serialVersionUID = 3218252191142991779L;

	/**
		 * 错误码
		 */
		@ApiField("err_code")
		private String errCode;
		/**
		 * 错误描述
		 */
		@ApiField("err_desc")
		private String errDesc;
		/**
		 * 数据
		 */
		@ApiListField("return_order_list")
		@ApiField("return_logistics_info_d_t_o")
		private List<ReturnLogisticsInfoDTO> returnOrderList;
		/**
		 * 调用结果
		 */
		@ApiField("success")
		private Boolean success;
	

	public String getErrCode() {
			return this.errCode;
		}
		public void setErrCode(String errCode) {
			this.errCode = errCode;
		}
		public String getErrDesc() {
			return this.errDesc;
		}
		public void setErrDesc(String errDesc) {
			this.errDesc = errDesc;
		}
		public List<ReturnLogisticsInfoDTO> getReturnOrderList() {
			return this.returnOrderList;
		}
		public void setReturnOrderList(List<ReturnLogisticsInfoDTO> returnOrderList) {
			this.returnOrderList = returnOrderList;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
