package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.logistics.reverseorder.erp.search response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class LogisticsReverseorderErpSearchResponse extends TaobaoResponse {

	private static final long serialVersionUID = 7395861132619756559L;

	/** 
	 * 结果
	 */
	@ApiField("result")
	private PaginationResult result;


	public void setResult(PaginationResult result) {
		this.result = result;
	}
	public PaginationResult getResult( ) {
		return this.result;
	}
	
	/**
 * 销退单主单
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ErpReverseOrderViewDTO extends TaobaoObject {

	private static final long serialVersionUID = 6355961511483697118L;

	/**
		 * 业务错误码
		 */
		@ApiField("biz_error_code")
		private String bizErrorCode;
		/**
		 * 系统错误信息
		 */
		@ApiField("biz_error_message")
		private String bizErrorMessage;
		/**
		 * 业务状态->创建	100101L 问题订单	100115L 待人工审核	100155L 待合单决策	100161L 待合单	100165L 待下发	100181L 下发履行成功状态	 下发履行成功	200105L 配作业状态	 配接单	300105L 已预约	300125L 预约异常	300130L 取件成功	300165L 城市中转仓入库	300205L 退供审核	300215L 待中转仓出库	300225L 城市中转仓出库成功	300235L 仓作业状态	 仓接单(等待退货到仓)	400105L 退货已到仓	400125L 质检完成收货	400145L 区外仓调拨上架	400165L 二次入区状态	 区外仓调拨出库	500105L 清关成功	500125L 清关失败	500130L 调拨入区内仓-仓配交接	500135L 完结状态	 退货完成	900110L 取消	900120L 仓拒收	900130L 取件失败	900140L 调拨入区外仓	900150L 保税仓调拨入库	900160L
		 */
		@ApiField("biz_order_status")
		private Long bizOrderStatus;
		/**
		 * g_logistics：物流模式 tc_order_id：2C交易订单 distributorId：分销商ID distributorNick：分销商名称 distributeMode：银河 fxBizCode：淘分销 scpMergeFlag：合单 preLgOrderCode：正向发货LP cancelReason：取消原因 signRejectReason：拒收原因 receiveFailReason：收货失败原因 closeOrderReason：关单原因 picUrls：仓库回传验货图片 manualRemark：备注
		 */
		@ApiField("feature_map")
		private String featureMap;
		/**
		 * 履行时间-> key(含义) WMS_ACCEPT(仓接单) WMS_ARRIVE(到仓)  CUSTOMS_REFUND_AUDIT_SUCCESS(逆向海关通过) WMS_ON_SHELF(仓上架)  EXTERNAL_WMS_OUT(区外仓出库)  BONDED_RETURN_IN(保税仓入库)  SEND_FULFIL(下发履行)  -> value 为时间戳
		 */
		@ApiField("fulfil_time_info")
		private String fulfilTimeInfo;
		/**
		 * 创建时间
		 */
		@ApiField("gmt_create")
		private Date gmtCreate;
		/**
		 * 修改时间
		 */
		@ApiField("gmt_modified")
		private Date gmtModified;
		/**
		 * 逆向物流订单号
		 */
		@ApiField("lg_order_code")
		private String lgOrderCode;
		/**
		 * 运单号
		 */
		@ApiField("mail_no")
		private String mailNo;
		/**
		 * 销退单单号
		 */
		@ApiField("order_code")
		private String orderCode;
		/**
		 * 系统状态->100 待下发状态 200 下发履行成功状态 300 配作业状态 400 仓作业状态 500 二次入区状态 900 完结状态
		 */
		@ApiField("order_status")
		private Long orderStatus;
		/**
		 * 货主
		 */
		@ApiField("owner_id")
		private Long ownerId;
		/**
		 * 正向履约单号
		 */
		@ApiField("prev_scp_ordercode")
		private String prevScpOrdercode;
		/**
		 * 销退类型->(1, "客退") (2, "运配异常") (3, "拒签退回") (4, "拦截退回") (5, "上门取退") (6, "清关退运")
		 */
		@ApiField("return_type")
		private Long returnType;
		/**
		 * 卖家
		 */
		@ApiField("seller_id")
		private Long sellerId;
		/**
		 * 业务来源->(1 "手工创建") (2 "退款自动创建") (3 "拒签自动创建") (4 "拦截自动创建") (5 "无指令登记自动创建") (6 "配送异常退回自动创建") (7 "外部系统创建") (8 "下游拉单创建") (9 "ERP推单创建") (10 "正向清关失败退回") (-1 "历史迁移数据") (-2 "历史多段退数据") (11 "跨租户协同调用创建") (12 "渠道推单创建")
		 */
		@ApiField("source_biz")
		private Long sourceBiz;
		/**
		 * 退货仓code
		 */
		@ApiField("store_code")
		private String storeCode;
		/**
		 * 配送公司编码
		 */
		@ApiField("tms_code")
		private String tmsCode;
		/**
		 * 交易单号
		 */
		@ApiField("trade_id")
		private String tradeId;
		/**
		 * 逆向仓储单号
		 */
		@ApiField("wlb_order_code")
		private String wlbOrderCode;
	

	public String getBizErrorCode() {
			return this.bizErrorCode;
		}
		public void setBizErrorCode(String bizErrorCode) {
			this.bizErrorCode = bizErrorCode;
		}
		public String getBizErrorMessage() {
			return this.bizErrorMessage;
		}
		public void setBizErrorMessage(String bizErrorMessage) {
			this.bizErrorMessage = bizErrorMessage;
		}
		public Long getBizOrderStatus() {
			return this.bizOrderStatus;
		}
		public void setBizOrderStatus(Long bizOrderStatus) {
			this.bizOrderStatus = bizOrderStatus;
		}
		public String getFeatureMap() {
			return this.featureMap;
		}
		public void setFeatureMap(String featureMap) {
			this.featureMap = featureMap;
		}
		public void setFeatureMapString(String featureMap) {
			this.featureMap = featureMap;
		}
		
		public String getFulfilTimeInfo() {
			return this.fulfilTimeInfo;
		}
		public void setFulfilTimeInfo(String fulfilTimeInfo) {
			this.fulfilTimeInfo = fulfilTimeInfo;
		}
		public void setFulfilTimeInfoString(String fulfilTimeInfo) {
			this.fulfilTimeInfo = fulfilTimeInfo;
		}
		
		public Date getGmtCreate() {
			return this.gmtCreate;
		}
		public void setGmtCreate(Date gmtCreate) {
			this.gmtCreate = gmtCreate;
		}
		public Date getGmtModified() {
			return this.gmtModified;
		}
		public void setGmtModified(Date gmtModified) {
			this.gmtModified = gmtModified;
		}
		public String getLgOrderCode() {
			return this.lgOrderCode;
		}
		public void setLgOrderCode(String lgOrderCode) {
			this.lgOrderCode = lgOrderCode;
		}
		public String getMailNo() {
			return this.mailNo;
		}
		public void setMailNo(String mailNo) {
			this.mailNo = mailNo;
		}
		public String getOrderCode() {
			return this.orderCode;
		}
		public void setOrderCode(String orderCode) {
			this.orderCode = orderCode;
		}
		public Long getOrderStatus() {
			return this.orderStatus;
		}
		public void setOrderStatus(Long orderStatus) {
			this.orderStatus = orderStatus;
		}
		public Long getOwnerId() {
			return this.ownerId;
		}
		public void setOwnerId(Long ownerId) {
			this.ownerId = ownerId;
		}
		public String getPrevScpOrdercode() {
			return this.prevScpOrdercode;
		}
		public void setPrevScpOrdercode(String prevScpOrdercode) {
			this.prevScpOrdercode = prevScpOrdercode;
		}
		public Long getReturnType() {
			return this.returnType;
		}
		public void setReturnType(Long returnType) {
			this.returnType = returnType;
		}
		public Long getSellerId() {
			return this.sellerId;
		}
		public void setSellerId(Long sellerId) {
			this.sellerId = sellerId;
		}
		public Long getSourceBiz() {
			return this.sourceBiz;
		}
		public void setSourceBiz(Long sourceBiz) {
			this.sourceBiz = sourceBiz;
		}
		public String getStoreCode() {
			return this.storeCode;
		}
		public void setStoreCode(String storeCode) {
			this.storeCode = storeCode;
		}
		public String getTmsCode() {
			return this.tmsCode;
		}
		public void setTmsCode(String tmsCode) {
			this.tmsCode = tmsCode;
		}
		public String getTradeId() {
			return this.tradeId;
		}
		public void setTradeId(String tradeId) {
			this.tradeId = tradeId;
		}
		public String getWlbOrderCode() {
			return this.wlbOrderCode;
		}
		public void setWlbOrderCode(String wlbOrderCode) {
			this.wlbOrderCode = wlbOrderCode;
		}

}

	/**
 * 销退二级明细
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ErpReverseOrderReturnItemViewDTO extends TaobaoObject {

	private static final long serialVersionUID = 4684795868639725527L;

	/**
		 * 扩展字段
		 */
		@ApiField("feature_map")
		private String featureMap;
		/**
		 * 库存类型
		 */
		@ApiField("inventory_type")
		private Long inventoryType;
		/**
		 * 数量
		 */
		@ApiField("quantity")
		private Long quantity;
	

	public String getFeatureMap() {
			return this.featureMap;
		}
		public void setFeatureMap(String featureMap) {
			this.featureMap = featureMap;
		}
		public void setFeatureMapString(String featureMap) {
			this.featureMap = featureMap;
		}
		
		public Long getInventoryType() {
			return this.inventoryType;
		}
		public void setInventoryType(Long inventoryType) {
			this.inventoryType = inventoryType;
		}
		public Long getQuantity() {
			return this.quantity;
		}
		public void setQuantity(Long quantity) {
			this.quantity = quantity;
		}

}

	/**
 * 销退单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ErpReverseOrderItemViewDTO extends TaobaoObject {

	private static final long serialVersionUID = 8134984958273434317L;

	/**
		 * 条形码
		 */
		@ApiField("bar_code")
		private String barCode;
		/**
		 * 组合货品主品Id
		 */
		@ApiField("combine_item_id")
		private Long combineItemId;
		/**
		 * 组合货品主品名称
		 */
		@ApiField("combine_item_name")
		private String combineItemName;
		/**
		 * 组合货品交易下单数量
		 */
		@ApiField("combine_qty")
		private Long combineQty;
		/**
		 * 残品数量
		 */
		@ApiField("damage_quantity")
		private Long damageQuantity;
		/**
		 * tc_order_id：2C交易订单 tc_suborder_id：2C交易子订单 refundReason：退货原因 refundReasonId：退货原因ID
		 */
		@ApiField("feature_map")
		private String featureMap;
		/**
		 * 明细主键id
		 */
		@ApiField("id")
		private Long id;
		/**
		 * 前端商品Code
		 */
		@ApiField("item_code")
		private String itemCode;
		/**
		 * 前端商品Id
		 */
		@ApiField("item_id")
		private Long itemId;
		/**
		 * 前端商品名称
		 */
		@ApiField("item_name")
		private String itemName;
		/**
		 * 计划数量
		 */
		@ApiField("plan_quantity")
		private Long planQuantity;
		/**
		 * 实际上架数量
		 */
		@ApiField("real_quantity")
		private Long realQuantity;
		/**
		 * 销退二级明细
		 */
		@ApiListField("reverse_order_return_item_list")
		@ApiField("erp_reverse_order_return_item_view_d_t_o")
		private List<ErpReverseOrderReturnItemViewDTO> reverseOrderReturnItemList;
		/**
		 * 货品code
		 */
		@ApiField("sc_item_code")
		private String scItemCode;
		/**
		 * 货品id
		 */
		@ApiField("sc_item_id")
		private Long scItemId;
		/**
		 * 后端货品名称
		 */
		@ApiField("sc_item_name")
		private String scItemName;
		/**
		 * skuId
		 */
		@ApiField("sku_id")
		private Long skuId;
		/**
		 * 子交易单id
		 */
		@ApiField("sub_trade_id")
		private String subTradeId;
		/**
		 * 交易单号
		 */
		@ApiField("trade_id")
		private String tradeId;
	

	public String getBarCode() {
			return this.barCode;
		}
		public void setBarCode(String barCode) {
			this.barCode = barCode;
		}
		public Long getCombineItemId() {
			return this.combineItemId;
		}
		public void setCombineItemId(Long combineItemId) {
			this.combineItemId = combineItemId;
		}
		public String getCombineItemName() {
			return this.combineItemName;
		}
		public void setCombineItemName(String combineItemName) {
			this.combineItemName = combineItemName;
		}
		public Long getCombineQty() {
			return this.combineQty;
		}
		public void setCombineQty(Long combineQty) {
			this.combineQty = combineQty;
		}
		public Long getDamageQuantity() {
			return this.damageQuantity;
		}
		public void setDamageQuantity(Long damageQuantity) {
			this.damageQuantity = damageQuantity;
		}
		public String getFeatureMap() {
			return this.featureMap;
		}
		public void setFeatureMap(String featureMap) {
			this.featureMap = featureMap;
		}
		public void setFeatureMapString(String featureMap) {
			this.featureMap = featureMap;
		}
		
		public Long getId() {
			return this.id;
		}
		public void setId(Long id) {
			this.id = id;
		}
		public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public Long getItemId() {
			return this.itemId;
		}
		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}
		public String getItemName() {
			return this.itemName;
		}
		public void setItemName(String itemName) {
			this.itemName = itemName;
		}
		public Long getPlanQuantity() {
			return this.planQuantity;
		}
		public void setPlanQuantity(Long planQuantity) {
			this.planQuantity = planQuantity;
		}
		public Long getRealQuantity() {
			return this.realQuantity;
		}
		public void setRealQuantity(Long realQuantity) {
			this.realQuantity = realQuantity;
		}
		public List<ErpReverseOrderReturnItemViewDTO> getReverseOrderReturnItemList() {
			return this.reverseOrderReturnItemList;
		}
		public void setReverseOrderReturnItemList(List<ErpReverseOrderReturnItemViewDTO> reverseOrderReturnItemList) {
			this.reverseOrderReturnItemList = reverseOrderReturnItemList;
		}
		public String getScItemCode() {
			return this.scItemCode;
		}
		public void setScItemCode(String scItemCode) {
			this.scItemCode = scItemCode;
		}
		public Long getScItemId() {
			return this.scItemId;
		}
		public void setScItemId(Long scItemId) {
			this.scItemId = scItemId;
		}
		public String getScItemName() {
			return this.scItemName;
		}
		public void setScItemName(String scItemName) {
			this.scItemName = scItemName;
		}
		public Long getSkuId() {
			return this.skuId;
		}
		public void setSkuId(Long skuId) {
			this.skuId = skuId;
		}
		public String getSubTradeId() {
			return this.subTradeId;
		}
		public void setSubTradeId(String subTradeId) {
			this.subTradeId = subTradeId;
		}
		public String getTradeId() {
			return this.tradeId;
		}
		public void setTradeId(String tradeId) {
			this.tradeId = tradeId;
		}

}

	/**
 * 数据列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ErpFullReverseOrderViewDTO extends TaobaoObject {

	private static final long serialVersionUID = 2628652432567536354L;

	/**
		 * 销退单主单
		 */
		@ApiField("reverse_order")
		private ErpReverseOrderViewDTO reverseOrder;
		/**
		 * 销退单明细
		 */
		@ApiListField("reverse_order_item_list")
		@ApiField("erp_reverse_order_item_view_d_t_o")
		private List<ErpReverseOrderItemViewDTO> reverseOrderItemList;
	

	public ErpReverseOrderViewDTO getReverseOrder() {
			return this.reverseOrder;
		}
		public void setReverseOrder(ErpReverseOrderViewDTO reverseOrder) {
			this.reverseOrder = reverseOrder;
		}
		public List<ErpReverseOrderItemViewDTO> getReverseOrderItemList() {
			return this.reverseOrderItemList;
		}
		public void setReverseOrderItemList(List<ErpReverseOrderItemViewDTO> reverseOrderItemList) {
			this.reverseOrderItemList = reverseOrderItemList;
		}

}

	/**
 * 结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PaginationResult extends TaobaoObject {

	private static final long serialVersionUID = 8151229711326118537L;

	/**
		 * 数据列表
		 */
		@ApiListField("data_list")
		@ApiField("erp_full_reverse_order_view_d_t_o")
		private List<ErpFullReverseOrderViewDTO> dataList;
		/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误描述
		 */
		@ApiField("error_desc")
		private String errorDesc;
		/**
		 * 本次分页查询的数量限制
		 */
		@ApiField("limit")
		private Long limit;
		/**
		 * 调用是否成功
		 */
		@ApiField("request_success")
		private Boolean requestSuccess;
		/**
		 * 记录偏移量
		 */
		@ApiField("start")
		private Long start;
		/**
		 * 总数
		 */
		@ApiField("total_count")
		private Long totalCount;
		/**
		 * 总页数
		 */
		@ApiField("total_page")
		private Long totalPage;
	

	public List<ErpFullReverseOrderViewDTO> getDataList() {
			return this.dataList;
		}
		public void setDataList(List<ErpFullReverseOrderViewDTO> dataList) {
			this.dataList = dataList;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getErrorDesc() {
			return this.errorDesc;
		}
		public void setErrorDesc(String errorDesc) {
			this.errorDesc = errorDesc;
		}
		public Long getLimit() {
			return this.limit;
		}
		public void setLimit(Long limit) {
			this.limit = limit;
		}
		public Boolean getRequestSuccess() {
			return this.requestSuccess;
		}
		public void setRequestSuccess(Boolean requestSuccess) {
			this.requestSuccess = requestSuccess;
		}
		public Long getStart() {
			return this.start;
		}
		public void setStart(Long start) {
			this.start = start;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}
		public Long getTotalPage() {
			return this.totalPage;
		}
		public void setTotalPage(Long totalPage) {
			this.totalPage = totalPage;
		}

}



}
