package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.logistics.trace.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class LogisticsTraceGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 3886263226893584711L;

	/** 
	 * 返回对象
	 */
	@ApiListField("result")
	@ApiField("transit_step_result")
	private List<TransitStepResult> result;


	public void setResult(List<TransitStepResult> result) {
		this.result = result;
	}
	public List<TransitStepResult> getResult( ) {
		return this.result;
	}
	
	/**
 * 列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TransitStepInfo extends TaobaoObject {

	private static final long serialVersionUID = 2143322231874694375L;

	/**
		 * 节点说明 ，指明当前节点揽收、派送，签收。
		 */
		@ApiField("action")
		private String action;
		/**
		 * 状态描述
		 */
		@ApiField("status_desc")
		private String statusDesc;
		/**
		 * 状态发生的时间
		 */
		@ApiField("status_time")
		private String statusTime;
	

	public String getAction() {
			return this.action;
		}
		public void setAction(String action) {
			this.action = action;
		}
		public String getStatusDesc() {
			return this.statusDesc;
		}
		public void setStatusDesc(String statusDesc) {
			this.statusDesc = statusDesc;
		}
		public String getStatusTime() {
			return this.statusTime;
		}
		public void setStatusTime(String statusTime) {
			this.statusTime = statusTime;
		}

}

	/**
 * 返回对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TransitStepResult extends TaobaoObject {

	private static final long serialVersionUID = 1547667465535891918L;

	/**
		 * 物流公司名称
		 */
		@ApiField("company_name")
		private String companyName;
		/**
		 * 运单号
		 */
		@ApiField("out_sid")
		private String outSid;
		/**
		 * 订单物流状态
		 */
		@ApiField("status")
		private String status;
		/**
		 * 交易号
		 */
		@ApiField("tid")
		private Long tid;
		/**
		 * 列表
		 */
		@ApiListField("trace_list")
		@ApiField("transit_step_info")
		private List<TransitStepInfo> traceList;
	

	public String getCompanyName() {
			return this.companyName;
		}
		public void setCompanyName(String companyName) {
			this.companyName = companyName;
		}
		public String getOutSid() {
			return this.outSid;
		}
		public void setOutSid(String outSid) {
			this.outSid = outSid;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public Long getTid() {
			return this.tid;
		}
		public void setTid(Long tid) {
			this.tid = tid;
		}
		public List<TransitStepInfo> getTraceList() {
			return this.traceList;
		}
		public void setTraceList(List<TransitStepInfo> traceList) {
			this.traceList = traceList;
		}

}



}
