package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.logistics.trace.search response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class LogisticsTraceSearchResponse extends TaobaoResponse {

	private static final long serialVersionUID = 8622175249984552647L;

	/** 
	 * 物流公司名称
	 */
	@ApiField("company_name")
	private String companyName;

	/** 
	 * 运单号
	 */
	@ApiField("out_sid")
	private String outSid;

	/** 
	 * 订单的物流状态
	 */
	@ApiField("status")
	private String status;

	/** 
	 * 交易号
	 */
	@ApiField("tid")
	private Long tid;

	/** 
	 * 流转信息列表
	 */
	@ApiListField("trace_list")
	@ApiField("transit_step_info")
	private List<TransitStepInfo> traceList;


	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}
	public String getCompanyName( ) {
		return this.companyName;
	}

	public void setOutSid(String outSid) {
		this.outSid = outSid;
	}
	public String getOutSid( ) {
		return this.outSid;
	}

	public void setStatus(String status) {
		this.status = status;
	}
	public String getStatus( ) {
		return this.status;
	}

	public void setTid(Long tid) {
		this.tid = tid;
	}
	public Long getTid( ) {
		return this.tid;
	}

	public void setTraceList(List<TransitStepInfo> traceList) {
		this.traceList = traceList;
	}
	public List<TransitStepInfo> getTraceList( ) {
		return this.traceList;
	}
	
	/**
 * 流转信息列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TransitStepInfo extends TaobaoObject {

	private static final long serialVersionUID = 5263946813351425898L;

	/**
		 * 节点说明 ，指明当前节点揽收、派送，签收。
		 */
		@ApiField("action")
		private String action;
		/**
		 * 状态描述
		 */
		@ApiField("status_desc")
		private String statusDesc;
		/**
		 * 状态发生的时间
		 */
		@ApiField("status_time")
		private String statusTime;
	

	public String getAction() {
			return this.action;
		}
		public void setAction(String action) {
			this.action = action;
		}
		public String getStatusDesc() {
			return this.statusDesc;
		}
		public void setStatusDesc(String statusDesc) {
			this.statusDesc = statusDesc;
		}
		public String getStatusTime() {
			return this.statusTime;
		}
		public void setStatusTime(String statusTime) {
			this.statusTime = statusTime;
		}

}



}
