package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.top.secret.bill.detail response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TopSecretBillDetailResponse extends TaobaoResponse {

	private static final long serialVersionUID = 7381393929954532584L;

	/** 
	 * 账单明细
	 */
	@ApiListField("data")
	@ApiField("bill_detail_info")
	private List<BillDetailInfo> data;

	/** 
	 * 账单总个数
	 */
	@ApiField("total_num")
	private Long totalNum;


	public void setData(List<BillDetailInfo> data) {
		this.data = data;
	}
	public List<BillDetailInfo> getData( ) {
		return this.data;
	}

	public void setTotalNum(Long totalNum) {
		this.totalNum = totalNum;
	}
	public Long getTotalNum( ) {
		return this.totalNum;
	}
	
	/**
 * 账单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BillDetailInfo extends TaobaoObject {

	private static final long serialVersionUID = 7827557967534847715L;

	/**
		 * 账单持续时间，号租费时单位为天，通话费单位为分钟
		 */
		@ApiField("bill_duration")
		private Long billDuration;
		/**
		 * 0-号租费，1-通话费
		 */
		@ApiField("bill_item")
		private Long billItem;
		/**
		 * 账单计费
		 */
		@ApiField("cost")
		private String cost;
		/**
		 * 账单结束时间
		 */
		@ApiField("end")
		private Date end;
		/**
		 * 订单号
		 */
		@ApiField("order_id")
		private Long orderId;
		/**
		 * 虚拟号
		 */
		@ApiField("secret_no")
		private String secretNo;
		/**
		 * 账单开始时间
		 */
		@ApiField("start")
		private Date start;
	

	public Long getBillDuration() {
			return this.billDuration;
		}
		public void setBillDuration(Long billDuration) {
			this.billDuration = billDuration;
		}
		public Long getBillItem() {
			return this.billItem;
		}
		public void setBillItem(Long billItem) {
			this.billItem = billItem;
		}
		public String getCost() {
			return this.cost;
		}
		public void setCost(String cost) {
			this.cost = cost;
		}
		public Date getEnd() {
			return this.end;
		}
		public void setEnd(Date end) {
			this.end = end;
		}
		public Long getOrderId() {
			return this.orderId;
		}
		public void setOrderId(Long orderId) {
			this.orderId = orderId;
		}
		public String getSecretNo() {
			return this.secretNo;
		}
		public void setSecretNo(String secretNo) {
			this.secretNo = secretNo;
		}
		public Date getStart() {
			return this.start;
		}
		public void setStart(Date start) {
			this.start = start;
		}

}



}
