/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.exception;

import com.businessobjects.foundation.exception.DeserializedException;
import com.businessobjects.foundation.exception.DeserializedRuntimeException;
import com.businessobjects.foundation.exception.ExceptionWorker;
import com.businessobjects.foundation.exception.IException;
import com.businessobjects.foundation.exception.SerializationException;
import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExceptionSerializer {
    private static final ILogger LOG = LoggerManager.getLogger("com.businessobjects.foundation.exception.ExceptionSerializer");
    public static String TAG_KIND = "Kind";
    public static String TAG_CODE = "Code";
    public static String TAG_MESSAGES = "Messages";
    public static String TAG_ARGUMENTS = "Arguments";
    public static String TAG_ARGUMENT = "Argument";
    public static String TAG_CAUSE = "Cause";
    public static String TAG_EXCEPTION = "Exception";
    public static String UNCHECKED_EXCEPTION = "UNCHECKED";
    public static String CHECKED_EXCEPTION = "CHECKED";
    public static String TAG_MSG = "Message";
    public static String ARG_TAG_STACK_TRACE = "StackTrace";
    public static String ARG_TAG_NAME = "name";
    public static String ARG_TAG_LANG = "Language";
    public static String ARG_TAG_COUNTRY = "Country";
    public static String ARG_TAG_INDEX = "index";
    public static String ARG_TAG_VARIANT = "Variant";
    public static String ARG_TAG_TYPE = "type";
    public static String TYPE_STRING = "xs:string";
    public static String TYPE_DATETIME = "xs:dateTime";
    public static String TYPE_INTEGER = "xs:integer";
    public static String TYPE_SHORT = "xs:short";
    public static String TYPE_LONG = "xs:long";
    public static String TYPE_DECIMAL = "xs:decimal";
    private Document m_doc;
    private ExceptionWorker m_exceptionWorker;
    private HashMap m_errorMessages = new HashMap();
    private Object[] m_args;
    private String m_stackTrace;

    public ExceptionSerializer(ExceptionWorker ew, HashMap errorMessages, Object[] args, String stackTrace) {
        this.m_exceptionWorker = ew;
        this.m_errorMessages = errorMessages;
        this.m_args = args;
        this.m_stackTrace = stackTrace;
    }

    protected String serialize() {
        try {
            Document doc = this.createErrorDoc();
            StringWriter sw = new StringWriter();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            return sw.toString();
        }
        catch (TransformerException e) {
            LOG.error("Failed to serialize exception", e);
            return "";
        }
        catch (SerializationException se) {
            LOG.error("Failed to serialize exception", se);
            return "";
        }
        catch (Exception e) {
            LOG.error("Failed to serialize exception", e);
            return "";
        }
    }

    private Node getRootNode() throws SerializationException {
        Element stack;
        Element arguments;
        Element errorMessages;
        Element root = this.m_doc.createElement(TAG_EXCEPTION);
        Element errorKind = this.m_doc.createElement(TAG_KIND);
        String kind = this.m_exceptionWorker.isCheckedException() ? CHECKED_EXCEPTION : UNCHECKED_EXCEPTION;
        Text kindNode = this.m_doc.createTextNode(kind);
        root.appendChild(errorKind);
        errorKind.appendChild(kindNode);
        Element errorCode = this.m_doc.createElement(TAG_CODE);
        String code = this.m_exceptionWorker.getErrorCode();
        if (code != null) {
            Text codeNode = this.m_doc.createTextNode(code);
            root.appendChild(errorCode);
            errorCode.appendChild(codeNode);
        }
        if ((errorMessages = this.getMessagesNode()).getChildNodes().getLength() > 0) {
            root.appendChild(errorMessages);
        }
        if ((arguments = this.getArgumentNode()).getChildNodes().getLength() > 0) {
            root.appendChild(arguments);
        }
        if (this.m_stackTrace != null) {
            stack = this.getStackTraceNode(this.m_stackTrace);
            this.m_stackTrace = null;
        } else {
            String stackStr = ExceptionSerializer.getStackTrace(this.m_exceptionWorker.getCause());
            stack = this.getStackTraceNode(stackStr);
        }
        root.appendChild(stack);
        Throwable cause = this.m_exceptionWorker.getCause();
        if (cause != null) {
            Node causeNode = this.getCauseNode(cause);
            root.appendChild(causeNode);
        }
        return root;
    }

    private Node getCauseNode(Throwable cause) {
        Element causeElement = this.m_doc.createElement(TAG_CAUSE);
        Node causeNode = null;
        String causeStr = "";
        if (cause != null) {
            if (cause instanceof IException) {
                causeStr = ((IException)((Object)cause)).serialize();
                Document causeDoc = null;
                try {
                    causeDoc = ExceptionSerializer.serializeStringToDocument(causeStr);
                    causeNode = this.m_doc.importNode(causeDoc.getDocumentElement(), true);
                }
                catch (SerializationException e) {
                    LOG.error("Failed to parse exception cause " + e.getDetailMessage());
                }
            } else {
                causeNode = this.m_doc.createElement(TAG_EXCEPTION);
                Element msgsNode = this.m_doc.createElement(TAG_MESSAGES);
                Element msgNode = this.m_doc.createElement(TAG_MSG);
                Attr langAttr = this.m_doc.createAttribute(ARG_TAG_LANG);
                msgNode.setAttributeNode(langAttr);
                Locale loc = Locale.getDefault();
                langAttr.setValue(loc.getLanguage());
                String msgStr = cause.getLocalizedMessage();
                Text msg = msgStr != null ? this.m_doc.createTextNode(cause.getLocalizedMessage()) : this.m_doc.createTextNode("null");
                msgNode.appendChild(msg);
                String stackStr = ExceptionSerializer.getStackTrace(cause);
                Element stackTraceNode = this.getStackTraceNode(stackStr);
                msgNode.appendChild(msg);
                msgsNode.appendChild(msgNode);
                causeNode.appendChild(msgsNode);
                causeNode.appendChild(stackTraceNode);
                Throwable nestedCause = cause.getCause();
                if (nestedCause != null && nestedCause != cause) {
                    Node nestedCauseNode = this.getCauseNode(nestedCause);
                    causeNode.appendChild(nestedCauseNode);
                }
            }
            if (causeNode != null) {
                causeElement.appendChild(causeNode);
            }
        }
        return causeElement;
    }

    private Element getStackTraceNode(String stackStr) {
        Element stackTraceNode = this.m_doc.createElement(ARG_TAG_STACK_TRACE);
        stackStr = stackStr.replaceAll("\r", " ");
        Text stack = this.m_doc.createTextNode(stackStr);
        stackTraceNode.appendChild(stack);
        return stackTraceNode;
    }

    private Element getMessagesNode() {
        Element errorMessages = this.m_doc.createElement(TAG_MESSAGES);
        Object[] langs = this.m_errorMessages.keySet().toArray();
        for (int i = 0; i < langs.length; ++i) {
            String msgStr;
            String variant;
            Element msgNode = this.m_doc.createElement(TAG_MSG);
            Locale loc = (Locale)langs[i];
            Attr langAttr = this.m_doc.createAttribute(ARG_TAG_LANG);
            msgNode.setAttributeNode(langAttr);
            langAttr.setValue(loc.getLanguage());
            String country = loc.getCountry();
            if (!country.equals("")) {
                Attr countryAttr = this.m_doc.createAttribute(ARG_TAG_COUNTRY);
                msgNode.setAttributeNode(countryAttr);
                countryAttr.setValue(country);
            }
            if (!(variant = loc.getVariant()).equals("")) {
                Attr variantAttr = this.m_doc.createAttribute(ARG_TAG_VARIANT);
                msgNode.setAttributeNode(variantAttr);
                variantAttr.setValue(variant);
            }
            if ((msgStr = (String)this.m_errorMessages.get(loc)) != null) {
                Text msg = this.m_doc.createTextNode(msgStr);
                msgNode.appendChild(msg);
            }
            errorMessages.appendChild(msgNode);
        }
        return errorMessages;
    }

    private Element getArgumentNode() throws SerializationException {
        Element argumentsNode = this.m_doc.createElement(TAG_ARGUMENTS);
        if (this.m_args != null) {
            for (int i = 0; i < this.m_args.length; ++i) {
                Element argumentNode = this.m_doc.createElement(TAG_ARGUMENT);
                Attr indexAttr = this.m_doc.createAttribute(ARG_TAG_INDEX);
                argumentNode.setAttributeNode(indexAttr);
                indexAttr.setValue(String.valueOf(i));
                Attr typeAttr = this.m_doc.createAttribute(ARG_TAG_TYPE);
                argumentNode.setAttributeNode(typeAttr);
                Object value = this.m_args[i];
                String valueStr = "";
                if (value instanceof String) {
                    valueStr = (String)value;
                    typeAttr.setValue(TYPE_STRING);
                } else if (value instanceof Date) {
                    valueStr = this.dateToString((Date)value);
                    typeAttr.setValue(TYPE_DATETIME);
                } else if (value instanceof Integer) {
                    valueStr = String.valueOf(value);
                    typeAttr.setValue(TYPE_INTEGER);
                } else if (value instanceof Long) {
                    valueStr = String.valueOf(value);
                    typeAttr.setValue(TYPE_LONG);
                } else if (value instanceof Short) {
                    valueStr = String.valueOf(value);
                    typeAttr.setValue(TYPE_SHORT);
                } else if (value instanceof Double) {
                    valueStr = String.valueOf(value);
                    typeAttr.setValue(TYPE_DECIMAL);
                } else {
                    LOG.error("The type " + value.getClass().getName() + " for exception message arguments is not supported.");
                    valueStr = String.valueOf(value);
                    typeAttr.setValue(TYPE_STRING);
                }
                Text msg = this.m_doc.createTextNode(valueStr);
                argumentNode.appendChild(msg);
                argumentsNode.appendChild(argumentNode);
            }
        }
        return argumentsNode;
    }

    private Document createErrorDoc() throws SerializationException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setIgnoringElementContentWhitespace(true);
            builderFactory.setIgnoringComments(true);
            builderFactory.setValidating(false);
            builderFactory.setNamespaceAware(false);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            this.m_doc = builder.newDocument();
            Node root = this.getRootNode();
            this.m_doc.appendChild(root);
            return this.m_doc;
        }
        catch (ParserConfigurationException e) {
            LOG.error("Failed to serialize exception", e);
            throw new SerializationException.ParseDocumentException(e);
        }
    }

    public static Throwable deserialize(String exceptionStr) throws SerializationException {
        Document doc = null;
        try {
            doc = ExceptionSerializer.serializeStringToDocument(exceptionStr);
        }
        catch (SerializationException e) {
            LOG.error("Error occured while parsing the serialized exception. " + e.getDetailMessage());
            throw new SerializationException.ParseDocumentException(e);
        }
        NodeList nl = doc.getElementsByTagName(TAG_EXCEPTION);
        if (nl.getLength() == 0) {
            LOG.error("The format of the string to be deserialized is invalid. Must start with an Exception XML element.");
            return new SerializationException.WrongFormatException();
        }
        Element exceptionNode = (Element)nl.item(0);
        Throwable exception = ExceptionSerializer.deserializeException(exceptionNode);
        return exception;
    }

    private static Throwable deserializeException(Element exceptionNode) {
        NodeList children = exceptionNode.getChildNodes();
        String kind = UNCHECKED_EXCEPTION;
        String errorCode = null;
        HashMap messages = new HashMap();
        Object[] args = new Object[]{};
        Throwable cause = null;
        String stackTrace = null;
        try {
            for (int i = 0; i < children.getLength(); ++i) {
                Node el = children.item(i);
                if (!(el instanceof Element)) continue;
                if (el.getNodeName().equalsIgnoreCase(TAG_KIND)) {
                    kind = ExceptionSerializer.deserializeErrorKind((Element)el);
                    continue;
                }
                if (el.getNodeName().equalsIgnoreCase(TAG_CODE)) {
                    errorCode = ExceptionSerializer.deserializeErrorCode((Element)el);
                    continue;
                }
                if (el.getNodeName().equalsIgnoreCase(TAG_MESSAGES)) {
                    messages = ExceptionSerializer.deserializeMessages((Element)el);
                    continue;
                }
                if (el.getNodeName().equalsIgnoreCase(TAG_ARGUMENTS)) {
                    args = ExceptionSerializer.deserializeArguments((Element)el);
                    continue;
                }
                if (el.getNodeName().equalsIgnoreCase(TAG_CAUSE)) {
                    cause = ExceptionSerializer.deserializeCause((Element)el);
                    continue;
                }
                if (!el.getNodeName().equalsIgnoreCase(ARG_TAG_STACK_TRACE)) continue;
                stackTrace = ExceptionSerializer.deserializeStackTrace((Element)el);
            }
        }
        catch (SerializationException e) {
            return e;
        }
        if (kind.equalsIgnoreCase(CHECKED_EXCEPTION)) {
            DeserializedException exception = cause != null ? new DeserializedException(args, cause, errorCode, messages) : new DeserializedException(args, errorCode, messages);
            if (stackTrace != null) {
                exception.setStackTrace(stackTrace);
            }
            return exception;
        }
        if (!kind.equalsIgnoreCase(CHECKED_EXCEPTION)) {
            LOG.warn("Invalid exception type: " + kind + ". An unchecked exception was created.");
        }
        DeserializedRuntimeException exception = cause != null ? new DeserializedRuntimeException(args, cause, errorCode, messages) : new DeserializedRuntimeException(args, errorCode, messages);
        if (stackTrace != null) {
            exception.setStackTrace(stackTrace);
        }
        return exception;
    }

    private static String deserializeErrorKind(Element codeNode) throws SerializationException {
        NodeList nl = codeNode.getChildNodes();
        if (nl.getLength() == 0) {
            LOG.error("Failed to deserialize the error kind. The node Kind has to contain a value.");
            throw new SerializationException.MissingNodeValueException(TAG_KIND);
        }
        if (nl.getLength() > 1) {
            LOG.error("Failed to deserialize the error kind. The node Kind contains more than one value.");
            throw new SerializationException.TooManyNodesException(TAG_KIND);
        }
        Node node = nl.item(0);
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        LOG.error("Failed to deserialize the error kind. The node Kind has to contain a value.");
        throw new SerializationException.MissingNodeValueException(TAG_KIND);
    }

    private static String deserializeErrorCode(Element codeNode) throws SerializationException {
        NodeList nl = codeNode.getChildNodes();
        if (nl.getLength() == 0) {
            LOG.error("The format of the string to be deserialized is invalid. Must contain a Code xml element.");
            throw new SerializationException.MissingNodeValueException(TAG_CODE);
        }
        if (nl.getLength() > 1) {
            LOG.error("Failed to deserialize the error code. The node Code contains more than one value.");
            throw new SerializationException.TooManyNodesException(TAG_CODE);
        }
        Node node = nl.item(0);
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        LOG.error("Failed to deserialize the error code. The node Code has to contain a value.");
        throw new SerializationException.MissingNodeValueException(TAG_CODE);
    }

    private static HashMap deserializeMessages(Element messagesNode) throws SerializationException {
        NodeList nl = messagesNode.getChildNodes();
        if (nl.getLength() == 0) {
            LOG.error("The format of the string to be deserialized is invalid. Must contain a Message xml element.");
            throw new SerializationException.MissingNodeValueException(TAG_MSG);
        }
        HashMap<Locale, String> errorMessages = new HashMap<Locale, String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node msg = nl.item(i);
            if (msg.getNodeType() == 3) continue;
            NamedNodeMap attrs = msg.getAttributes();
            Locale loc = ExceptionSerializer.deserializeLangAttrs(attrs);
            NodeList msgTextList = msg.getChildNodes();
            String msgText = "";
            if (msgTextList.getLength() == 0) {
                LOG.error("The format of the string to be deserialized is invalid. Must contain a Message xml element.");
                throw new SerializationException.MissingNodeValueException(TAG_MSG);
            }
            if (msgTextList.getLength() > 1) {
                LOG.error("Failed to deserialize the error message. The node Message contains more than one value.");
                throw new SerializationException.TooManyNodesException(TAG_MSG);
            }
            Node node = msgTextList.item(0);
            if (node.getNodeType() != 3) {
                LOG.error("Failed to deserialize the error message. The node Message has to contain a value.");
                throw new SerializationException.MissingNodeValueException(TAG_MSG);
            }
            msgText = node.getNodeValue();
            errorMessages.put(loc, msgText);
        }
        return errorMessages;
    }

    private static Locale deserializeLangAttrs(NamedNodeMap attrs) throws SerializationException.MissingLocale {
        Attr lang = (Attr)attrs.getNamedItem(ARG_TAG_LANG);
        if (lang == null) {
            throw new SerializationException.MissingLocale();
        }
        String langStr = lang.getValue();
        String countryStr = "";
        Attr country = (Attr)attrs.getNamedItem(ARG_TAG_COUNTRY);
        if (country != null) {
            countryStr = country.getValue();
        }
        String variantStr = "";
        Attr variant = (Attr)attrs.getNamedItem(ARG_TAG_VARIANT);
        if (variant != null) {
            variantStr = variant.getValue();
        }
        return new Locale(langStr, countryStr, variantStr);
    }

    private static Object[] deserializeArguments(Element argsNode) throws SerializationException {
        ArrayList<Object> args = new ArrayList<Object>();
        NodeList nl = argsNode.getChildNodes();
        if (nl.getLength() == 0) {
            return new Object[0];
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node arg = nl.item(i);
            if (arg.getNodeType() == 3) continue;
            NodeList argValueList = arg.getChildNodes();
            String argValueAsStr = "";
            if (argValueList.getLength() == 0) {
                LOG.error("The format of the string to be deserialized is invalid. Must contain an Argument XML element.");
                throw new SerializationException.MissingNodeValueException(TAG_ARGUMENT);
            }
            if (argValueList.getLength() > 1) {
                LOG.error("Failed to deserialize the error arguments. The node Arguments contains more than one value.");
                throw new SerializationException.TooManyNodesException(TAG_ARGUMENTS);
            }
            Node node = argValueList.item(0);
            if (node.getNodeType() != 3) {
                LOG.error("Failed to deserialize the error arguments. The node Argument has to contain a value.");
                throw new SerializationException.MissingNodeValueException(TAG_ARGUMENT);
            }
            argValueAsStr = node.getNodeValue();
            NamedNodeMap attrs = arg.getAttributes();
            Attr typeNode = (Attr)attrs.getNamedItem(ARG_TAG_TYPE);
            if (typeNode == null) {
                throw new SerializationException.MissingNodeAttribute(ARG_TAG_TYPE, TAG_ARGUMENT);
            }
            String type = typeNode.getValue();
            if (type.equalsIgnoreCase(TYPE_STRING)) {
                args.add(argValueAsStr);
                continue;
            }
            if (type.equalsIgnoreCase(TYPE_DATETIME)) {
                args.add(ExceptionSerializer.getDateFromString(argValueAsStr));
                continue;
            }
            if (type.equalsIgnoreCase(TYPE_INTEGER)) {
                args.add(Integer.valueOf(argValueAsStr));
                continue;
            }
            if (type.equalsIgnoreCase(TYPE_LONG)) {
                args.add(Long.valueOf(argValueAsStr));
                continue;
            }
            if (type.equalsIgnoreCase(TYPE_SHORT)) {
                args.add(Short.valueOf(argValueAsStr));
                continue;
            }
            if (type.equalsIgnoreCase(TYPE_DECIMAL)) {
                args.add(Double.valueOf(argValueAsStr));
                continue;
            }
            throw new SerializationException.ArgumentTypeNotSupported(type);
        }
        return args.toArray();
    }

    private static Throwable deserializeCause(Element causeNode) {
        NodeList nl = causeNode.getChildNodes();
        if (nl.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node cause = nl.item(i);
            if (cause.getNodeType() == 3) continue;
            return ExceptionSerializer.deserializeException((Element)cause);
        }
        return null;
    }

    private static String deserializeStackTrace(Element stackNode) throws SerializationException {
        String stackStrace = "";
        NodeList nl = stackNode.getChildNodes();
        if (nl.getLength() == 0) {
            return stackStrace;
        }
        if (nl.getLength() > 1) {
            LOG.error("Failed to deserialize the stack trace. The node StackTrace contains more than one value.");
            throw new SerializationException.TooManyNodesException(ARG_TAG_STACK_TRACE);
        }
        Node node = nl.item(0);
        if (node.getNodeType() == 3) {
            stackStrace = node.getNodeValue();
        }
        return stackStrace;
    }

    public static Date getDateFromString(String dateStr) {
        dateStr.replaceAll(" ", "");
        String yearStr = dateStr.substring(0, 4);
        int year = Integer.valueOf(yearStr);
        String monthStr = dateStr.substring(5, 7);
        int month = Integer.valueOf(monthStr);
        String dayStr = dateStr.substring(8, 10);
        int day = Integer.valueOf(dayStr);
        String hourStr = dateStr.substring(11, 13);
        int hour = Integer.valueOf(hourStr);
        String minuteStr = dateStr.substring(14, 16);
        int minute = Integer.valueOf(minuteStr);
        String secondStr = dateStr.substring(17, 19);
        int second = Integer.valueOf(secondStr);
        String timeZoneStr = dateStr.substring(19, dateStr.length());
        TimeZone timeZone = null;
        if (timeZoneStr.equalsIgnoreCase("Z")) {
            String[] ids = TimeZone.getAvailableIDs(0);
            if (ids.length > 0) {
                timeZone = TimeZone.getTimeZone(ids[0]);
            } else {
                ids = TimeZone.getAvailableIDs(0);
                timeZone = TimeZone.getTimeZone(ids[0]);
            }
        } else {
            String[] ids;
            String sign = timeZoneStr.substring(0, 1);
            String tzHourStr = timeZoneStr.substring(1, 3);
            int tzHour = Integer.valueOf(tzHourStr);
            String tzMinStr = timeZoneStr.substring(4, 6);
            int tzMin = Integer.valueOf(tzMinStr);
            int ms = tzHour * 3600000 + tzMin * 60000;
            if (sign.equals("-")) {
                ms = -1 * ms;
            }
            if ((ids = TimeZone.getAvailableIDs(ms)).length > 0) {
                timeZone = TimeZone.getTimeZone(ids[0]);
            } else {
                ids = TimeZone.getAvailableIDs(0);
                timeZone = TimeZone.getTimeZone(ids[0]);
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, hour, minute, second);
        cal.setTimeZone(timeZone);
        return cal.getTime();
    }

    protected static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    private static Document serializeStringToDocument(String serializedDoc) throws SerializationException {
        ByteArrayInputStream inStream;
        Document doc = null;
        StringBuffer stringBuffer = new StringBuffer(serializedDoc);
        try {
            inStream = new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            inStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
        }
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            InputSource inSource = new InputSource(inStream);
            doc = builder.parse(inSource);
        }
        catch (ParserConfigurationException pce) {
            LOG.error("Failed to serialize exception. Encountered ParserConfigurationException. " + pce.getMessage());
            throw new SerializationException.ExceptionWrapper(pce);
        }
        catch (SAXException se) {
            LOG.error("Failed to serialize exception. Encountered SAXException. " + se.getMessage());
            throw new SerializationException.ExceptionWrapper(se);
        }
        catch (IOException ioe) {
            LOG.error("Failed to serialize exception. Encountered IOException. " + ioe.getMessage());
            throw new SerializationException.ExceptionWrapper(ioe);
        }
        return doc;
    }

    private String dateToString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String year = String.valueOf(calendar.get(1));
        String month = this.convertIntToString(calendar.get(2));
        String day = this.convertIntToString(calendar.get(5));
        String hour = this.convertIntToString(calendar.get(11));
        String minute = this.convertIntToString(calendar.get(12));
        String second = this.convertIntToString(calendar.get(13));
        String timeZone = this.getTimeZoneFromMS(calendar.get(15));
        String dateStr = year + "-" + month + "-" + day + "T" + hour + ":" + minute + ":" + second + timeZone;
        return dateStr;
    }

    private String convertIntToString(int i) {
        String str = i < 10 ? "0" + String.valueOf(i) : String.valueOf(i);
        return str;
    }

    private String getTimeZoneFromMS(int milliSeconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(milliSeconds);
        String hour = this.convertIntToString(cal.get(10));
        String min = this.convertIntToString(cal.get(12));
        hour = milliSeconds < 0 ? "-" + hour + ":" + min : "+" + hour + ":" + min;
        return hour;
    }
}

