/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TimeoutTimer;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class TDSCommand {
    static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.Command");
    private final String logContext;
    private final TimeoutTimer timeoutTimer;
    private TDSWriter tdsWriter;
    private TDSReader tdsReader;
    private static final int NOT_STARTED = 0;
    private static final int REQUEST = 1;
    private static final int EXECUTION = 2;
    private static final int RESPONSE = 3;
    private static final int DONE = 4;
    private volatile int state;
    private SQLServerException interruptException;

    final String getLogContext() {
        return this.logContext;
    }

    public final String toString() {
        return "TDSCommand@" + Integer.toHexString(this.hashCode()) + " (" + this.logContext + ")";
    }

    final void log(Level level, String string) {
        logger.log(level, this.toString() + ": " + string);
    }

    TDSCommand(String string, int n) {
        this.logContext = string;
        this.timeoutTimer = n > 0 ? new TimeoutTimer(n, this) : null;
        this.state = 0;
        this.interruptException = null;
    }

    private final String getStateString(int n) {
        switch (n) {
            case 0: {
                return "NOT_STARTED";
            }
            case 1: {
                return "REQUEST";
            }
            case 2: {
                return "EXECUTION";
            }
            case 3: {
                return "RESPONSE";
            }
            case 4: {
                return "DONE";
            }
        }
        return "UNKNOWN";
    }

    private final int getState() {
        return this.state;
    }

    private final int setState(int n) {
        int n2 = this.state;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + ": Changing state from " + this.getStateString(n2) + " to " + this.getStateString(n));
        }
        this.state = n;
        return n2;
    }

    abstract boolean doExecute() throws SQLServerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean execute(TDSWriter tDSWriter, TDSReader tDSReader) throws SQLServerException {
        block16: {
            this.tdsWriter = tDSWriter;
            this.tdsReader = tDSReader;
            try {
                if (!this.doExecute()) break block16;
                TDSCommand tDSCommand = this;
                synchronized (tDSCommand) {
                    if (null != this.interruptException) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(this.toString() + ": execute throwing interrupt exception, reason=" + this.interruptException.getMessage());
                        }
                        throw this.interruptException;
                    }
                    this.setState(4);
                }
            }
            catch (SQLServerException sQLServerException) {
                int n = this.setState(4);
                if (1 == sQLServerException.getDriverErrorCode()) {
                    if (1 == n) {
                        if (tDSWriter.sendAttention()) {
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest(this.toString() + ": Request interrupted.  Reading response...");
                            }
                            tDSReader.readPacket();
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest(this.toString() + ": Processing response and attention ack...");
                            }
                            this.processInterruptedResponse(tDSReader);
                        }
                    } else {
                        assert (3 == n || 4 == n);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(this.toString() + ": Request already completed.  Processing response and attention ack...");
                        }
                        this.processInterruptedResponse(tDSReader);
                    }
                }
                throw sQLServerException;
            }
        }
        assert (3 == this.getState() || 4 == this.getState());
        return 4 == this.getState();
    }

    void processInterruptedResponse(TDSReader tDSReader) throws SQLServerException {
        this.processResponse(tDSReader);
        tDSReader.readPacket();
        class AttentionAckHandler
        extends TDSTokenHandler {
            AttentionAckHandler() {
                super("AttentionAckHandler");
            }

            @Override
            boolean onDone(TDSReader tDSReader) throws SQLServerException {
                StreamDone streamDone = new StreamDone();
                streamDone.setFromTDS(tDSReader);
                if (!streamDone.isAttnAck()) {
                    tDSReader.throwInvalidTDS();
                }
                return true;
            }
        }
        TDSParser.parse(tDSReader, new AttentionAckHandler());
    }

    void processResponse(TDSReader tDSReader) throws SQLServerException {
        block3: {
            try {
                TDSParser.parse(tDSReader, this.getLogContext());
            }
            catch (SQLServerException sQLServerException) {
                if (2 != sQLServerException.getDriverErrorCode()) {
                    throw sQLServerException;
                }
                if (!logger.isLoggable(Level.FINEST)) break block3;
                logger.finest(this.toString() + ": Ignoring error from database: " + sQLServerException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void detach() throws SQLServerException {
        if (3 != this.getState()) {
            assert (4 == this.getState() || 0 == this.getState());
            return;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + ": detaching...");
        }
        try {
            this.tdsReader.readResponse();
        }
        finally {
            this.setState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupt(String string) throws SQLServerException {
        TDSCommand tDSCommand = this;
        synchronized (tDSCommand) {
            if (null != this.interruptException) {
                return;
            }
            switch (this.getState()) {
                case 0: {
                    if (!logger.isLoggable(Level.FINEST)) break;
                    logger.finest(this.toString() + ": NOT_STARTED: Ignoring interrupt, reason=" + string);
                    break;
                }
                case 1: {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + ": REQUEST: Raising attention, reason=" + string);
                    }
                    this.interruptException = SQLServerException.makeInterruptException(string);
                    this.tdsWriter.raiseAttention(this.interruptException);
                    break;
                }
                case 2: {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + ": EXECUTION: Sending attention, reason=" + string);
                    }
                    this.interruptException = SQLServerException.makeInterruptException(string);
                    this.tdsWriter.sendAttention();
                    break;
                }
                case 3: {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + ": RESPONSE: Sending attention, reason=" + string);
                    }
                    this.interruptException = SQLServerException.makeInterruptException(string);
                    this.tdsWriter.sendAttention();
                    break;
                }
                case 4: {
                    if (!logger.isLoggable(Level.FINEST)) break;
                    logger.finest(this.toString() + ": DONE: Ignoring interrupt, reason=" + string);
                    break;
                }
                default: {
                    assert (false) : "Undefined command state " + this.getState();
                    break;
                }
            }
        }
    }

    final TDSWriter startRequest(byte by) throws SQLServerException {
        TDSCommand tDSCommand = this;
        synchronized (tDSCommand) {
            assert (0 == this.state || 3 == this.state || 4 == this.state);
            this.interruptException = null;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + ": Starting request...");
            }
            this.setState(1);
            try {
                return this.tdsWriter.startMessage(by);
            }
            catch (SQLServerException sQLServerException) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toString() + ": Exception starting request: " + sQLServerException.getMessage());
                }
                this.setState(4);
                throw sQLServerException;
            }
        }
    }

    final TDSReader startResponse() throws SQLServerException {
        return this.startResponse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TDSReader startResponse(boolean bl) throws SQLServerException {
        TDSCommand tDSCommand = this;
        synchronized (tDSCommand) {
            assert (1 == this.getState());
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + ": Finishing request...");
            }
            try {
                this.tdsWriter.endMessage();
            }
            catch (SQLServerException sQLServerException) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toString() + ": Exception finishing request: " + sQLServerException.getMessage());
                }
                this.setState(4);
                throw sQLServerException;
            }
            this.setState(2);
        }
        if (null != this.timeoutTimer) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + ": Starting timer...");
            }
            this.timeoutTimer.start();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + ": Reading response...");
        }
        try {
            this.tdsReader.readPacket();
            if (!bl) {
                this.tdsReader.readResponse();
            }
        }
        catch (SQLServerException sQLServerException) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + ": Exception reading response: " + sQLServerException.getMessage());
            }
            this.setState(4);
            throw sQLServerException;
        }
        finally {
            if (null != this.timeoutTimer) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toString() + ": Stopping timer...");
                }
                this.timeoutTimer.stop();
            }
        }
        int n = this.tdsReader.responseEOM() ? 4 : 3;
        TDSCommand tDSCommand2 = this;
        synchronized (tDSCommand2) {
            assert (2 == this.getState());
            this.setState(n);
            if (null != this.interruptException) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toString() + ": startResponse throwing interrupt exception, reason=" + this.interruptException.getMessage());
                }
                throw this.interruptException;
            }
        }
        return this.tdsReader;
    }
}

