/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.test.gateway;

import java.util.Collection;
import java.util.HashMap;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.CollectionAssertions;

public class InclusiveGatewayTest
extends JbpmTestCase {
    private static final String SIMPLE_SPLIT = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='simpleInclusiveSplit' >    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='inclusiveGateway' />    <inclusiveGateway id='inclusiveGateway' />    <sequenceFlow id='flow2' sourceRef='inclusiveGateway' targetRef='wait1' >      <conditionExpression xsi:type='tFormalExpression'>${var &gt; 5}</conditionExpression>    </sequenceFlow>    <sequenceFlow id='flow3' sourceRef='inclusiveGateway' targetRef='wait2' />    <sequenceFlow id='flow4' sourceRef='inclusiveGateway' targetRef='wait3' >      <conditionExpression xsi:type='tFormalExpression'>${var &gt; 10}</conditionExpression>    </sequenceFlow>    <receiveTask id='wait1' />    <sequenceFlow id='flow5' sourceRef='wait1' targetRef='theEnd' />    <receiveTask id='wait2' />    <sequenceFlow id='flow6' sourceRef='wait2' targetRef='theEnd' />    <receiveTask id='wait3' />    <sequenceFlow id='flow7' sourceRef='wait3' targetRef='theEnd' />    <endEvent id='theEnd' >      <terminateEventDefinition/>    </endEvent>  </process></definitions>";
    private static final String SIMPLE_SPLIT_WITH_DEFAULT = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='simpleInclusiveSplitWithDefault' >    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='inclusiveGateway' />    <inclusiveGateway id='inclusiveGateway' default='flow3' />    <sequenceFlow id='flow2' sourceRef='inclusiveGateway' targetRef='wait1' >      <conditionExpression xsi:type='tFormalExpression'>${var &gt; 5}</conditionExpression>    </sequenceFlow>    <sequenceFlow id='flow3' sourceRef='inclusiveGateway' targetRef='wait2' />    <sequenceFlow id='flow4' sourceRef='inclusiveGateway' targetRef='wait3' >      <conditionExpression xsi:type='tFormalExpression'>${var &gt; 10}</conditionExpression>    </sequenceFlow>    <receiveTask id='wait1' />    <sequenceFlow id='flow5' sourceRef='wait1' targetRef='theEnd' />    <receiveTask id='wait2' />    <sequenceFlow id='flow6' sourceRef='wait2' targetRef='theEnd' />    <receiveTask id='wait3' />    <sequenceFlow id='flow7' sourceRef='wait3' targetRef='theEnd' />    <endEvent id='theEnd' >      <terminateEventDefinition/>    </endEvent>  </process></definitions>";
    private static final String SIMPLE_SPLIT_AND_MERGE = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='simpleSplitAndMerge' >    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='inclusiveSplit' />    <inclusiveGateway id='inclusiveSplit' default='flow3' />    <sequenceFlow id='flow2' sourceRef='inclusiveSplit' targetRef='wait1' >      <conditionExpression xsi:type='tFormalExpression'>${var &gt; 5}</conditionExpression>    </sequenceFlow>    <sequenceFlow id='flow3' sourceRef='inclusiveSplit' targetRef='wait2' />    <sequenceFlow id='flow4' sourceRef='inclusiveSplit' targetRef='wait3' >      <conditionExpression xsi:type='tFormalExpression'>${var &gt; 10}</conditionExpression>    </sequenceFlow>    <receiveTask id='wait1' />    <sequenceFlow id='flow5' sourceRef='wait1' targetRef='inclusiveJoin' />    <receiveTask id='wait2' />    <sequenceFlow id='flow6' sourceRef='wait2' targetRef='inclusiveJoin' />    <receiveTask id='wait3' />    <sequenceFlow id='flow7' sourceRef='wait3' targetRef='inclusiveJoin' />    <inclusiveGateway id='inclusiveJoin' />    <sequenceFlow id='flow8' sourceRef='inclusiveJoin' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String NESTED_INCLUSIVE_SPLIT = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='nestedInclusiveSplit' >    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='inclusiveSplit' />    <inclusiveGateway id='inclusiveSplit' />    <sequenceFlow id='flow2' sourceRef='inclusiveSplit' targetRef='wait1' >      <conditionExpression xsi:type='tFormalExpression'>${var &gt; 5}</conditionExpression>    </sequenceFlow>    <sequenceFlow id='flow3' sourceRef='inclusiveSplit' targetRef='wait2' />    <sequenceFlow id='flow4' sourceRef='inclusiveSplit' targetRef='wait3' >      <conditionExpression xsi:type='tFormalExpression'>${var &gt; 10}</conditionExpression>    </sequenceFlow>    <receiveTask id='wait1' />    <sequenceFlow id='flow5' sourceRef='wait1' targetRef='wait4' >      <conditionExpression xsi:type='tFormalExpression'>${var == 6}</conditionExpression>    </sequenceFlow>    <sequenceFlow id='flow6a' sourceRef='wait1' targetRef='innerInclusiveSplit' >      <conditionExpression xsi:type='tFormalExpression'>${var &gt;= 7}</conditionExpression>    </sequenceFlow>    <sequenceFlow id='flow6b' sourceRef='wait1' targetRef='innerInclusiveSplit' >      <conditionExpression xsi:type='tFormalExpression'>${var &gt;= 9}</conditionExpression>    </sequenceFlow>    <receiveTask id='wait4' />    <sequenceFlow id='flow7' sourceRef='wait4' targetRef='inclusiveMerge' />    <inclusiveGateway id='innerInclusiveSplit' default='flow10'/>    <sequenceFlow id='flow8' sourceRef='innerInclusiveSplit' targetRef='wait5' >      <conditionExpression xsi:type='tFormalExpression'>${var &gt;= 8}</conditionExpression>    </sequenceFlow>    <sequenceFlow id='flow9' sourceRef='innerInclusiveSplit' targetRef='wait6' >      <conditionExpression xsi:type='tFormalExpression'>${var &gt;= 9}</conditionExpression>    </sequenceFlow>    <sequenceFlow id='flow10' sourceRef='innerInclusiveSplit' targetRef='wait7' />    <receiveTask id='wait5' />    <sequenceFlow id='flow11' sourceRef='wait5' targetRef='inclusiveMerge' />    <receiveTask id='wait6' />    <sequenceFlow id='flow12' sourceRef='wait6' targetRef='inclusiveMerge' />    <receiveTask id='wait7' />    <sequenceFlow id='flow13' sourceRef='wait7' targetRef='inclusiveMerge' />    <receiveTask id='wait2' />    <sequenceFlow id='flow14' sourceRef='wait2' targetRef='inclusiveMerge' />    <receiveTask id='wait3' />    <sequenceFlow id='flow15' sourceRef='wait3' targetRef='inclusiveMerge' />    <inclusiveGateway id='inclusiveMerge' />    <sequenceFlow id='flow16' sourceRef='inclusiveMerge' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";

    public void testSimpleSplit() {
        this.deployBpmn2XmlString(SIMPLE_SPLIT);
        this.startAndVerifySimpleSplitProcess("simpleInclusiveSplit", 15, "wait1", "wait2", "wait3");
        this.startAndVerifySimpleSplitProcess("simpleInclusiveSplit", 7, "wait1", "wait2");
        this.startAndVerifySimpleSplitProcess("simpleInclusiveSplit", 3, "wait2");
    }

    public void testSimpleSplitWithDefault() {
        this.deployBpmn2XmlString(SIMPLE_SPLIT_WITH_DEFAULT);
        this.startAndVerifySimpleSplitProcess("simpleInclusiveSplitWithDefault", 15, "wait1", "wait3");
        this.startAndVerifySimpleSplitProcess("simpleInclusiveSplitWithDefault", 7, "wait1");
        this.startAndVerifySimpleSplitProcess("simpleInclusiveSplitWithDefault", 3, "wait2");
    }

    public void testSimpleSplitAndMerge() {
        this.deployBpmn2XmlString(SIMPLE_SPLIT_AND_MERGE);
        ProcessInstance pi = this.startAndVerifySimpleSplitProcess("simpleSplitAndMerge", 17, "wait1", "wait3");
        this.executionService.signalExecutionById(pi.findActiveExecutionIn("wait1").getId());
        this.assertProcessInstanceActive(pi);
        this.executionService.signalExecutionById(pi.findActiveExecutionIn("wait3").getId());
        this.assertProcessInstanceEnded(pi);
    }

    public void testNestedInclusiveSplit() {
        this.deployBpmn2XmlString(NESTED_INCLUSIVE_SPLIT);
        ProcessInstance pi = this.startAndVerifySimpleSplitProcess("nestedInclusiveSplit", 6, "wait1", "wait2");
        pi = this.executionService.signalExecutionById(pi.findActiveExecutionIn("wait1").getId());
        this.assertActivitiesActive(pi.getId(), new String[]{"wait2", "wait4"});
        pi = this.executionService.signalExecutionById(pi.findActiveExecutionIn("wait2").getId());
        pi = this.executionService.signalExecutionById(pi.findActiveExecutionIn("wait4").getId());
        this.assertProcessInstanceEnded(pi);
        pi = this.startAndVerifySimpleSplitProcess("nestedInclusiveSplit", 9, "wait1", "wait2");
        pi = this.executionService.signalExecutionById(pi.findActiveExecutionIn("wait1").getId());
        this.assertActivitiesActive(pi.getId(), new String[]{"wait2", "wait5", "wait6"});
        pi = this.executionService.signalExecutionById(pi.findActiveExecutionIn("wait5").getId());
        pi = this.executionService.signalExecutionById(pi.findActiveExecutionIn("wait6").getId());
        pi = this.executionService.signalExecutionById(pi.findActiveExecutionIn("wait2").getId());
        this.assertProcessInstanceEnded(pi);
    }

    private ProcessInstance startAndVerifySimpleSplitProcess(String processKey, Integer varValue, String ... expectedActivities) {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("var", varValue);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey(processKey, vars);
        CollectionAssertions.assertContainsSameElements((Collection)pi.findActiveActivityNames(), (Object[])expectedActivities);
        return pi;
    }
}

