/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.async;

import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.api.listener.EventListener;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.test.JbpmTestCase;

public class AsyncEventListenerOnEndTest
extends JbpmTestCase {
    public void testAsyncEventListenerAfterWaitState() {
        this.deployJpdlXmlString("<process name='AsyncEventListenerOnEnd'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition name='start-to-end' to='end'>      <event-listener continue='async' class='" + AsyncEventListener.class.getName() + "' />" + "    </transition>" + "  </state>" + "  <end name='end' />" + "</process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AsyncEventListenerOnEnd");
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        AsyncEventListenerOnEndTest.assertEquals((String)"async", (String)processInstance.getState());
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        AsyncEventListenerOnEndTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        AsyncEventListenerOnEndTest.assertEquals((String)"ended", (String)this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult().getState());
    }

    public void testAsyncEventListenerInStartTransaction() {
        this.deployJpdlXmlString("<process name='AsyncEventListenerOnEnd'>  <start name='start'>    <transition name='start-to-end' to='end'>      <event-listener continue='async' class='" + AsyncEventListener.class.getName() + "' />" + "    </transition>" + "  </start>" + "  <end name='end' />" + "</process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AsyncEventListenerOnEnd");
        AsyncEventListenerOnEndTest.assertEquals((String)"async", (String)processInstance.getState());
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        AsyncEventListenerOnEndTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        AsyncEventListenerOnEndTest.assertEquals((String)"ended", (String)this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult().getState());
    }

    public static class AsyncEventListener
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) throws Exception {
        }
    }
}

