/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.process;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.test.JbpmTestCase;

public class DeploymentResourcesTest
extends JbpmTestCase {
    public void testProcessWithNameOnly() {
        byte[] lotOfBytes = this.generateString("a lot of bytes ", 5000).getBytes();
        byte[] otherBytes = this.generateString("other bytes ", 5000).getBytes();
        String deploymentDbiId = this.repositoryService.createDeployment().addResourceFromString("xmlstring.jpdl.xml", "<process name='Insurance claim'>  <start /></process>").addResourceFromInputStream("a lot of attachment", (InputStream)new ByteArrayInputStream(lotOfBytes)).addResourceFromInputStream("other attachment", (InputStream)new ByteArrayInputStream(otherBytes)).deploy();
        this.registerDeployment(deploymentDbiId);
        InputStream stream = this.repositoryService.getResourceAsStream(deploymentDbiId, "a lot of attachment");
        byte[] retrievedLotOfBytes = DeploymentResourcesTest.readBytes(stream);
        DeploymentResourcesTest.assertNotNull((Object)retrievedLotOfBytes);
        DeploymentResourcesTest.assertTrue((boolean)Arrays.equals(lotOfBytes, retrievedLotOfBytes));
        stream = this.repositoryService.getResourceAsStream(deploymentDbiId, "other attachment");
        byte[] retrievedOtherBytes = DeploymentResourcesTest.readBytes(stream);
        DeploymentResourcesTest.assertNotNull((Object)retrievedOtherBytes);
        DeploymentResourcesTest.assertTrue((boolean)Arrays.equals(otherBytes, retrievedOtherBytes));
    }

    public void testLoadProcessAsResource() {
        ClassLoader classLoader = DeploymentResourcesTest.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("org/jbpm/test/process/process.jpdl.xml");
        DeploymentResourcesTest.assertNotNull((Object)inputStream);
        String deploymentId = this.repositoryService.createDeployment().addResourceFromInputStream("process.jpdl.xml", inputStream).deploy();
        this.registerDeployment(deploymentId);
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("Resource").uniqueResult();
        DeploymentResourcesTest.assertNotNull((Object)processDefinition);
    }

    protected String generateString(String base, int multiplier) {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < multiplier; ++i) {
            text.append(base);
        }
        return text.toString();
    }

    public static byte[] readBytes(InputStream inputStream) {
        byte[] bytes = null;
        if (inputStream == null) {
            throw new JbpmException("inputStream is null");
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DeploymentResourcesTest.transfer(inputStream, outputStream);
            bytes = outputStream.toByteArray();
            outputStream.close();
            return bytes;
        }
        catch (IOException e) {
            throw new JbpmException("couldn't read bytes from inputStream", (Throwable)e);
        }
    }

    public static int transfer(InputStream in, OutputStream out) {
        int total = 0;
        byte[] buffer = new byte[4096];
        try {
            int bytesRead = in.read(buffer);
            while (bytesRead != -1) {
                out.write(buffer, 0, bytesRead);
                total += bytesRead;
                bytesRead = in.read(buffer);
            }
            return total;
        }
        catch (IOException e) {
            throw new JbpmException("couldn't write bytes to output stream", (Throwable)e);
        }
    }
}

