/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.process;

import java.util.List;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class RepositoryServiceTest
extends JbpmTestCase {
    public void testProcessWithNameOnly() {
        this.deployJpdlXmlString("<process name='Insurance claim'>  <start /></process>");
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("Insurance_claim").orderDesc("versionProperty.longValue").page(0, 1).uniqueResult();
        RepositoryServiceTest.assertNotNull((Object)processDefinition);
        RepositoryServiceTest.assertEquals((String)"Insurance claim", (String)processDefinition.getName());
        RepositoryServiceTest.assertEquals((String)"Insurance_claim", (String)processDefinition.getKey());
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinition.getVersion());
        RepositoryServiceTest.assertEquals((String)"Insurance_claim-1", (String)processDefinition.getId());
    }

    public void testProcessWithNameAndKey() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start /></process>");
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ICL").orderDesc("versionProperty.longValue").page(0, 1).uniqueResult();
        RepositoryServiceTest.assertNotNull((Object)processDefinition);
        RepositoryServiceTest.assertEquals((String)"Insurance claim", (String)processDefinition.getName());
        RepositoryServiceTest.assertEquals((String)"ICL", (String)processDefinition.getKey());
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinition.getVersion());
        RepositoryServiceTest.assertEquals((String)"ICL-1", (String)processDefinition.getId());
    }

    public void testFindProcessByKey() {
        this.deployJpdlXmlString("<process name='Name with spaces'>  <start /></process>");
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("Name_with_spaces").orderDesc("versionProperty.longValue").page(0, 1).uniqueResult();
        RepositoryServiceTest.assertNotNull((Object)processDefinition);
        RepositoryServiceTest.assertEquals((String)"Name with spaces", (String)processDefinition.getName());
        RepositoryServiceTest.assertEquals((String)"Name_with_spaces", (String)processDefinition.getKey());
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinition.getVersion());
        RepositoryServiceTest.assertEquals((String)"Name_with_spaces-1", (String)processDefinition.getId());
    }

    public void testFindProcessDefinitions() {
        this.deployMultipleVersionsOfProcesses();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("nuclear_fusion").orderDesc("versionProperty.longValue").list();
        RepositoryServiceTest.assertNotNull((Object)processDefinitions);
        RepositoryServiceTest.assertEquals((String)("expected 3 but was " + processDefinitions.size() + ": " + processDefinitions), (int)3, (int)processDefinitions.size());
        RepositoryServiceTest.assertEquals((String)"nuclear fusion", (String)((ProcessDefinition)processDefinitions.get(0)).getName());
        RepositoryServiceTest.assertEquals((int)3, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        RepositoryServiceTest.assertEquals((String)"nuclear fusion", (String)((ProcessDefinition)processDefinitions.get(1)).getName());
        RepositoryServiceTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        RepositoryServiceTest.assertEquals((String)"nuclear fusion", (String)((ProcessDefinition)processDefinitions.get(2)).getName());
        RepositoryServiceTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(2)).getVersion());
    }

    public void testFindLatestProcessDefinition() {
        this.deployMultipleVersionsOfProcesses();
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("nuclear_fusion").orderDesc("versionProperty.longValue").page(0, 1).uniqueResult();
        RepositoryServiceTest.assertNotNull((Object)processDefinition);
        RepositoryServiceTest.assertEquals((int)3, (int)processDefinition.getVersion());
        RepositoryServiceTest.assertEquals((String)"nuclear fusion", (String)processDefinition.getName());
        RepositoryServiceTest.assertEquals((String)"nuclear_fusion", (String)processDefinition.getKey());
    }

    public void testFindProcessDefinitionById() {
        this.deployJpdlXmlString("<process name='given' version='33'>  <start /></process>");
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionId("given-33").uniqueResult();
        RepositoryServiceTest.assertNotNull((Object)processDefinition);
        RepositoryServiceTest.assertEquals((String)"given", (String)processDefinition.getName());
        RepositoryServiceTest.assertEquals((int)33, (int)processDefinition.getVersion());
    }

    public void testDeleteDeployment() {
        String deploymentDbid = this.repositoryService.createDeployment().addResourceFromString("xmlstring.jpdl.xml", "<process name='deleteme' version='33'>  <start /></process>").deploy();
        this.repositoryService.deleteDeployment(deploymentDbid);
        RepositoryServiceTest.assertEquals((int)0, (int)this.repositoryService.createProcessDefinitionQuery().list().size());
    }

    public void testDeleteProcessDefinitionAndInstances() {
        String deploymentDbid = this.repositoryService.createDeployment().addResourceFromString("xmlstring.jpdl.xml", "<process name='deleteme' version='33'>  <start>    <transition to='w' />  </start>  <state name='w' /></process>").deploy();
        this.executionService.startProcessInstanceByKey("deleteme");
        this.executionService.startProcessInstanceByKey("deleteme");
        this.executionService.startProcessInstanceByKey("deleteme");
        this.executionService.startProcessInstanceByKey("deleteme");
        this.repositoryService.deleteDeploymentCascade(deploymentDbid);
        RepositoryServiceTest.assertEquals((int)0, (int)this.repositoryService.createProcessDefinitionQuery().list().size());
        RepositoryServiceTest.assertEquals((int)0, (int)this.executionService.createProcessInstanceQuery().list().size());
    }

    public void testDeleteProcessDefinitionButNotInstances() {
        String deploymentDbid = this.deployJpdlXmlString("<process name='deleteme' version='33'>  <start>    <transition to='w' />  </start>  <state name='w' /></process>");
        this.executionService.startProcessInstanceByKey("deleteme");
        this.executionService.startProcessInstanceByKey("deleteme");
        this.executionService.startProcessInstanceByKey("deleteme");
        this.executionService.startProcessInstanceByKey("deleteme");
        try {
            this.repositoryService.deleteDeployment(deploymentDbid);
            RepositoryServiceTest.fail((String)"expected exception");
        }
        catch (JbpmException e) {
            this.assertTextPresent("cannot delete deployment", e.getMessage());
            this.assertTextPresent("still executions for process(deleteme): ", e.getMessage());
        }
    }

    public void testAutomaticVersioning() {
        this.deployJpdlXmlString("<process name='versionme'>  <start /></process>");
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("versionme").orderDesc("versionProperty.longValue").list();
        RepositoryServiceTest.assertNotNull((Object)processDefinitions);
        RepositoryServiceTest.assertEquals((String)processDefinitions.toString(), (int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinition.getVersion());
        this.deployJpdlXmlString("<process name='versionme'>  <start /></process>");
        processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("versionme").orderDesc("versionProperty.longValue").list();
        RepositoryServiceTest.assertEquals((String)processDefinitions.toString(), (int)2, (int)processDefinitions.size());
        RepositoryServiceTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        RepositoryServiceTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
    }

    public void testUserProvidedVersion() {
        this.deployJpdlXmlString("<process name='takethis' version='234'>  <start /></process>");
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("takethis").list();
        RepositoryServiceTest.assertNotNull((Object)processDefinitions);
        RepositoryServiceTest.assertEquals((String)processDefinitions.toString(), (int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        RepositoryServiceTest.assertEquals((int)234, (int)processDefinition.getVersion());
    }

    public void testDuplicateUserProvidedVersion() {
        this.deployJpdlXmlString("<process name='takethis' version='234'>  <start /></process>");
        try {
            this.deployJpdlXmlString("<process name='takethis' version='234'>  <start /></process>");
            RepositoryServiceTest.fail((String)"expected exception");
        }
        catch (JbpmException e) {
            this.assertTextPresent("process 'takethis-234' already exists", e.getMessage());
        }
    }

    void deployMultipleVersionsOfProcesses() {
        this.deployJpdlXmlString("<process name='nuclear fusion'>  <start /></process>");
        this.deployJpdlXmlString("<process name='ultimate seduction'>  <start /></process>");
        this.deployJpdlXmlString("<process name='ultimate seduction'>  <start /></process>");
        this.deployJpdlXmlString("<process name='ultimate seduction'>  <start /></process>");
        this.deployJpdlXmlString("<process name='ultimate seduction'>  <start /></process>");
        this.deployJpdlXmlString("<process name='publish book'>  <start /></process>");
        this.deployJpdlXmlString("<process name='nuclear fusion'>  <start /></process>");
        this.deployJpdlXmlString("<process name='nuclear fusion'>  <start /></process>");
    }

    public void testMinimalProcess() {
        this.deployJpdlXmlString("<process name='minimal'>  <start>    <transition to='end' />  </start>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("minimal");
        RepositoryServiceTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testMostMinimalProcess() {
        this.deployJpdlXmlString("<process name='minimal'>  <start /></process>");
        ProcessInstance execution = this.executionService.startProcessInstanceByKey("minimal");
        RepositoryServiceTest.assertTrue((boolean)execution.isEnded());
    }

    public void testNonLatinProcessName() {
        String database = System.getProperty("database");
        if (database != null && database.startsWith("oracle")) {
            return;
        }
        this.deployJpdlXmlString("<process name='\u041b\u0435\u0412 \u0422\u0440\u043e\u0446\u043a\u0438\u0439'>  <start/></process>");
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("\u041b\u0435\u0412_\u0422\u0440\u043e\u0446\u043a\u0438\u0439").uniqueResult();
        RepositoryServiceTest.assertEquals((String)"\u041b\u0435\u0412 \u0422\u0440\u043e\u0446\u043a\u0438\u0439", (String)processDefinition.getName());
    }

    public void testNumberProcessName() {
        this.deployJpdlXmlString("<process name='jbpm 2746'>  <start/></process>");
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("jbpm_2746").uniqueResult();
        RepositoryServiceTest.assertEquals((String)"jbpm 2746", (String)processDefinition.getName());
    }
}

