/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.query;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jbpm.api.history.HistoryTask;
import org.jbpm.api.task.Task;
import org.jbpm.pvm.internal.util.Clock;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.QueryAssertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryTaskQueryTest
extends JbpmTestCase {
    private static final Long CLOCK_TEST_TIME = 30000L;

    protected void tearDown() throws Exception {
        Clock.setExplicitTime(null);
        super.tearDown();
    }

    public void testOrderByName() {
        this.testOrderBy("assignee", Arrays.asList("Alex", "Joram", "Tom"));
    }

    public void testOrderByStartTime() {
        this.testOrderByNaturalOrdening("createTime", 3);
    }

    public void testOrderByEndTime() {
        this.testOrderByNaturalOrdening("endTime", 3);
    }

    public void testOrderByDuration() {
        this.testOrderByNaturalOrdening("duration", 3);
    }

    public void testOrderByexecutionId() {
        this.testOrderByNaturalOrdening("executionId", 3);
    }

    public void testOrderByOutcome() {
        this.testOrderByNaturalOrdening("outcome", 3);
    }

    public void testOrderByState() {
        this.testOrderByNaturalOrdening("state", 3);
    }

    private void testOrderBy(String property, List expectedValues) {
        this.testOrderBy(property, expectedValues, null, false);
    }

    private void testOrderByNaturalOrdening(String property, int expectedNrOfResults) {
        this.testOrderBy(property, null, expectedNrOfResults, true);
    }

    public void testCount() {
        List<String> taskIds = this.createTestHistoryTasks();
        HistoryTaskQueryTest.assertEquals((long)3L, (long)this.historyService.createHistoryTaskQuery().count());
        HistoryTaskQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoryTaskQuery().assignee("Tom").count());
        for (String taskid : taskIds) {
            HistoryTaskQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoryTaskQuery().taskId(taskid).count());
        }
        HistoryTaskQueryTest.assertEquals((long)0L, (long)this.historyService.createHistoryTaskQuery().startedBefore(new Date(CLOCK_TEST_TIME - 10000L)).count());
        HistoryTaskQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoryTaskQuery().startedAfter(new Date(CLOCK_TEST_TIME - 10000L)).taskId(taskIds.get(0)).count());
        HistoryTaskQueryTest.assertEquals((long)0L, (long)this.historyService.createHistoryTaskQuery().startedAfter(new Date(CLOCK_TEST_TIME - 10000L)).taskId("-1").count());
    }

    private void testOrderBy(String property, List expectedValues, Integer expectedNrOfResults, boolean naturalOrderCheck) {
        this.createTestHistoryTasks();
        List historyTasksAsc = this.historyService.createHistoryTaskQuery().orderAsc(property).list();
        List historyTasksDesc = this.historyService.createHistoryTaskQuery().orderDesc(property).list();
        if (naturalOrderCheck) {
            QueryAssertions.assertOrderIsNatural(HistoryTask.class, (String)property, (List)historyTasksAsc, (List)historyTasksDesc, (int)expectedNrOfResults);
        } else {
            QueryAssertions.assertOrderOnProperty(HistoryTask.class, (String)property, (List)historyTasksAsc, (List)historyTasksDesc, (List)expectedValues);
        }
    }

    private List<String> createTestHistoryTasks() {
        String processXml1 = "<process name='theProcess1'>  <start>    <transition to='theTask' />  </start>  <task name='theTask' assignee='Alex'>    <transition to='theEnd' />  </task>  <end name='theEnd' /></process>";
        Clock.setExplicitTime((Date)new Date(CLOCK_TEST_TIME));
        String processXml3 = processXml1.replace("1", "2").replace("Alex", "Tom");
        String processXml2 = processXml1.replace("1", "3").replace("Alex", "Joram");
        this.deployJpdlXmlString(processXml1);
        this.deployJpdlXmlString(processXml2);
        this.deployJpdlXmlString(processXml3);
        this.executionService.startProcessInstanceByKey("theProcess1");
        this.executionService.startProcessInstanceByKey("theProcess2");
        this.executionService.startProcessInstanceByKey("theProcess3");
        ArrayList<String> taskIds = new ArrayList<String>();
        taskIds.add(((Task)this.taskService.findPersonalTasks("Alex").get(0)).getId());
        taskIds.add(((Task)this.taskService.findPersonalTasks("Joram").get(0)).getId());
        taskIds.add(((Task)this.taskService.findPersonalTasks("Tom").get(0)).getId());
        for (String taskId : taskIds) {
            this.taskService.completeTask(taskId);
        }
        return taskIds;
    }

    private Date stringToDate(String dateString) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/mm/yyyy");
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException("Couldn't convert " + dateString);
        }
    }
}

