/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.task;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.mail.Message;
import org.jbpm.api.Execution;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.pvm.internal.email.spi.MailProducer;
import org.jbpm.test.JbpmTestCase;

public class NotificationTest
extends JbpmTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.identityService.createUser("johnsmith", "johnsmith", "johnsmith");
    }

    protected void tearDown() throws Exception {
        this.identityService.deleteUser("johnsmith");
        super.tearDown();
    }

    public void testDefault() throws Exception {
        this.deployJpdlXmlString("<process name='X10ExceptionTaskTest'>   <start name='start1' g='93,78,48,48' continue='async'>      <transition name='to Test Task' to='Test Task' g='1,-20'/>   </start>   <end name='end1' g='315,236,48,48'/>   <task name='Test Task' g='178,159,92,52' assignee='johnsmith'>   <notification>    <to users='${task.assignee}'/>    <cc addresses='invalid@email@address'/>    <subject>${task.name}</subject>    <text>      <![CDATA[Hi ${task.assignee},      Task '${task.name}' has been assigned to you.      ${task.description}      Sent by JBoss jBPM      ]]>    </text>   </notification>   <transition name='to end1' to='end1' g='-6,-22'/> </task></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("X10ExceptionTaskTest");
        String processInstanceId = processInstance.getId();
        for (int retries = 0; retries < 3; ++retries) {
            try {
                List jobs = this.managementService.createJobQuery().list();
                Job job = (Job)jobs.get(0);
                this.managementService.executeJob(job.getId());
                break;
            }
            catch (Exception e) {
                System.out.println(e);
                continue;
            }
        }
        List tasks = this.taskService.createTaskQuery().list();
        NotificationTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testSupportExpr() {
        this.deployJpdlXmlString("<process name='NotificationTaskTest' xmlns='http://jbpm.org/4.3/jpdl'>  <start name='start1' g='93,78,48,48'>    <transition name='to Test Task' to='Test Task' g='1,-20'/>  </start>  <end name='end1' g='315,236,48,48'/>  <task name='Test Task' g='178,159,92,52' assignee='johnsmith'>    <notification expr='#{jbpmCustomMailProducer}'>      <field name='templateName'><string value='planning-approval-start-notifcation'/></field>    </notification>    <transition name='to end1' to='end1' g='-6,-22'/>  </task></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("NotificationTaskTest", Collections.singletonMap("jbpmCustomMailProducer", new JbpmCustomMailProducer()));
        String processInstanceId = processInstance.getId();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JbpmCustomMailProducer
    implements MailProducer,
    Serializable {
        private String templateName;

        public Collection<Message> produce(Execution execution) {
            return Collections.EMPTY_SET;
        }
    }
}

