/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.task;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jbpm.api.Execution;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskQueryProcessTest
extends JbpmTestCase {
    public void testTaskQueryProcessInstanceId() {
        this.deployJpdlXmlString("<process name='VacationTrip'>  <start>    <transition to='f' />  </start>  <fork name='f'>    <transition to='select destination' />    <transition to='work hard for the money' />  </fork>  <task name='select destination'         assignee='johndoe'>    <transition to='wait' />  </task>  <task name='work hard for the money'         assignee='johndoe'>    <transition to='wait' />  </task>  <state name='wait'/></process>");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("destination", "Bruges");
        this.executionService.startProcessInstanceByKey("VacationTrip", variables);
        variables = new HashMap();
        variables.put("destination", "Paris");
        ProcessInstance parisProcessInstance = this.executionService.startProcessInstanceByKey("VacationTrip", variables);
        variables = new HashMap();
        variables.put("destination", "Malaga");
        this.executionService.startProcessInstanceByKey("VacationTrip", variables);
        this.deployJpdlXmlString("<process name='BusinessTrip'>  <start>    <transition to='try to get someone else to do it' />  </start>  <task name='try to get someone else to do it'         assignee='johndoe'>    <transition to='wait' />  </task>  <state name='wait'/></process>");
        this.executionService.startProcessInstanceByKey("BusinessTrip");
        this.executionService.startProcessInstanceByKey("BusinessTrip");
        List parisTasks = this.taskService.createTaskQuery().processInstanceId(parisProcessInstance.getId()).list();
        TaskQueryProcessTest.assertEquals((String)("expected 2 elements, but was " + parisTasks.toString()), (int)2, (int)parisTasks.size());
        HashSet<String> expectedTaskNames = new HashSet<String>();
        expectedTaskNames.add("select destination");
        expectedTaskNames.add("work hard for the money");
        HashSet<String> taskNames = new HashSet<String>();
        for (Task task : parisTasks) {
            taskNames.add(task.getName());
            TaskQueryProcessTest.assertEquals((Object)"Paris", (Object)this.taskService.getVariable(task.getId(), "destination"));
        }
        TaskQueryProcessTest.assertEquals(expectedTaskNames, taskNames);
    }

    public void testTaskQueryProcessDefinitionId() {
        this.deployJpdlXmlString("<process name='VacationTrip'>  <start>    <transition to='select destination' />  </start>  <task name='select destination'         assignee='johndoe'>    <transition to='work hard for the money' />  </task>  <task name='work hard for the money'         assignee='johndoe'>    <transition to='wait' />  </task>  <state name='wait'/></process>");
        this.executionService.startProcessInstanceByKey("VacationTrip").getId();
        this.taskService.completeTask(((Task)this.taskService.findPersonalTasks("johndoe").get(0)).getId());
        this.executionService.startProcessInstanceByKey("VacationTrip");
        this.executionService.startProcessInstanceByKey("VacationTrip");
        this.deployJpdlXmlString("<process name='BusinessTrip'>  <start>    <transition to='find customer' />  </start>  <task name='find customer'         assignee='johndoe'>    <transition to='wait' />  </task>  <state name='wait'/></process>");
        this.executionService.startProcessInstanceByKey("BusinessTrip");
        this.executionService.startProcessInstanceByKey("BusinessTrip");
        List tasks = this.taskService.createTaskQuery().processDefinitionId("VacationTrip-1").list();
        TaskQueryProcessTest.assertEquals((String)("expected 3 elements, but was " + tasks.toString()), (int)3, (int)tasks.size());
        int selectDestinationTasks = 0;
        int workHardForTheMoneyTasks = 0;
        for (Task task : tasks) {
            if (task.getName().equals("select destination")) {
                ++selectDestinationTasks;
            }
            if (!task.getName().equals("work hard for the money")) continue;
            ++workHardForTheMoneyTasks;
        }
        TaskQueryProcessTest.assertEquals((int)2, (int)selectDestinationTasks);
        TaskQueryProcessTest.assertEquals((int)1, (int)workHardForTheMoneyTasks);
    }

    public void testTaskQueryActivityName() {
        this.deployJpdlXmlString("<process name='VacationTrip'>  <start>    <transition to='select destination' />  </start>  <task name='select destination'         assignee='johndoe'>    <transition to='work hard for the money' />  </task>  <task name='work hard for the money'         assignee='johndoe'>    <transition to='wait' />  </task>  <state name='wait'/></process>");
        this.executionService.startProcessInstanceByKey("VacationTrip").getId();
        this.taskService.completeTask(((Task)this.taskService.findPersonalTasks("johndoe").get(0)).getId());
        this.executionService.startProcessInstanceByKey("VacationTrip");
        this.executionService.startProcessInstanceByKey("VacationTrip");
        this.deployJpdlXmlString("<process name='BusinessTrip'>  <start>    <transition to='find customer' />  </start>  <task name='find customer'         assignee='johndoe'>    <transition to='wait' />  </task>  <state name='wait'/></process>");
        this.executionService.startProcessInstanceByKey("BusinessTrip");
        this.executionService.startProcessInstanceByKey("BusinessTrip");
        List tasks = this.taskService.createTaskQuery().processDefinitionId("VacationTrip-1").activityName("select destination").list();
        TaskQueryProcessTest.assertEquals((String)("expected 2 elements, but was " + tasks.toString()), (int)2, (int)tasks.size());
        int selectDestinationTasks = 0;
        int workHardForTheMoneyTasks = 0;
        for (Task task : tasks) {
            if (task.getName().equals("select destination")) {
                ++selectDestinationTasks;
            }
            if (!task.getName().equals("work hard for the money")) continue;
            ++workHardForTheMoneyTasks;
        }
        TaskQueryProcessTest.assertEquals((int)2, (int)selectDestinationTasks);
        TaskQueryProcessTest.assertEquals((int)0, (int)workHardForTheMoneyTasks);
    }

    public void testTaskQueryExecutionId() {
        Task task;
        this.deployJpdlXmlString("<process name='VacationTrip'>  <start>    <transition to='f' />  </start>  <fork name='f'>    <transition to='select destination' />    <transition to='work hard for the money' />  </fork>  <task name='select destination'         assignee='johndoe'>    <transition to='join' />  </task>  <task name='work hard for the money'         assignee='johndoe'>    <transition to='join' />  </task>  <join name='join'>    <transition to='end' />  </join>  <end name='end'/></process>");
        ProcessInstance process = this.executionService.startProcessInstanceByKey("VacationTrip");
        Collection executions = process.getExecutions();
        TaskQueryProcessTest.assertEquals((int)2, (int)executions.size());
        for (Execution execution : executions) {
            task = this.taskService.createTaskQuery().executionId(execution.getId()).uniqueResult();
            TaskQueryProcessTest.assertNotNull((Object)task);
            TaskQueryProcessTest.assertEquals((String)execution.getId(), (String)task.getExecutionId());
        }
        process = this.executionService.findProcessInstanceById(process.getId());
        executions = process.getExecutions();
        for (Execution execution : executions) {
            TaskQueryProcessTest.assertFalse((boolean)execution.isEnded());
            task = this.taskService.createTaskQuery().executionId(execution.getId()).uniqueResult();
            this.taskService.completeTask(task.getId());
        }
        process = this.executionService.findProcessInstanceById(process.getId());
        TaskQueryProcessTest.assertNull((Object)process);
    }
}

