/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.usertx;

import java.util.List;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.TaskService;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.api.listener.EventListener;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class UserTransactionTest
extends JbpmTestCase {
    public void testUserTransaction() {
        this.deployJpdlXmlString("<process name='UserTransaction'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />  </state>  <state name='b' /></process>");
        this.processEngine.execute((Command)new Command<Void>(){
            private static final long serialVersionUID = 1L;

            public Void execute(Environment environment) throws Exception {
                TaskService taskService = (TaskService)environment.get(TaskService.class);
                Task task = taskService.newTask();
                taskService.saveTask(task);
                ExecutionService executionService = (ExecutionService)environment.get(ExecutionService.class);
                executionService.startProcessInstanceByKey("UserTransaction");
                return null;
            }
        });
        List taskList = this.taskService.createTaskQuery().list();
        UserTransactionTest.assertEquals((int)1, (int)taskList.size());
        List processInstanceList = this.executionService.createProcessInstanceQuery().list();
        UserTransactionTest.assertEquals((int)1, (int)processInstanceList.size());
        ProcessInstance processInstance = (ProcessInstance)processInstanceList.get(0);
        UserTransactionTest.assertTrue((boolean)processInstance.isActive("a"));
        this.processEngine.execute((Command)new TaskSignalCmd(processInstance.getId()));
        taskList = this.taskService.createTaskQuery().list();
        UserTransactionTest.assertEquals((int)2, (int)taskList.size());
        processInstanceList = this.executionService.createProcessInstanceQuery().list();
        UserTransactionTest.assertEquals((int)1, (int)processInstanceList.size());
        processInstance = (ProcessInstance)processInstanceList.get(0);
        UserTransactionTest.assertTrue((boolean)processInstance.isActive("b"));
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.deleteTaskCascade(task.getId());
        }
    }

    public void testUserTransactionWithProcessException() {
        this.deployJpdlXmlString("<process name='UserTransactionWithProcessException'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b'>      <event-listener class='" + Thrower.class.getName() + "' />" + "    </transition>" + "  </state>" + "  <state name='b' />" + "</process>");
        this.processEngine.execute((Command)new Command<Void>(){
            private static final long serialVersionUID = 1L;

            public Void execute(Environment environment) throws Exception {
                TaskService taskService = (TaskService)environment.get(TaskService.class);
                Task task = taskService.newTask();
                taskService.saveTask(task);
                ExecutionService executionService = (ExecutionService)environment.get(ExecutionService.class);
                executionService.startProcessInstanceByKey("UserTransactionWithProcessException");
                return null;
            }
        });
        List taskList = this.taskService.createTaskQuery().list();
        UserTransactionTest.assertEquals((int)1, (int)taskList.size());
        List processInstanceList = this.executionService.createProcessInstanceQuery().list();
        UserTransactionTest.assertEquals((int)1, (int)processInstanceList.size());
        ProcessInstance processInstance = (ProcessInstance)processInstanceList.get(0);
        UserTransactionTest.assertTrue((boolean)processInstance.isActive("a"));
        try {
            this.processEngine.execute((Command)new TaskSignalCmd(processInstance.getId()));
            UserTransactionTest.fail((String)"expected exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        taskList = this.taskService.createTaskQuery().list();
        UserTransactionTest.assertEquals((int)1, (int)taskList.size());
        processInstanceList = this.executionService.createProcessInstanceQuery().list();
        UserTransactionTest.assertEquals((int)1, (int)processInstanceList.size());
        processInstance = (ProcessInstance)processInstanceList.get(0);
        UserTransactionTest.assertTrue((boolean)processInstance.isActive("a"));
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.deleteTaskCascade(task.getId());
        }
    }

    public void testUserTransactionWithUserException() {
        this.deployJpdlXmlString("<process name='UserTransaction'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />  </state>  <state name='b' /></process>");
        this.processEngine.execute((Command)new Command<Void>(){
            private static final long serialVersionUID = 1L;

            public Void execute(Environment environment) throws Exception {
                TaskService taskService = (TaskService)environment.get(TaskService.class);
                Task task = taskService.newTask();
                taskService.saveTask(task);
                ExecutionService executionService = (ExecutionService)environment.get(ExecutionService.class);
                executionService.startProcessInstanceByKey("UserTransaction");
                return null;
            }
        });
        List taskList = this.taskService.createTaskQuery().list();
        UserTransactionTest.assertEquals((int)1, (int)taskList.size());
        List processInstanceList = this.executionService.createProcessInstanceQuery().list();
        UserTransactionTest.assertEquals((int)1, (int)processInstanceList.size());
        ProcessInstance processInstance = (ProcessInstance)processInstanceList.get(0);
        UserTransactionTest.assertTrue((boolean)processInstance.isActive("a"));
        try {
            this.processEngine.execute((Command)new SignalWithUserExceptionCmd(processInstance.getId()));
            UserTransactionTest.fail((String)"expected exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        taskList = this.taskService.createTaskQuery().list();
        UserTransactionTest.assertEquals((int)1, (int)taskList.size());
        processInstanceList = this.executionService.createProcessInstanceQuery().list();
        UserTransactionTest.assertEquals((int)1, (int)processInstanceList.size());
        processInstance = (ProcessInstance)processInstanceList.get(0);
        UserTransactionTest.assertTrue((boolean)processInstance.isActive("a"));
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.deleteTaskCascade(task.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SignalWithUserExceptionCmd
    implements Command<Void> {
        private static final long serialVersionUID = 1L;
        String executionId;

        public SignalWithUserExceptionCmd(String executionId) {
            this.executionId = executionId;
        }

        public Void execute(Environment environment) throws Exception {
            TaskService taskService = (TaskService)environment.get(TaskService.class);
            Task task = taskService.newTask();
            taskService.saveTask(task);
            ExecutionService executionService = (ExecutionService)environment.get(ExecutionService.class);
            executionService.signalExecutionById(this.executionId);
            throw new RuntimeException("regards from inside user command");
        }
    }

    public static class Thrower
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) throws Exception {
            throw new Exception("regards from inside process execution");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskSignalCmd
    implements Command<Void> {
        private static final long serialVersionUID = 1L;
        String executionId;

        public TaskSignalCmd(String executionId) {
            this.executionId = executionId;
        }

        public Void execute(Environment environment) throws Exception {
            TaskService taskService = (TaskService)environment.get(TaskService.class);
            Task task = taskService.newTask();
            taskService.saveTask(task);
            ExecutionService executionService = (ExecutionService)environment.get(ExecutionService.class);
            executionService.signalExecutionById(this.executionId);
            return null;
        }
    }
}

