/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonDefaultWriter;
import com.tencent.tendon.convert.json.JsonFactory;
import com.tencent.tendon.convert.json.JsonPool;
import com.tencent.tendon.convert.json.JsonPrinters;
import com.tencent.tendon.convert.json.JsonReadable;
import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonToken;
import com.tencent.tendon.convert.json.JsonTokens;
import com.tencent.tendon.convert.json.streams.JsonAbstractReader;
import com.tencent.tendon.convert.json.streams.JsonAbstractWriter;
import com.tencent.tendon.convert.json.streams.JsonAppendWriter;
import com.tencent.tendon.convert.json.streams.JsonCharBufferReader;
import com.tencent.tendon.convert.json.streams.JsonCharBufferWriter;
import com.tencent.tendon.convert.json.streams.JsonReadableReader;
import com.tencent.tendon.convert.json.streams.JsonStreamReader;
import com.tencent.tendon.convert.json.streams.JsonStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonConvert {
    private JsonConvert() {
    }

    public static String convertTo(Object object) {
        if (object == null) {
            return "null";
        }
        JsonDefaultWriter jsonDefaultWriter = JsonPool.pollJsonDefaultWriter();
        JsonPrinters.convertObjectTo(jsonDefaultWriter, object);
        String string = jsonDefaultWriter.toString();
        JsonPool.offer(jsonDefaultWriter);
        return string;
    }

    public static byte[] convertToUTF8Bytes(Object object) {
        if (object == null) {
            return new byte[]{110, 117, 108, 108};
        }
        JsonDefaultWriter jsonDefaultWriter = JsonPool.pollJsonDefaultWriter();
        JsonPrinters.convertObjectTo(jsonDefaultWriter, object);
        byte[] byArray = jsonDefaultWriter.toUTF8Bytes();
        JsonPool.offer(jsonDefaultWriter);
        return byArray;
    }

    public static void convertTo(Object object, Appendable appendable) {
        if (appendable == null) {
            throw new NullPointerException();
        }
        JsonAbstractWriter jsonAbstractWriter = null;
        jsonAbstractWriter = appendable instanceof Writer ? new JsonStreamWriter((Writer)appendable) : (appendable instanceof CharBuffer ? new JsonCharBufferWriter((CharBuffer)appendable) : new JsonAppendWriter(appendable));
        if (object == null) {
            jsonAbstractWriter.writeNull();
        } else {
            JsonPrinters.convertObjectTo(jsonAbstractWriter, object);
        }
        jsonAbstractWriter.release();
    }

    public static <T> T convertFrom(String string, Class<T> clazz) {
        return JsonConvert.convertFrom(JsonPool.pollJsonDefaultReader(string), clazz);
    }

    public static <T> T convertFrom(char[] cArray, Class<T> clazz) {
        return JsonConvert.convertFrom(JsonPool.pollJsonDefaultReader(cArray), clazz);
    }

    public static <T> T convertFrom(char[] cArray, int n, int n2, Class<T> clazz) {
        return JsonConvert.convertFrom(JsonPool.pollJsonDefaultReader(cArray, n, n2), clazz);
    }

    public static <T> T convertFrom(byte[] byArray, Class<T> clazz) {
        return JsonConvert.convertFrom(byArray, 0, byArray.length, clazz);
    }

    public static <T> T convertFrom(byte[] byArray, int n, int n2, Class<T> clazz) {
        return JsonConvert.convertFrom(JsonConvert.utf8Decode(byArray, n, n2), clazz);
    }

    public static <T> T convertFrom(Readable readable, Class<T> clazz) {
        JsonAbstractReader jsonAbstractReader = null;
        jsonAbstractReader = readable instanceof Reader ? new JsonStreamReader((Reader)readable) : (readable instanceof CharBuffer ? new JsonCharBufferReader((CharBuffer)readable) : new JsonReadableReader(readable));
        return JsonConvert.convertFrom(jsonAbstractReader, clazz);
    }

    public static <T> T[] convertArrayFrom(String string, Class<T> clazz) {
        return JsonConvert.convertArrayFrom(JsonPool.pollJsonDefaultReader(string), clazz);
    }

    public static <T> T[] convertArrayFrom(char[] cArray, Class<T> clazz) {
        return JsonConvert.convertArrayFrom(JsonPool.pollJsonDefaultReader(cArray), clazz);
    }

    public static <T> T[] convertArrayFrom(char[] cArray, int n, int n2, Class<T> clazz) {
        return JsonConvert.convertArrayFrom(JsonPool.pollJsonDefaultReader(cArray, n, n2), clazz);
    }

    public static <T> T[] convertArrayFrom(byte[] byArray, Class<T> clazz) {
        return JsonConvert.convertArrayFrom(JsonConvert.utf8Decode(byArray, 0, byArray.length), clazz);
    }

    public static <T> T[] convertArrayFrom(byte[] byArray, int n, int n2, Class<T> clazz) {
        return JsonConvert.convertArrayFrom(JsonConvert.utf8Decode(byArray, n, n2), clazz);
    }

    public static <T> T[] convertArrayFrom(Readable readable, Class<T> clazz) {
        JsonAbstractReader jsonAbstractReader = null;
        jsonAbstractReader = readable instanceof Reader ? new JsonStreamReader((Reader)readable) : (readable instanceof CharBuffer ? new JsonCharBufferReader((CharBuffer)readable) : new JsonReadableReader(readable));
        return JsonConvert.convertArrayFrom(jsonAbstractReader, clazz);
    }

    private static <T> T convertFrom(JsonReader jsonReader, Class<T> clazz) {
        JsonReadable<T> jsonReadable = JsonFactory.findJsonToken(clazz);
        if (jsonReadable == null) {
            jsonReadable = JsonFactory.findListener(clazz);
        }
        if (jsonReadable == null) {
            if (clazz.isArray()) {
                return (T)JsonConvert.convertArrayFrom(jsonReader, clazz.getComponentType());
            }
            jsonReadable = JsonFactory.loadJsonToken(clazz);
        }
        T t = jsonReadable.convertFrom(jsonReader);
        jsonReader.close();
        return t;
    }

    private static <T> T[] convertArrayFrom(JsonReader jsonReader, Class<T> clazz) {
        JsonReadable<T> jsonReadable = JsonFactory.findListener(clazz);
        if (jsonReadable == null) {
            jsonReadable = JsonFactory.loadJsonToken(clazz);
        }
        JsonToken<T[]> jsonToken = JsonTokens.createJsonArrayToken(jsonReadable);
        T[] TArray = jsonToken.convertFrom(jsonReader);
        jsonReader.close();
        return TArray;
    }

    private static char[] utf8Decode(byte[] byArray, int n, int n2) {
        byte by;
        int n3 = n2;
        byte[] byArray2 = byArray;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            by = byArray2[i];
            if (by >> 5 == -2) {
                --n3;
                continue;
            }
            if (by >> 4 != -2) continue;
            n3 -= 2;
        }
        char[] cArray = new char[n3];
        n3 = 0;
        int n5 = n;
        while (n5 < n4) {
            if ((by = byArray2[n5++]) >= 0) {
                cArray[n3++] = (char)by;
                continue;
            }
            if (by >> 5 == -2) {
                cArray[n3++] = (char)(by << 6 ^ byArray2[n5++] ^ 0xF80);
                continue;
            }
            if (by >> 4 != -2) continue;
            cArray[n3++] = (char)(by << 12 ^ byArray2[n5++] << 6 ^ (byArray2[n5++] ^ 0xFFFE1F80));
        }
        return cArray;
    }

    static {
        JsonFactory.initializate();
    }
}

