/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonCreatable;
import com.tencent.tendon.convert.json.JsonException;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonCreator<T>
implements JsonCreatable<T> {
    protected final Class<T> type;
    protected final Constructor<T> constructor;

    protected JsonCreator(Class<? extends T> clazz) {
        this.type = clazz;
        Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
        for (Constructor<?> constructor2 : clazz.getConstructors()) {
            if (constructor2.getParameterTypes().length != 0) continue;
            constructor2.setAccessible(true);
            constructor = constructor2;
            break;
        }
        this.constructor = constructor;
    }

    @Override
    public T create() {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new JsonException("can not new a instance for " + this.type, exception);
        }
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }
}

