/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonListener;
import com.tencent.tendon.convert.json.JsonWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonEnumListener<E extends Enum>
extends JsonListener<E> {
    private final Class<E> type;
    private final Entity<E>[] values;

    public JsonEnumListener(Class<E> clazz) {
        this.type = clazz;
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        this.values = new Entity[enumArray.length];
        for (int i = 0; i < this.values.length; ++i) {
            Enum enum_ = enumArray[i];
            this.values[i] = new Entity<Enum>(enum_.name().toCharArray(), enum_);
        }
    }

    @Override
    public void convertTo(JsonWriter jsonWriter, E e) {
        if (e == null) {
            jsonWriter.writeNull();
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                if (e != this.values[i].value) continue;
                jsonWriter.write(this.values[i].quotekey);
                return;
            }
            jsonWriter.writeNull();
        }
    }

    @Override
    public E convertFrom(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return null;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!JsonEnumListener.equals(cArray, n, n2, this.values[i].key)) continue;
            return (E)((Enum)this.values[i].value);
        }
        return null;
    }

    private static boolean equals(char[] cArray, int n, int n2, char[] cArray2) {
        if (cArray2.length != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (cArray[i + n] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Class<E> getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Entity<E> {
        public final char[] key;
        public final char[] quotekey;
        public final E value;

        public Entity(char[] cArray, E e) {
            this.key = cArray;
            this.value = e;
            char[] cArray2 = new char[cArray.length + 2];
            cArray2[0] = 34;
            System.arraycopy(cArray, 0, cArray2, 1, cArray.length);
            cArray2[cArray.length + 1] = 34;
            this.quotekey = cArray2;
        }
    }
}

