/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonCreatable;
import com.tencent.tendon.convert.json.JsonCreator;
import com.tencent.tendon.convert.json.JsonDeCompiler;
import com.tencent.tendon.convert.json.JsonDefaultToken;
import com.tencent.tendon.convert.json.JsonEnCompiler;
import com.tencent.tendon.convert.json.JsonEnumListener;
import com.tencent.tendon.convert.json.JsonIdentityMap;
import com.tencent.tendon.convert.json.JsonListener;
import com.tencent.tendon.convert.json.JsonObjectPrinter;
import com.tencent.tendon.convert.json.JsonObjectToken;
import com.tencent.tendon.convert.json.JsonPrinter;
import com.tencent.tendon.convert.json.JsonToken;
import com.tencent.tendon.convert.json.creators.JsonArrayListCreator;
import com.tencent.tendon.convert.json.creators.JsonConcurrentHashMapCreator;
import com.tencent.tendon.convert.json.creators.JsonHashMapCreator;
import com.tencent.tendon.convert.json.creators.JsonHashSetCreator;
import com.tencent.tendon.convert.json.creators.JsonLinkedListCreator;
import com.tencent.tendon.convert.json.creators.JsonPropertiesCreator;
import com.tencent.tendon.convert.json.listeners.JsonBigIntegerListener;
import com.tencent.tendon.convert.json.listeners.JsonBoolListener;
import com.tencent.tendon.convert.json.listeners.JsonByteListener;
import com.tencent.tendon.convert.json.listeners.JsonBytesListener;
import com.tencent.tendon.convert.json.listeners.JsonCharListener;
import com.tencent.tendon.convert.json.listeners.JsonDoubleListener;
import com.tencent.tendon.convert.json.listeners.JsonFloatListener;
import com.tencent.tendon.convert.json.listeners.JsonIntListener;
import com.tencent.tendon.convert.json.listeners.JsonLongListener;
import com.tencent.tendon.convert.json.listeners.JsonShortListener;
import com.tencent.tendon.convert.json.listeners.JsonStringListener;
import com.tencent.tendon.convert.json.printers.JsonBoolArrayPrinter;
import com.tencent.tendon.convert.json.printers.JsonByteArrayPrinter;
import com.tencent.tendon.convert.json.printers.JsonCharArrayPrinter;
import com.tencent.tendon.convert.json.printers.JsonDoubleArrayPrinter;
import com.tencent.tendon.convert.json.printers.JsonFloatArrayPrinter;
import com.tencent.tendon.convert.json.printers.JsonIntArrayPrinter;
import com.tencent.tendon.convert.json.printers.JsonLongArrayPrinter;
import com.tencent.tendon.convert.json.printers.JsonShortArrayPrinter;
import com.tencent.tendon.convert.json.printers.JsonStringArrayPrinter;
import com.tencent.tendon.convert.json.tokens.JsonBoolArrayToken;
import com.tencent.tendon.convert.json.tokens.JsonByteArrayToken;
import com.tencent.tendon.convert.json.tokens.JsonCharArrayToken;
import com.tencent.tendon.convert.json.tokens.JsonDoubleArrayToken;
import com.tencent.tendon.convert.json.tokens.JsonFloatArrayToken;
import com.tencent.tendon.convert.json.tokens.JsonIntArrayToken;
import com.tencent.tendon.convert.json.tokens.JsonLongArrayToken;
import com.tencent.tendon.convert.json.tokens.JsonShortArrayToken;
import com.tencent.tendon.convert.json.tokens.JsonStringArrayToken;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonFactory {
    private static final JsonIdentityMap<Class, JsonListener> listeners = new JsonIdentityMap();
    private static final JsonIdentityMap<Class, JsonPrinter> printers = new JsonIdentityMap();
    private static final JsonIdentityMap<Class, JsonToken> tokenmap = new JsonIdentityMap();
    private static final JsonIdentityMap<Class, JsonCreatable> creatormap = new JsonIdentityMap();

    private JsonFactory() {
    }

    public static <E> void register(Class<E> clazz, JsonListener<E> jsonListener) {
        listeners.put(clazz, jsonListener);
    }

    public static <E> void register(Class<E> clazz, JsonObjectPrinter<E> jsonObjectPrinter) {
        printers.put(clazz, jsonObjectPrinter);
    }

    public static <E> void register(Class<E> clazz, JsonCreatable<? extends E> jsonCreatable) {
        creatormap.put(clazz, jsonCreatable);
    }

    public static <E> void register(Class<E> clazz, JsonObjectToken<E> jsonObjectToken) {
        tokenmap.put(clazz, jsonObjectToken);
    }

    public static <E> JsonListener<E> findListener(Class<E> clazz) {
        JsonEnumListener<E> jsonEnumListener = listeners.get(clazz);
        if (jsonEnumListener == null && clazz.isEnum()) {
            jsonEnumListener = new JsonEnumListener<E>(clazz);
            listeners.put(clazz, jsonEnumListener);
        }
        return jsonEnumListener;
    }

    public static <E> JsonToken<E> findJsonToken(Class<E> clazz) {
        return tokenmap.get(clazz);
    }

    public static <E> JsonPrinter<E> findPrinter(Class<E> clazz) {
        return printers.get(clazz);
    }

    public static <E> JsonPrinter<E> loadJsonPrinter(Class<E> clazz) {
        JsonPrinter jsonPrinter = printers.get(clazz);
        if (jsonPrinter == null) {
            JsonEnCompiler.compileJsonDefaultPrinter(clazz);
            jsonPrinter = printers.get(clazz);
        }
        return jsonPrinter;
    }

    public static <E> JsonToken<E> loadJsonToken(Class<E> clazz) {
        JsonToken jsonToken = tokenmap.get(clazz);
        if (jsonToken == null) {
            JsonDeCompiler.compileJsonDefaultToken(clazz);
            jsonToken = tokenmap.get(clazz);
        }
        return jsonToken;
    }

    public static <T> JsonCreatable<T> loadJsonCreator(Class<T> clazz) {
        JsonCreator<T> jsonCreator = creatormap.get(clazz);
        if (jsonCreator == null) {
            jsonCreator = new JsonCreator<T>(clazz);
            creatormap.put(clazz, jsonCreator);
        }
        return jsonCreator;
    }

    static void initializate() {
        tokenmap.put(boolean[].class, JsonBoolArrayToken.instance);
        tokenmap.put(byte[].class, JsonByteArrayToken.instance);
        tokenmap.put(short[].class, JsonShortArrayToken.instance);
        tokenmap.put(char[].class, JsonCharArrayToken.instance);
        tokenmap.put(int[].class, JsonIntArrayToken.instance);
        tokenmap.put(float[].class, JsonFloatArrayToken.instance);
        tokenmap.put(long[].class, JsonLongArrayToken.instance);
        tokenmap.put(double[].class, JsonDoubleArrayToken.instance);
        tokenmap.put(String[].class, JsonStringArrayToken.instance);
        printers.put(boolean[].class, JsonBoolArrayPrinter.instance);
        printers.put(byte[].class, JsonByteArrayPrinter.instance);
        printers.put(short[].class, JsonShortArrayPrinter.instance);
        printers.put(char[].class, JsonCharArrayPrinter.instance);
        printers.put(int[].class, JsonIntArrayPrinter.instance);
        printers.put(float[].class, JsonFloatArrayPrinter.instance);
        printers.put(long[].class, JsonLongArrayPrinter.instance);
        printers.put(double[].class, JsonDoubleArrayPrinter.instance);
        printers.put(String[].class, JsonStringArrayPrinter.instance);
    }

    static void register0(Class clazz, JsonDefaultToken jsonDefaultToken) {
        tokenmap.put(clazz, jsonDefaultToken);
    }

    static void register0(Class clazz, JsonPrinter jsonPrinter) {
        printers.put(clazz, jsonPrinter);
    }

    static {
        listeners.put(String.class, JsonStringListener.instance);
        listeners.put(BigInteger.class, JsonBigIntegerListener.instance);
        listeners.put(Boolean.class, JsonBoolListener.instance);
        listeners.put(Byte.class, JsonByteListener.instance);
        listeners.put(Short.class, JsonShortListener.instance);
        listeners.put(Character.class, JsonCharListener.instance);
        listeners.put(Integer.class, JsonIntListener.instance);
        listeners.put(Float.class, JsonFloatListener.instance);
        listeners.put(Long.class, JsonLongListener.instance);
        listeners.put(Double.class, JsonDoubleListener.instance);
        listeners.put(Boolean.TYPE, listeners.get(Boolean.class));
        listeners.put(Byte.TYPE, listeners.get(Byte.class));
        listeners.put(Short.TYPE, listeners.get(Short.class));
        listeners.put(Character.TYPE, listeners.get(Character.class));
        listeners.put(Integer.TYPE, listeners.get(Integer.class));
        listeners.put(Float.TYPE, listeners.get(Float.class));
        listeners.put(Long.TYPE, listeners.get(Long.class));
        listeners.put(Double.TYPE, listeners.get(Double.class));
        listeners.put(byte[].class, JsonBytesListener.instance);
        creatormap.put(ArrayList.class, JsonArrayListCreator.instance);
        creatormap.put(HashSet.class, JsonHashSetCreator.instance);
        creatormap.put(LinkedList.class, JsonLinkedListCreator.instance);
        creatormap.put(HashMap.class, JsonHashMapCreator.instance);
        creatormap.put(Properties.class, JsonPropertiesCreator.instance);
        creatormap.put(ConcurrentHashMap.class, JsonConcurrentHashMapCreator.instance);
    }
}

