/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonArrayList;
import com.tencent.tendon.convert.json.JsonCharArray;
import com.tencent.tendon.convert.json.JsonDefaultReader;
import com.tencent.tendon.convert.json.JsonDefaultWriter;
import com.tencent.tendon.convert.json.JsonStack;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public final class JsonPool {
    private static final int MAX = Math.max(Runtime.getRuntime().availableProcessors(), 2) * 2;
    private static final Queue<JsonArrayList> jsonArrayListQueue = new ArrayBlockingQueue<JsonArrayList>(MAX);
    private static final Queue<JsonDefaultWriter> jsonWriterQueue = new ArrayBlockingQueue<JsonDefaultWriter>(MAX);
    private static final Queue<JsonDefaultReader> jsonReaderQueue = new ArrayBlockingQueue<JsonDefaultReader>(MAX);
    private static final Queue<JsonCharArray> charArrayQueue = new ArrayBlockingQueue<JsonCharArray>(MAX);
    private static final Queue<JsonStack> jsonStackQueue = new ArrayBlockingQueue<JsonStack>(MAX);

    private JsonPool() {
    }

    public static JsonArrayList pollJsonArrayList() {
        JsonArrayList jsonArrayList = jsonArrayListQueue.poll();
        if (jsonArrayList == null) {
            jsonArrayList = new JsonArrayList();
        } else {
            jsonArrayList.prepare();
        }
        return jsonArrayList;
    }

    public static void offer(JsonArrayList jsonArrayList) {
        if (jsonArrayList != null) {
            jsonArrayList.release();
            jsonArrayListQueue.offer(jsonArrayList);
        }
    }

    public static JsonDefaultWriter pollJsonDefaultWriter() {
        JsonDefaultWriter jsonDefaultWriter = jsonWriterQueue.poll();
        if (jsonDefaultWriter == null) {
            jsonDefaultWriter = new JsonDefaultWriter();
        } else {
            jsonDefaultWriter.prepare();
        }
        return jsonDefaultWriter;
    }

    public static void offer(JsonDefaultWriter jsonDefaultWriter) {
        if (jsonDefaultWriter != null) {
            jsonDefaultWriter.release();
            jsonWriterQueue.offer(jsonDefaultWriter);
        }
    }

    public static JsonDefaultReader pollJsonDefaultReader(String string) {
        JsonDefaultReader jsonDefaultReader = jsonReaderQueue.poll();
        if (jsonDefaultReader == null) {
            jsonDefaultReader = new JsonDefaultReader(string);
        } else {
            jsonDefaultReader.prepare();
            jsonDefaultReader.text(string.toCharArray());
        }
        return jsonDefaultReader;
    }

    public static JsonDefaultReader pollJsonDefaultReader(char[] cArray) {
        JsonDefaultReader jsonDefaultReader = jsonReaderQueue.poll();
        if (jsonDefaultReader == null) {
            jsonDefaultReader = new JsonDefaultReader(cArray);
        } else {
            jsonDefaultReader.prepare();
            jsonDefaultReader.text(cArray);
        }
        return jsonDefaultReader;
    }

    public static JsonDefaultReader pollJsonDefaultReader(char[] cArray, int n, int n2) {
        JsonDefaultReader jsonDefaultReader = jsonReaderQueue.poll();
        if (jsonDefaultReader == null) {
            jsonDefaultReader = new JsonDefaultReader(cArray, n, n2);
        } else {
            jsonDefaultReader.prepare();
            jsonDefaultReader.text(cArray, n, n2);
        }
        return jsonDefaultReader;
    }

    public static void offer(JsonDefaultReader jsonDefaultReader) {
        if (jsonDefaultReader != null) {
            jsonDefaultReader.release();
            jsonReaderQueue.offer(jsonDefaultReader);
        }
    }

    public static JsonCharArray pollJsonCharArray() {
        JsonCharArray jsonCharArray = charArrayQueue.poll();
        if (jsonCharArray == null) {
            jsonCharArray = new JsonCharArray();
        } else {
            jsonCharArray.prepare();
        }
        return jsonCharArray;
    }

    public static void offer(JsonCharArray jsonCharArray) {
        if (jsonCharArray != null) {
            jsonCharArray.release();
            charArrayQueue.offer(jsonCharArray);
        }
    }

    public static JsonStack pollJsonStack() {
        JsonStack jsonStack = jsonStackQueue.poll();
        if (jsonStack == null) {
            jsonStack = new JsonStack();
        } else {
            jsonStack.prepare();
        }
        return jsonStack;
    }

    public static void offer(JsonStack jsonStack) {
        if (jsonStack != null) {
            jsonStack.release();
            jsonStackQueue.offer(jsonStack);
        }
    }
}

