/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonPoolable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonStack
implements JsonPoolable {
    private transient Object[] data = new Object[16];
    private int size;

    private void expand() {
        Object[] objectArray = new Object[this.data.length + 8];
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        this.data = objectArray;
    }

    public final void offer(Object object) {
        if (this.size == this.data.length) {
            this.expand();
        }
        this.data[this.size] = object;
        ++this.size;
    }

    public final int indexOf(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != object) continue;
            return i;
        }
        return -1;
    }

    public Object get(int n) {
        return this.data[n];
    }

    public <T> T stackOf(int n) {
        int n2 = this.size - n;
        if (n2 < 0) {
            return null;
        }
        return (T)this.data[n2];
    }

    public final void poll() {
        this.data[--this.size] = null;
    }

    public Object[] toArray() {
        if (this.size == this.data.length) {
            return this.data;
        }
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void release() {
        this.size = 0;
        int n = this.data.length;
        if (n > 16) {
            this.data = new Object[16];
        } else {
            for (int i = 0; i < n; ++i) {
                this.data[i] = null;
            }
        }
    }
}

