/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonArrayList;
import com.tencent.tendon.convert.json.JsonCreatable;
import com.tencent.tendon.convert.json.JsonException;
import com.tencent.tendon.convert.json.JsonFactory;
import com.tencent.tendon.convert.json.JsonListener;
import com.tencent.tendon.convert.json.JsonPool;
import com.tencent.tendon.convert.json.JsonReadable;
import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonReferToken;
import com.tencent.tendon.convert.json.JsonToken;
import com.tencent.tendon.convert.json.listeners.JsonStringListener;
import com.tencent.tendon.convert.json.tokens.JsonStringArrayToken;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonTokens {
    private JsonTokens() {
    }

    public static <T> JsonToken<T[]> createJsonArrayToken(JsonReadable<T> jsonReadable) {
        if (jsonReadable.getClass() == JsonStringListener.class) {
            JsonStringArrayToken jsonStringArrayToken = new JsonStringArrayToken();
            return jsonStringArrayToken;
        }
        if (JsonTokens.isJsonSimpleable(jsonReadable)) {
            return new JsonSimpleArrayToken<T>(jsonReadable);
        }
        return new JsonObjectArrayToken<T>(jsonReadable);
    }

    public static <T> JsonToken<Collection<T>> createJsonCollectionToken(Class<Collection<T>> clazz, JsonReadable<T> jsonReadable) {
        if (JsonTokens.isJsonSimpleable(jsonReadable)) {
            return new JsonSimpleCollectionToken<T>(clazz, jsonReadable);
        }
        return new JsonObjectCollectionToken<T>(clazz, jsonReadable);
    }

    public static <K, V> JsonToken<Map<K, V>> createJsonMapToken(Class<Map<K, V>> clazz, JsonListener<K> jsonListener, JsonReadable<V> jsonReadable) {
        if (JsonTokens.isJsonSimpleable(jsonReadable)) {
            return new JsonSimpleMapToken<K, V>(clazz, jsonListener, jsonReadable);
        }
        return new JsonObjectMapToken<K, V>(clazz, jsonListener, jsonReadable);
    }

    private static boolean isJsonSimpleable(JsonReadable jsonReadable) {
        return jsonReadable != null && jsonReadable.isSimpled();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonSimpleArrayToken<T>
    extends JsonToken<T[]> {
        private final Class<T[]> type;
        private final JsonReadable<T> token;

        public JsonSimpleArrayToken(JsonReadable<T> jsonReadable) {
            this.token = jsonReadable;
            if (!JsonTokens.isJsonSimpleable(jsonReadable)) {
                throw new JsonException(jsonReadable + " is not a JsonSimpleable JsonReadable");
            }
            this.type = Array.newInstance(jsonReadable.getType(), 0).getClass();
        }

        @Override
        public T[] convertFrom(JsonReader jsonReader) {
            jsonReader.checkArray();
            JsonArrayList jsonArrayList = JsonPool.pollJsonArrayList();
            JsonReadable<T> jsonReadable = this.token;
            while (jsonReader.hasNext()) {
                jsonArrayList.add(jsonReadable.convertFrom(jsonReader));
            }
            T[] TArray = jsonArrayList.toArray(this.token.getType());
            JsonPool.offer(jsonArrayList);
            return TArray;
        }

        @Override
        public Class<T[]> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonObjectArrayToken<T>
    extends JsonToken<T[]> {
        private final Class<T[]> type;
        private final JsonReadable<T> token;

        public JsonObjectArrayToken(JsonReadable<T> jsonReadable) {
            this.token = jsonReadable;
            if (jsonReadable == null) {
                throw new NullPointerException();
            }
            if (JsonTokens.isJsonSimpleable(jsonReadable)) {
                throw new JsonException(jsonReadable + " is a JsonSimpleable JsonReadable");
            }
            this.type = Array.newInstance(jsonReadable.getType(), 0).getClass();
        }

        @Override
        public T[] convertFrom(JsonReader jsonReader) {
            JsonArrayList jsonArrayList = JsonPool.pollJsonArrayList();
            jsonReader.offer(jsonArrayList);
            jsonReader.checkArray();
            JsonReadable<T> jsonReadable = this.token;
            while (jsonReader.hasNext()) {
                jsonArrayList.add(jsonReadable.convertFrom(jsonReader));
            }
            jsonReader.poll();
            T[] TArray = jsonArrayList.toArray(this.token.getType());
            JsonPool.offer(jsonArrayList);
            return TArray;
        }

        @Override
        public Class<T[]> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonSimpleCollectionToken<T>
    extends JsonToken<Collection<T>> {
        private final Class<Collection<T>> type;
        private final JsonCreatable<Collection<T>> creator;
        private final JsonReadable<T> token;

        public JsonSimpleCollectionToken(Class<Collection<T>> clazz, JsonReadable<T> jsonReadable) {
            this.type = clazz;
            this.creator = JsonFactory.loadJsonCreator(clazz);
            this.token = jsonReadable;
            if (!JsonTokens.isJsonSimpleable(jsonReadable)) {
                throw new JsonException(jsonReadable + " is not a JsonSimpleable JsonReadable");
            }
        }

        @Override
        public Collection<T> convertFrom(JsonReader jsonReader) {
            jsonReader.checkArray();
            Collection<T> collection = this.creator.create();
            JsonReadable<T> jsonReadable = this.token;
            while (jsonReader.hasNext()) {
                collection.add(jsonReadable.convertFrom(jsonReader));
            }
            return collection;
        }

        @Override
        public Class<Collection<T>> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return true;
        }

        public String toString() {
            return "JsonSimpleCollectionToken{token:" + this.token + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonObjectCollectionToken<T>
    extends JsonToken<Collection<T>> {
        private final Class<Collection<T>> type;
        private final JsonCreatable<Collection<T>> creator;
        private final JsonReadable<T> token;

        public JsonObjectCollectionToken(Class<Collection<T>> clazz, JsonReadable<T> jsonReadable) {
            this.type = clazz;
            this.creator = JsonFactory.loadJsonCreator(clazz);
            this.token = jsonReadable;
            if (JsonTokens.isJsonSimpleable(jsonReadable)) {
                throw new JsonException(jsonReadable + " is a JsonSimpleable JsonReadable");
            }
        }

        @Override
        public Collection<T> convertFrom(JsonReader jsonReader) {
            if (!jsonReader.checkArray()) {
                return (Collection)JsonReferToken.instance.convertFrom(jsonReader);
            }
            Collection<T> collection = this.creator.create();
            jsonReader.offer(collection);
            JsonReadable<T> jsonReadable = this.token;
            while (jsonReader.hasNext()) {
                collection.add(jsonReadable.convertFrom(jsonReader));
            }
            jsonReader.poll();
            return collection;
        }

        @Override
        public Class<Collection<T>> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonSimpleMapToken<K, V>
    extends JsonToken<Map<K, V>> {
        private final Class<Map<K, V>> type;
        private final JsonCreatable<Map<K, V>> creator;
        private final JsonListener<K> listener;
        private final JsonReadable<V> token;

        public JsonSimpleMapToken(Class<Map<K, V>> clazz, JsonListener<K> jsonListener, JsonReadable<V> jsonReadable) {
            this.type = clazz;
            this.listener = jsonListener;
            this.token = jsonReadable;
            this.creator = JsonFactory.loadJsonCreator(clazz);
            if (!JsonTokens.isJsonSimpleable(jsonReadable)) {
                throw new JsonException(jsonReadable + " is not a JsonSimpleable JsonReadable");
            }
        }

        @Override
        public Map<K, V> convertFrom(JsonReader jsonReader) {
            jsonReader.checkObject();
            Map<K, V> map = this.creator.create();
            while (jsonReader.hasNext()) {
                K k = this.listener.convertFrom(jsonReader);
                jsonReader.checkColon();
                V v = this.token.convertFrom(jsonReader);
                map.put(k, v);
            }
            return map;
        }

        @Override
        public Class<Map<K, V>> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JsonObjectMapToken<K, V>
    extends JsonToken<Map<K, V>> {
        private final Class<Map<K, V>> type;
        private final JsonCreatable<Map<K, V>> creator;
        private final JsonListener<K> listener;
        private final JsonReadable<V> token;

        public JsonObjectMapToken(Class<Map<K, V>> clazz, JsonListener<K> jsonListener, JsonReadable<V> jsonReadable) {
            this.type = clazz;
            this.listener = jsonListener;
            this.token = jsonReadable;
            this.creator = JsonFactory.loadJsonCreator(clazz);
            if (JsonTokens.isJsonSimpleable(jsonReadable)) {
                throw new JsonException(jsonReadable + " is a JsonSimpleable JsonReadable");
            }
        }

        @Override
        public Map<K, V> convertFrom(JsonReader jsonReader) {
            jsonReader.checkObject();
            Map<K, V> map = this.creator.create();
            jsonReader.offer(map);
            while (jsonReader.hasNext()) {
                K k = this.listener.convertFrom(jsonReader);
                jsonReader.checkColon();
                V v = this.token.convertFrom(jsonReader);
                map.put(k, v);
            }
            jsonReader.poll();
            return map;
        }

        @Override
        public Class<Map<K, V>> getType() {
            return this.type;
        }

        @Override
        public boolean isSimpled() {
            return false;
        }
    }
}

