/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonException;
import com.tencent.tendon.convert.json.JsonPool;
import com.tencent.tendon.convert.json.JsonStack;

public abstract class JsonWriter {
    protected JsonStack stack;
    protected int count;

    public final void offer(Object object) {
        if (this.stack == null) {
            this.stack = JsonPool.pollJsonStack();
        }
        this.stack.offer(object);
    }

    public final void poll() {
        if (this.stack != null) {
            this.stack.poll();
        }
    }

    public final boolean writeRefer(Object object) {
        if (this.stack == null) {
            return false;
        }
        int n = this.stack.indexOf(object);
        if (n > -1) {
            int n2 = this.stack.size() - n;
            if (n2 < 0) {
                throw new JsonException("the refer deep  value(" + n2 + ") is illegal");
            }
            this.write('{', '\"', '@', '\"', ':', '\"');
            for (int i = 0; i < n2; ++i) {
                this.write('@');
            }
            this.write('\"', '}');
            return true;
        }
        return false;
    }

    public final int count() {
        return this.count;
    }

    public final void count(int n) {
        if (n >= 0) {
            this.count = n;
        }
    }

    public final void writeNull() {
        this.write('n', 'u', 'l', 'l');
    }

    public void release() {
        this.count = 0;
        if (this.stack != null) {
            JsonPool.offer(this.stack);
            this.stack = null;
        }
    }

    public abstract char[] expand(int var1);

    public abstract void write(char var1);

    public abstract void write(char ... var1);

    public abstract void write(char[] var1, int var2, int var3);

    public abstract boolean indirect();

    public abstract void write(boolean var1, String var2);
}

