/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json;

import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonWriter;

public abstract class JsonXListener {
    private static final char[] CHARS_TUREVALUE = "true".toCharArray();
    private static final char[] CHARS_FALSEVALUE = "false".toCharArray();
    private static final char[] CHARS_INT_MINVALUE = "-2147483648".toCharArray();
    private static final char[] CHARS_LONG_MINVALUE = "-9223372036854775808".toCharArray();
    private static JsonXListener instance = new JsonDefaultXListener();
    private static final int[] intSizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static JsonXListener getInstance() {
        return instance;
    }

    public static void setInstance(JsonXListener jsonXListener) {
        if (jsonXListener != null) {
            instance = jsonXListener;
        }
    }

    public void convertBooleanTo(JsonWriter jsonWriter, boolean bl) {
        jsonWriter.write(bl ? CHARS_TUREVALUE : CHARS_FALSEVALUE);
    }

    public boolean convertBooleanFrom(JsonReader jsonReader) {
        char[] cArray = jsonReader.readValue();
        if (cArray.length == 1 && cArray[0] == '1') {
            return true;
        }
        if (cArray.length != 4) {
            return false;
        }
        if (cArray[0] == 't' && cArray[1] == 'r' && cArray[2] == 'u' && cArray[3] == 'e') {
            return true;
        }
        return cArray[0] == 'T' && cArray[1] == 'R' && cArray[2] == 'U' && cArray[3] == 'E';
    }

    public void convertByteTo(JsonWriter jsonWriter, byte by) {
        this.convertIntTo0(jsonWriter, by);
    }

    public byte convertByteFrom(JsonReader jsonReader) {
        return (byte)jsonReader.readInt();
    }

    public void convertShortTo(JsonWriter jsonWriter, short s) {
        this.convertIntTo0(jsonWriter, s);
    }

    public short convertShortFrom(JsonReader jsonReader) {
        return (short)jsonReader.readInt();
    }

    public void convertCharTo(JsonWriter jsonWriter, char c) {
        this.convertIntTo0(jsonWriter, c);
    }

    public char convertCharFrom(JsonReader jsonReader) {
        return (char)jsonReader.readInt();
    }

    public void convertIntTo(JsonWriter jsonWriter, int n) {
        this.convertIntTo0(jsonWriter, n);
    }

    private void convertIntTo0(JsonWriter jsonWriter, int n) {
        int n2;
        int n3;
        int n4;
        if (n == Integer.MIN_VALUE) {
            jsonWriter.write(CHARS_INT_MINVALUE);
            return;
        }
        int n5 = n;
        int n6 = JsonXListener.intStringSize(n5 < 0 ? -n5 : n5);
        char[] cArray = jsonWriter.expand(n6 + (n5 < 0 ? 1 : 0));
        boolean bl = jsonWriter.indirect();
        int n7 = n4 = bl ? 0 : jsonWriter.count();
        if (n5 < 0) {
            cArray[n4++] = 45;
            n5 = -n5;
        }
        int n8 = n4 + n6;
        while (n5 >= 65536) {
            n3 = n5 / 100;
            n2 = n5 - ((n3 << 6) + (n3 << 5) + (n3 << 2));
            n5 = n3;
            cArray[--n8] = DigitOnes[n2];
            cArray[--n8] = DigitTens[n2];
        }
        char[] cArray2 = digits;
        do {
            n3 = n5 * 52429 >>> 19;
            n2 = n5 - ((n3 << 3) + (n3 << 1));
            cArray[--n8] = cArray2[n2];
        } while ((n5 = n3) != 0);
        jsonWriter.count(n4 + n6);
        if (bl) {
            jsonWriter.write(cArray);
        }
    }

    public int convertIntFrom(JsonReader jsonReader) {
        return jsonReader.readInt();
    }

    public void convertFloatTo(JsonWriter jsonWriter, float f) {
        jsonWriter.write(false, String.valueOf(f));
    }

    public float convertFloatFrom(JsonReader jsonReader) {
        char[] cArray = jsonReader.readValue();
        if (cArray == null) {
            return 0.0f;
        }
        return Float.parseFloat(new String(cArray));
    }

    public void convertLongTo(JsonWriter jsonWriter, long l) {
        int n;
        int n2;
        int n3;
        if (l == Long.MIN_VALUE) {
            jsonWriter.write(CHARS_LONG_MINVALUE);
            return;
        }
        long l2 = l;
        int n4 = JsonXListener.longStringSize(l2 < 0L ? -l2 : l2);
        char[] cArray = jsonWriter.expand(n4 + (l2 < 0L ? 1 : 0));
        boolean bl = jsonWriter.indirect();
        int n5 = n3 = bl ? 0 : jsonWriter.count();
        if (l2 < 0L) {
            cArray[n3++] = 45;
            l2 = -l2;
        }
        int n6 = n3 + n4;
        while (l2 > Integer.MAX_VALUE) {
            long l3 = l2 / 100L;
            n2 = (int)(l2 - ((l3 << 6) + (l3 << 5) + (l3 << 2)));
            l2 = l3;
            cArray[--n6] = DigitOnes[n2];
            cArray[--n6] = DigitTens[n2];
        }
        int n7 = (int)l2;
        while (n7 >= 65536) {
            n = n7 / 100;
            n2 = n7 - ((n << 6) + (n << 5) + (n << 2));
            n7 = n;
            cArray[--n6] = DigitOnes[n2];
            cArray[--n6] = DigitTens[n2];
        }
        do {
            n = n7 * 52429 >>> 19;
            n2 = n7 - ((n << 3) + (n << 1));
            cArray[--n6] = digits[n2];
        } while ((n7 = n) != 0);
        jsonWriter.count(n3 + n4);
        if (bl) {
            jsonWriter.write(cArray);
        }
    }

    public long convertLongFrom(JsonReader jsonReader) {
        return jsonReader.readLong();
    }

    public void convertDoubleTo(JsonWriter jsonWriter, double d) {
        jsonWriter.write(false, String.valueOf(d));
    }

    public double convertDoubleFrom(JsonReader jsonReader) {
        char[] cArray = jsonReader.readValue();
        if (cArray == null) {
            return 0.0;
        }
        return Double.parseDouble(new String(cArray));
    }

    public void convertStringTo(JsonWriter jsonWriter, String string) {
        if (string == null) {
            jsonWriter.writeNull();
            return;
        }
        char[] cArray = jsonWriter.expand(string.length() * 2);
        boolean bl = jsonWriter.indirect();
        int n = bl ? 0 : jsonWriter.count();
        cArray[n++] = 34;
        for (char c : string.toCharArray()) {
            if (c == '\"' || c == '\n' || c == '\r' || c == '\t' || c == '\\') {
                cArray[n++] = 92;
            }
            cArray[n++] = c;
        }
        cArray[n++] = 34;
        jsonWriter.count(n);
        if (bl) {
            jsonWriter.write(cArray, 0, n);
        }
    }

    public String convertStringFrom(JsonReader jsonReader) {
        return jsonReader.readString();
    }

    private static int intStringSize(int n) {
        int n2 = 0;
        while (n > intSizeTable[n2]) {
            ++n2;
        }
        return n2 + 1;
    }

    private static int longStringSize(long l) {
        long l2 = 10L;
        for (int i = 1; i < 19; ++i) {
            if (l < l2) {
                return i;
            }
            l2 = 10L * l2;
        }
        return 19;
    }

    private static final class JsonDefaultXListener
    extends JsonXListener {
        private JsonDefaultXListener() {
        }
    }
}

