/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.printers;

import com.tencent.tendon.convert.json.JsonPrinter;
import com.tencent.tendon.convert.json.JsonWriter;
import com.tencent.tendon.convert.json.JsonXListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonShortArrayPrinter
extends JsonPrinter<short[]> {
    public static final JsonShortArrayPrinter instance = new JsonShortArrayPrinter();
    private static final JsonXListener listener = JsonXListener.getInstance();

    private JsonShortArrayPrinter() {
    }

    @Override
    public final void convertTo(JsonWriter jsonWriter, short[] sArray) {
        short[] sArray2 = sArray;
        if (sArray2 == null) {
            jsonWriter.writeNull();
            return;
        }
        if (sArray2.length == 0) {
            jsonWriter.write('[', ']');
            return;
        }
        jsonWriter.write('[');
        boolean bl = true;
        for (short s : sArray2) {
            if (!bl) {
                jsonWriter.write(',');
            }
            listener.convertShortTo(jsonWriter, s);
            if (!bl) continue;
            bl = false;
        }
        jsonWriter.write(']');
    }

    @Override
    public Class<short[]> getType() {
        return short[].class;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

