/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.printers;

import com.tencent.tendon.convert.json.JsonPrinter;
import com.tencent.tendon.convert.json.JsonWriter;
import com.tencent.tendon.convert.json.JsonXListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonStringArrayPrinter
extends JsonPrinter<String[]> {
    public static final JsonStringArrayPrinter instance = new JsonStringArrayPrinter();
    private static final JsonXListener listener = JsonXListener.getInstance();

    private JsonStringArrayPrinter() {
    }

    @Override
    public final void convertTo(JsonWriter jsonWriter, String[] stringArray) {
        String[] stringArray2 = stringArray;
        if (stringArray2 == null) {
            jsonWriter.writeNull();
            return;
        }
        if (stringArray2.length == 0) {
            jsonWriter.write('[', ']');
            return;
        }
        jsonWriter.write('[');
        boolean bl = true;
        for (String string : stringArray2) {
            if (!bl) {
                jsonWriter.write(',');
            }
            listener.convertStringTo(jsonWriter, string);
            if (!bl) continue;
            bl = false;
        }
        jsonWriter.write(']');
    }

    @Override
    public Class<String[]> getType() {
        return String[].class;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

