/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.tokens;

import com.tencent.tendon.convert.json.JsonPoolable;
import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonToken;
import com.tencent.tendon.convert.json.JsonXListener;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonCharArrayToken
extends JsonToken<char[]> {
    public static final JsonCharArrayToken instance = new JsonCharArrayToken();
    private static final JsonXListener listener = JsonXListener.getInstance();

    @Override
    public char[] convertFrom(JsonReader jsonReader) {
        JsonCharArrayList jsonCharArrayList = JsonCharArrayList.poll();
        jsonReader.checkArray();
        while (jsonReader.hasNext()) {
            jsonCharArrayList.add(listener.convertCharFrom(jsonReader));
        }
        char[] cArray = jsonCharArrayList.toArray();
        JsonCharArrayList.offer(jsonCharArrayList);
        return cArray;
    }

    @Override
    public Class<char[]> getType() {
        return char[].class;
    }

    public Class getComponentType() {
        return Character.TYPE;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static final class JsonCharArrayList
    implements JsonPoolable {
        private static final Queue<JsonCharArrayList> queue = new ArrayBlockingQueue<JsonCharArrayList>(Math.max(Runtime.getRuntime().availableProcessors(), 2) * 2);
        private char[] data;
        private int size;

        public static JsonCharArrayList poll() {
            JsonCharArrayList jsonCharArrayList = queue.poll();
            if (jsonCharArrayList == null) {
                jsonCharArrayList = new JsonCharArrayList();
            } else {
                jsonCharArrayList.prepare();
            }
            return jsonCharArrayList;
        }

        public static void offer(JsonCharArrayList jsonCharArrayList) {
            if (jsonCharArrayList != null) {
                jsonCharArrayList.release();
                queue.offer(jsonCharArrayList);
            }
        }

        public JsonCharArrayList() {
            this(8);
        }

        public JsonCharArrayList(int n) {
            this.data = new char[n];
        }

        private void grow() {
            char[] cArray = new char[this.data.length + 8];
            System.arraycopy(this.data, 0, cArray, 0, this.size);
            this.data = cArray;
        }

        public void add(char c) {
            if (this.size == this.data.length) {
                this.grow();
            }
            this.data[this.size++] = c;
        }

        public char[] toArray() {
            if (this.size == this.data.length) {
                return this.data;
            }
            char[] cArray = new char[this.size];
            System.arraycopy(this.data, 0, cArray, 0, this.size);
            return cArray;
        }

        public void prepare() {
        }

        public void release() {
            this.size = 0;
            this.data = new char[8];
        }

        public void clear() {
            this.release();
        }
    }
}

